/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.legaldocumentation.common.UmbrellaAgreementEntity;
import cdm.legaldocumentation.common.meta.UmbrellaAgreementMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface UmbrellaAgreement
extends RosettaModelObject {
    public static final UmbrellaAgreementMeta metaData = new UmbrellaAgreementMeta();

    public UmbrellaAgreement build();

    public UmbrellaAgreementBuilder toBuilder();

    public Boolean getIsApplicable();

    public String getLanguage();

    public List<? extends UmbrellaAgreementEntity> getParties();

    default public RosettaMetaData<? extends UmbrellaAgreement> metaData() {
        return metaData;
    }

    public static UmbrellaAgreementBuilder builder() {
        return new UmbrellaAgreementBuilderImpl();
    }

    default public Class<? extends UmbrellaAgreement> getType() {
        return UmbrellaAgreement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("language"), String.class, (Object)this.getLanguage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parties"), processor, UmbrellaAgreementEntity.class, this.getParties(), new AttributeMeta[0]);
    }

    public static class UmbrellaAgreementBuilderImpl
    implements UmbrellaAgreementBuilder {
        protected Boolean isApplicable;
        protected String language;
        protected List<UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder> parties = new ArrayList<UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder>();

        @Override
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        @Override
        public List<? extends UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder> getParties() {
            return this.parties;
        }

        @Override
        public UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder getOrCreateParties(int _index) {
            if (this.parties == null) {
                this.parties = new ArrayList<UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder>();
            }
            return (UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder)this.getIndex(this.parties, _index, () -> {
                UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder newParties = UmbrellaAgreementEntity.builder();
                return newParties;
            });
        }

        @Override
        public UmbrellaAgreementBuilder setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable == null ? null : isApplicable;
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder setLanguage(String language) {
            this.language = language == null ? null : language;
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder addParties(UmbrellaAgreementEntity parties) {
            if (parties != null) {
                this.parties.add(parties.toBuilder());
            }
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder addParties(UmbrellaAgreementEntity parties, int _idx) {
            this.getIndex(this.parties, _idx, () -> parties.toBuilder());
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder addParties(List<? extends UmbrellaAgreementEntity> partiess) {
            if (partiess != null) {
                for (UmbrellaAgreementEntity umbrellaAgreementEntity : partiess) {
                    this.parties.add(umbrellaAgreementEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder setParties(List<? extends UmbrellaAgreementEntity> partiess) {
            this.parties = partiess == null ? new ArrayList<UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder>() : (List)partiess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public UmbrellaAgreement build() {
            return new UmbrellaAgreementImpl(this);
        }

        @Override
        public UmbrellaAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder prune() {
            this.parties = this.parties.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIsApplicable() != null) {
                return true;
            }
            if (this.getLanguage() != null) {
                return true;
            }
            return this.getParties() != null && this.getParties().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public UmbrellaAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            UmbrellaAgreementBuilder o = (UmbrellaAgreementBuilder)other;
            merger.mergeRosetta(this.getParties(), o.getParties(), this::getOrCreateParties);
            merger.mergeBasic((Object)this.getIsApplicable(), (Object)o.getIsApplicable(), this::setIsApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLanguage(), (Object)o.getLanguage(), this::setLanguage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UmbrellaAgreement _that = this.getType().cast(o);
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.language, _that.getLanguage())) {
                return false;
            }
            return ListEquals.listEquals(this.parties, _that.getParties());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.language != null ? this.language.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UmbrellaAgreementBuilder {isApplicable=" + this.isApplicable + ", language=" + this.language + ", parties=" + this.parties + '}';
        }
    }

    public static class UmbrellaAgreementImpl
    implements UmbrellaAgreement {
        private final Boolean isApplicable;
        private final String language;
        private final List<? extends UmbrellaAgreementEntity> parties;

        protected UmbrellaAgreementImpl(UmbrellaAgreementBuilder builder) {
            this.isApplicable = builder.getIsApplicable();
            this.language = builder.getLanguage();
            this.parties = Optional.ofNullable(builder.getParties()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        @Override
        public List<? extends UmbrellaAgreementEntity> getParties() {
            return this.parties;
        }

        @Override
        public UmbrellaAgreement build() {
            return this;
        }

        @Override
        public UmbrellaAgreementBuilder toBuilder() {
            UmbrellaAgreementBuilder builder = UmbrellaAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(UmbrellaAgreementBuilder builder) {
            Optional.ofNullable(this.getIsApplicable()).ifPresent(builder::setIsApplicable);
            Optional.ofNullable(this.getLanguage()).ifPresent(builder::setLanguage);
            Optional.ofNullable(this.getParties()).ifPresent(builder::setParties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UmbrellaAgreement _that = this.getType().cast(o);
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.language, _that.getLanguage())) {
                return false;
            }
            return ListEquals.listEquals(this.parties, _that.getParties());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.language != null ? this.language.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UmbrellaAgreement {isApplicable=" + this.isApplicable + ", language=" + this.language + ", parties=" + this.parties + '}';
        }
    }

    public static interface UmbrellaAgreementBuilder
    extends UmbrellaAgreement,
    RosettaModelObjectBuilder {
        public UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder getOrCreateParties(int var1);

        public List<? extends UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder> getParties();

        public UmbrellaAgreementBuilder setIsApplicable(Boolean var1);

        public UmbrellaAgreementBuilder setLanguage(String var1);

        public UmbrellaAgreementBuilder addParties(UmbrellaAgreementEntity var1);

        public UmbrellaAgreementBuilder addParties(UmbrellaAgreementEntity var1, int var2);

        public UmbrellaAgreementBuilder addParties(List<? extends UmbrellaAgreementEntity> var1);

        public UmbrellaAgreementBuilder setParties(List<? extends UmbrellaAgreementEntity> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("language"), String.class, (Object)this.getLanguage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parties"), processor, UmbrellaAgreementEntity.UmbrellaAgreementEntityBuilder.class, this.getParties(), new AttributeMeta[0]);
        }

        public UmbrellaAgreementBuilder prune();
    }
}

