/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum MatrixTypeEnum {
    CREDIT_DERIVATIVES_PHYSICAL_SETTLEMENT_MATRIX,
    EQUITY_DERIVATIVES_MATRIX,
    SETTLEMENT_MATRIX;

    private static Map<String, MatrixTypeEnum> values;
    private final String displayName;

    private MatrixTypeEnum() {
        this(null);
    }

    private MatrixTypeEnum(String displayName) {
        this.displayName = displayName;
    }

    public static MatrixTypeEnum fromDisplayName(String name) {
        MatrixTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, MatrixTypeEnum> map = new ConcurrentHashMap<String, MatrixTypeEnum>();
        for (MatrixTypeEnum instance : MatrixTypeEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

