/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.legaldocumentation.common.AgreementName;
import cdm.legaldocumentation.common.GoverningLawEnum;
import cdm.legaldocumentation.common.LegalAgreementPublisherEnum;
import cdm.legaldocumentation.common.meta.LegalAgreementIdentificationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface LegalAgreementIdentification
extends RosettaModelObject {
    public static final LegalAgreementIdentificationMeta metaData = new LegalAgreementIdentificationMeta();

    public LegalAgreementIdentification build();

    public LegalAgreementIdentificationBuilder toBuilder();

    public AgreementName getAgreementName();

    public GoverningLawEnum getGoverningLaw();

    public LegalAgreementPublisherEnum getPublisher();

    public Integer getVintage();

    default public RosettaMetaData<? extends LegalAgreementIdentification> metaData() {
        return metaData;
    }

    public static LegalAgreementIdentificationBuilder builder() {
        return new LegalAgreementIdentificationBuilderImpl();
    }

    default public Class<? extends LegalAgreementIdentification> getType() {
        return LegalAgreementIdentification.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("governingLaw"), GoverningLawEnum.class, (Object)this.getGoverningLaw(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publisher"), LegalAgreementPublisherEnum.class, (Object)this.getPublisher(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("vintage"), Integer.class, (Object)this.getVintage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementName"), processor, AgreementName.class, this.getAgreementName(), new AttributeMeta[0]);
    }

    public static class LegalAgreementIdentificationBuilderImpl
    implements LegalAgreementIdentificationBuilder {
        protected AgreementName.AgreementNameBuilder agreementName;
        protected GoverningLawEnum governingLaw;
        protected LegalAgreementPublisherEnum publisher;
        protected Integer vintage;

        @Override
        public AgreementName.AgreementNameBuilder getAgreementName() {
            return this.agreementName;
        }

        @Override
        public AgreementName.AgreementNameBuilder getOrCreateAgreementName() {
            AgreementName.AgreementNameBuilder result = this.agreementName != null ? this.agreementName : (this.agreementName = AgreementName.builder());
            return result;
        }

        @Override
        public GoverningLawEnum getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        public LegalAgreementPublisherEnum getPublisher() {
            return this.publisher;
        }

        @Override
        public Integer getVintage() {
            return this.vintage;
        }

        @Override
        public LegalAgreementIdentificationBuilder setAgreementName(AgreementName agreementName) {
            this.agreementName = agreementName == null ? null : agreementName.toBuilder();
            return this;
        }

        @Override
        public LegalAgreementIdentificationBuilder setGoverningLaw(GoverningLawEnum governingLaw) {
            this.governingLaw = governingLaw == null ? null : governingLaw;
            return this;
        }

        @Override
        public LegalAgreementIdentificationBuilder setPublisher(LegalAgreementPublisherEnum publisher) {
            this.publisher = publisher == null ? null : publisher;
            return this;
        }

        @Override
        public LegalAgreementIdentificationBuilder setVintage(Integer vintage) {
            this.vintage = vintage == null ? null : vintage;
            return this;
        }

        @Override
        public LegalAgreementIdentification build() {
            return new LegalAgreementIdentificationImpl(this);
        }

        @Override
        public LegalAgreementIdentificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalAgreementIdentificationBuilder prune() {
            if (this.agreementName != null && !this.agreementName.prune().hasData()) {
                this.agreementName = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAgreementName() != null && this.getAgreementName().hasData()) {
                return true;
            }
            if (this.getGoverningLaw() != null) {
                return true;
            }
            if (this.getPublisher() != null) {
                return true;
            }
            return this.getVintage() != null;
        }

        public LegalAgreementIdentificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegalAgreementIdentificationBuilder o = (LegalAgreementIdentificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementName(), (RosettaModelObjectBuilder)o.getAgreementName(), this::setAgreementName);
            merger.mergeBasic((Object)this.getGoverningLaw(), (Object)o.getGoverningLaw(), this::setGoverningLaw, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPublisher(), (Object)o.getPublisher(), this::setPublisher, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVintage(), (Object)o.getVintage(), this::setVintage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalAgreementIdentification _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementName, _that.getAgreementName())) {
                return false;
            }
            if (!Objects.equals((Object)this.governingLaw, (Object)_that.getGoverningLaw())) {
                return false;
            }
            if (!Objects.equals((Object)this.publisher, (Object)_that.getPublisher())) {
                return false;
            }
            return Objects.equals(this.vintage, _that.getVintage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementName != null ? this.agreementName.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? ((Object)((Object)this.governingLaw)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.publisher != null ? ((Object)((Object)this.publisher)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.vintage != null ? this.vintage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalAgreementIdentificationBuilder {agreementName=" + this.agreementName + ", governingLaw=" + (Object)((Object)this.governingLaw) + ", publisher=" + (Object)((Object)this.publisher) + ", vintage=" + this.vintage + '}';
        }
    }

    public static class LegalAgreementIdentificationImpl
    implements LegalAgreementIdentification {
        private final AgreementName agreementName;
        private final GoverningLawEnum governingLaw;
        private final LegalAgreementPublisherEnum publisher;
        private final Integer vintage;

        protected LegalAgreementIdentificationImpl(LegalAgreementIdentificationBuilder builder) {
            this.agreementName = Optional.ofNullable(builder.getAgreementName()).map(f -> f.build()).orElse(null);
            this.governingLaw = builder.getGoverningLaw();
            this.publisher = builder.getPublisher();
            this.vintage = builder.getVintage();
        }

        @Override
        public AgreementName getAgreementName() {
            return this.agreementName;
        }

        @Override
        public GoverningLawEnum getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        public LegalAgreementPublisherEnum getPublisher() {
            return this.publisher;
        }

        @Override
        public Integer getVintage() {
            return this.vintage;
        }

        @Override
        public LegalAgreementIdentification build() {
            return this;
        }

        @Override
        public LegalAgreementIdentificationBuilder toBuilder() {
            LegalAgreementIdentificationBuilder builder = LegalAgreementIdentification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalAgreementIdentificationBuilder builder) {
            Optional.ofNullable(this.getAgreementName()).ifPresent(builder::setAgreementName);
            Optional.ofNullable(this.getGoverningLaw()).ifPresent(builder::setGoverningLaw);
            Optional.ofNullable(this.getPublisher()).ifPresent(builder::setPublisher);
            Optional.ofNullable(this.getVintage()).ifPresent(builder::setVintage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalAgreementIdentification _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementName, _that.getAgreementName())) {
                return false;
            }
            if (!Objects.equals((Object)this.governingLaw, (Object)_that.getGoverningLaw())) {
                return false;
            }
            if (!Objects.equals((Object)this.publisher, (Object)_that.getPublisher())) {
                return false;
            }
            return Objects.equals(this.vintage, _that.getVintage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementName != null ? this.agreementName.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? ((Object)((Object)this.governingLaw)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.publisher != null ? ((Object)((Object)this.publisher)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.vintage != null ? this.vintage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalAgreementIdentification {agreementName=" + this.agreementName + ", governingLaw=" + (Object)((Object)this.governingLaw) + ", publisher=" + (Object)((Object)this.publisher) + ", vintage=" + this.vintage + '}';
        }
    }

    public static interface LegalAgreementIdentificationBuilder
    extends LegalAgreementIdentification,
    RosettaModelObjectBuilder {
        public AgreementName.AgreementNameBuilder getOrCreateAgreementName();

        @Override
        public AgreementName.AgreementNameBuilder getAgreementName();

        public LegalAgreementIdentificationBuilder setAgreementName(AgreementName var1);

        public LegalAgreementIdentificationBuilder setGoverningLaw(GoverningLawEnum var1);

        public LegalAgreementIdentificationBuilder setPublisher(LegalAgreementPublisherEnum var1);

        public LegalAgreementIdentificationBuilder setVintage(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("governingLaw"), GoverningLawEnum.class, (Object)this.getGoverningLaw(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publisher"), LegalAgreementPublisherEnum.class, (Object)this.getPublisher(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("vintage"), Integer.class, (Object)this.getVintage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementName"), processor, AgreementName.AgreementNameBuilder.class, this.getAgreementName(), new AttributeMeta[0]);
        }

        public LegalAgreementIdentificationBuilder prune();
    }
}

