/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.AgreementTerms;
import cdm.legaldocumentation.common.LegalAgreementBase;
import cdm.legaldocumentation.common.LegalAgreementIdentification;
import cdm.legaldocumentation.common.Resource;
import cdm.legaldocumentation.common.UmbrellaAgreement;
import cdm.legaldocumentation.common.meta.LegalAgreementMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface LegalAgreement
extends LegalAgreementBase,
GlobalKey {
    public static final LegalAgreementMeta metaData = new LegalAgreementMeta();

    @Override
    public LegalAgreement build();

    @Override
    public LegalAgreementBuilder toBuilder();

    public AgreementTerms getAgreementTerms();

    public MetaFields getMeta();

    public List<? extends LegalAgreement> getRelatedAgreements();

    public UmbrellaAgreement getUmbrellaAgreement();

    default public RosettaMetaData<? extends LegalAgreement> metaData() {
        return metaData;
    }

    public static LegalAgreementBuilder builder() {
        return new LegalAgreementBuilderImpl();
    }

    default public Class<? extends LegalAgreement> getType() {
        return LegalAgreement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        LegalAgreementBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("agreementTerms"), processor, AgreementTerms.class, this.getAgreementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedAgreements"), processor, LegalAgreement.class, this.getRelatedAgreements(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("umbrellaAgreement"), processor, UmbrellaAgreement.class, this.getUmbrellaAgreement(), new AttributeMeta[0]);
    }

    public static class LegalAgreementBuilderImpl
    extends LegalAgreementBase.LegalAgreementBaseBuilderImpl
    implements LegalAgreementBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected AgreementTerms.AgreementTermsBuilder agreementTerms;
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<LegalAgreementBuilder> relatedAgreements = new ArrayList<LegalAgreementBuilder>();
        protected UmbrellaAgreement.UmbrellaAgreementBuilder umbrellaAgreement;

        @Override
        public AgreementTerms.AgreementTermsBuilder getAgreementTerms() {
            return this.agreementTerms;
        }

        @Override
        public AgreementTerms.AgreementTermsBuilder getOrCreateAgreementTerms() {
            AgreementTerms.AgreementTermsBuilder result = this.agreementTerms != null ? this.agreementTerms : (this.agreementTerms = AgreementTerms.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<? extends LegalAgreementBuilder> getRelatedAgreements() {
            return this.relatedAgreements;
        }

        @Override
        public LegalAgreementBuilder getOrCreateRelatedAgreements(int _index) {
            if (this.relatedAgreements == null) {
                this.relatedAgreements = new ArrayList<LegalAgreementBuilder>();
            }
            return (LegalAgreementBuilder)this.getIndex(this.relatedAgreements, _index, () -> {
                LegalAgreementBuilder newRelatedAgreements = LegalAgreement.builder();
                return newRelatedAgreements;
            });
        }

        @Override
        public UmbrellaAgreement.UmbrellaAgreementBuilder getUmbrellaAgreement() {
            return this.umbrellaAgreement;
        }

        @Override
        public UmbrellaAgreement.UmbrellaAgreementBuilder getOrCreateUmbrellaAgreement() {
            UmbrellaAgreement.UmbrellaAgreementBuilder result = this.umbrellaAgreement != null ? this.umbrellaAgreement : (this.umbrellaAgreement = UmbrellaAgreement.builder());
            return result;
        }

        @Override
        public LegalAgreementBuilder setAgreementTerms(AgreementTerms agreementTerms) {
            this.agreementTerms = agreementTerms == null ? null : agreementTerms.toBuilder();
            return this;
        }

        @Override
        public LegalAgreementBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement relatedAgreements) {
            if (relatedAgreements != null) {
                this.relatedAgreements.add(relatedAgreements.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement relatedAgreements, int _idx) {
            this.getIndex(this.relatedAgreements, _idx, () -> relatedAgreements.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addRelatedAgreements(List<? extends LegalAgreement> relatedAgreementss) {
            if (relatedAgreementss != null) {
                for (LegalAgreement legalAgreement : relatedAgreementss) {
                    this.relatedAgreements.add(legalAgreement.toBuilder());
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setRelatedAgreements(List<? extends LegalAgreement> relatedAgreementss) {
            this.relatedAgreements = relatedAgreementss == null ? new ArrayList<LegalAgreementBuilder>() : (List)relatedAgreementss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBuilder setUmbrellaAgreement(UmbrellaAgreement umbrellaAgreement) {
            this.umbrellaAgreement = umbrellaAgreement == null ? null : umbrellaAgreement.toBuilder();
            return this;
        }

        @Override
        public LegalAgreementBuilder setAgreementDate(Date agreementDate) {
            this.agreementDate = agreementDate == null ? null : agreementDate;
            return this;
        }

        @Override
        public LegalAgreementBuilder addAttachment(Resource attachment) {
            if (attachment != null) {
                this.attachment.add(attachment.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addAttachment(Resource attachment, int _idx) {
            this.getIndex(this.attachment, _idx, () -> attachment.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addAttachment(List<? extends Resource> attachments) {
            if (attachments != null) {
                for (Resource resource : attachments) {
                    this.attachment.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setAttachment(List<? extends Resource> attachments) {
            this.attachment = attachments == null ? new ArrayList() : (List)attachments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty contractualParty) {
            if (contractualParty != null) {
                this.contractualParty.add(contractualParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty contractualParty, int _idx) {
            this.getIndex(this.contractualParty, _idx, () -> contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party contractualParty) {
            this.getOrCreateContractualParty(-1).setValue(contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party contractualParty, int _idx) {
            this.getOrCreateContractualParty(_idx).setValue(contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            if (contractualPartys != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : contractualPartys) {
                    this.contractualParty.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            this.contractualParty = contractualPartys == null ? new ArrayList() : (List)contractualPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(List<? extends Party> contractualPartys) {
            if (contractualPartys != null) {
                for (Party party : contractualPartys) {
                    this.addContractualPartyValue(party);
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setContractualPartyValue(List<? extends Party> contractualPartys) {
            this.contractualParty.clear();
            if (contractualPartys != null) {
                contractualPartys.forEach(this::addContractualPartyValue);
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier identifier) {
            if (identifier != null) {
                this.identifier.add(identifier.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> identifier.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addIdentifier(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.identifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setIdentifier(List<? extends Identifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBuilder setLegalAgreementIdentification(LegalAgreementIdentification legalAgreementIdentification) {
            this.legalAgreementIdentification = legalAgreementIdentification == null ? null : legalAgreementIdentification.toBuilder();
            return this;
        }

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole otherParty) {
            if (otherParty != null) {
                this.otherParty.add(otherParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole otherParty, int _idx) {
            this.getIndex(this.otherParty, _idx, () -> otherParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addOtherParty(List<? extends PartyRole> otherPartys) {
            if (otherPartys != null) {
                for (PartyRole partyRole : otherPartys) {
                    this.otherParty.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setOtherParty(List<? extends PartyRole> otherPartys) {
            this.otherParty = otherPartys == null ? new ArrayList() : (List)otherPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreement build() {
            return new LegalAgreementImpl(this);
        }

        @Override
        public LegalAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalAgreementBuilder prune() {
            super.prune();
            if (this.agreementTerms != null && !this.agreementTerms.prune().hasData()) {
                this.agreementTerms = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            this.relatedAgreements = this.relatedAgreements.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.umbrellaAgreement != null && !this.umbrellaAgreement.prune().hasData()) {
                this.umbrellaAgreement = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAgreementTerms() != null && this.getAgreementTerms().hasData()) {
                return true;
            }
            if (this.getRelatedAgreements() != null && this.getRelatedAgreements().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getUmbrellaAgreement() != null && this.getUmbrellaAgreement().hasData();
        }

        @Override
        public LegalAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegalAgreementBuilder o = (LegalAgreementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementTerms(), (RosettaModelObjectBuilder)o.getAgreementTerms(), this::setAgreementTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta(this.getRelatedAgreements(), o.getRelatedAgreements(), this::getOrCreateRelatedAgreements);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUmbrellaAgreement(), (RosettaModelObjectBuilder)o.getUmbrellaAgreement(), this::setUmbrellaAgreement);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegalAgreement _that = (LegalAgreement)this.getType().cast(o);
            if (!Objects.equals(this.agreementTerms, _that.getAgreementTerms())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedAgreements, _that.getRelatedAgreements())) {
                return false;
            }
            return Objects.equals(this.umbrellaAgreement, _that.getUmbrellaAgreement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreementTerms != null ? this.agreementTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.relatedAgreements != null ? this.relatedAgreements.hashCode() : 0);
            _result = 31 * _result + (this.umbrellaAgreement != null ? this.umbrellaAgreement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegalAgreementBuilder {agreementTerms=" + this.agreementTerms + ", meta=" + this.meta + ", relatedAgreements=" + this.relatedAgreements + ", umbrellaAgreement=" + this.umbrellaAgreement + '}' + " " + super.toString();
        }
    }

    public static class LegalAgreementImpl
    extends LegalAgreementBase.LegalAgreementBaseImpl
    implements LegalAgreement {
        private final AgreementTerms agreementTerms;
        private final MetaFields meta;
        private final List<? extends LegalAgreement> relatedAgreements;
        private final UmbrellaAgreement umbrellaAgreement;

        protected LegalAgreementImpl(LegalAgreementBuilder builder) {
            super(builder);
            this.agreementTerms = Optional.ofNullable(builder.getAgreementTerms()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.relatedAgreements = Optional.ofNullable(builder.getRelatedAgreements()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.umbrellaAgreement = Optional.ofNullable(builder.getUmbrellaAgreement()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AgreementTerms getAgreementTerms() {
            return this.agreementTerms;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<? extends LegalAgreement> getRelatedAgreements() {
            return this.relatedAgreements;
        }

        @Override
        public UmbrellaAgreement getUmbrellaAgreement() {
            return this.umbrellaAgreement;
        }

        @Override
        public LegalAgreement build() {
            return this;
        }

        @Override
        public LegalAgreementBuilder toBuilder() {
            LegalAgreementBuilder builder = LegalAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalAgreementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAgreementTerms()).ifPresent(builder::setAgreementTerms);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getRelatedAgreements()).ifPresent(builder::setRelatedAgreements);
            Optional.ofNullable(this.getUmbrellaAgreement()).ifPresent(builder::setUmbrellaAgreement);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegalAgreement _that = (LegalAgreement)this.getType().cast(o);
            if (!Objects.equals(this.agreementTerms, _that.getAgreementTerms())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedAgreements, _that.getRelatedAgreements())) {
                return false;
            }
            return Objects.equals(this.umbrellaAgreement, _that.getUmbrellaAgreement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreementTerms != null ? this.agreementTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.relatedAgreements != null ? this.relatedAgreements.hashCode() : 0);
            _result = 31 * _result + (this.umbrellaAgreement != null ? this.umbrellaAgreement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegalAgreement {agreementTerms=" + this.agreementTerms + ", meta=" + this.meta + ", relatedAgreements=" + this.relatedAgreements + ", umbrellaAgreement=" + this.umbrellaAgreement + '}' + " " + super.toString();
        }
    }

    public static interface LegalAgreementBuilder
    extends LegalAgreement,
    LegalAgreementBase.LegalAgreementBaseBuilder,
    RosettaModelObjectBuilder {
        public AgreementTerms.AgreementTermsBuilder getOrCreateAgreementTerms();

        @Override
        public AgreementTerms.AgreementTermsBuilder getAgreementTerms();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public LegalAgreementBuilder getOrCreateRelatedAgreements(int var1);

        public List<? extends LegalAgreementBuilder> getRelatedAgreements();

        public UmbrellaAgreement.UmbrellaAgreementBuilder getOrCreateUmbrellaAgreement();

        @Override
        public UmbrellaAgreement.UmbrellaAgreementBuilder getUmbrellaAgreement();

        public LegalAgreementBuilder setAgreementTerms(AgreementTerms var1);

        public LegalAgreementBuilder setMeta(MetaFields var1);

        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement var1);

        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement var1, int var2);

        public LegalAgreementBuilder addRelatedAgreements(List<? extends LegalAgreement> var1);

        public LegalAgreementBuilder setRelatedAgreements(List<? extends LegalAgreement> var1);

        public LegalAgreementBuilder setUmbrellaAgreement(UmbrellaAgreement var1);

        @Override
        public LegalAgreementBuilder setAgreementDate(Date var1);

        @Override
        public LegalAgreementBuilder addAttachment(Resource var1);

        @Override
        public LegalAgreementBuilder addAttachment(Resource var1, int var2);

        @Override
        public LegalAgreementBuilder addAttachment(List<? extends Resource> var1);

        @Override
        public LegalAgreementBuilder setAttachment(List<? extends Resource> var1);

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty var1);

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty var1, int var2);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party var1);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party var1, int var2);

        @Override
        public LegalAgreementBuilder addContractualParty(List<? extends ReferenceWithMetaParty> var1);

        @Override
        public LegalAgreementBuilder setContractualParty(List<? extends ReferenceWithMetaParty> var1);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(List<? extends Party> var1);

        @Override
        public LegalAgreementBuilder setContractualPartyValue(List<? extends Party> var1);

        @Override
        public LegalAgreementBuilder setEffectiveDate(Date var1);

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier var1);

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier var1, int var2);

        @Override
        public LegalAgreementBuilder addIdentifier(List<? extends Identifier> var1);

        @Override
        public LegalAgreementBuilder setIdentifier(List<? extends Identifier> var1);

        @Override
        public LegalAgreementBuilder setLegalAgreementIdentification(LegalAgreementIdentification var1);

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole var1);

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole var1, int var2);

        @Override
        public LegalAgreementBuilder addOtherParty(List<? extends PartyRole> var1);

        @Override
        public LegalAgreementBuilder setOtherParty(List<? extends PartyRole> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            LegalAgreementBase.LegalAgreementBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("agreementTerms"), processor, AgreementTerms.AgreementTermsBuilder.class, this.getAgreementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedAgreements"), processor, LegalAgreementBuilder.class, this.getRelatedAgreements(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("umbrellaAgreement"), processor, UmbrellaAgreement.UmbrellaAgreementBuilder.class, this.getUmbrellaAgreement(), new AttributeMeta[0]);
        }

        @Override
        public LegalAgreementBuilder prune();
    }
}

