/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.validation.datarule;

import cdm.event.common.EventIntentEnum;
import cdm.event.workflow.EventInstruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="EventInstructionCorporateAction")
@ImplementedBy(value=Default.class)
public interface EventInstructionCorporateAction
extends Validator<EventInstruction> {
    public static final String NAME = "EventInstructionCorporateAction";
    public static final String DEFINITION = "if corporateActionIntent exists then intent = EventIntentEnum -> CorporateActionAdjustment";

    public ValidationResult<EventInstruction> validate(RosettaPath var1, EventInstruction var2);

    public static class NoOp
    implements EventInstructionCorporateAction {
        @Override
        public ValidationResult<EventInstruction> validate(RosettaPath path, EventInstruction eventInstruction) {
            return ValidationResult.success((String)EventInstructionCorporateAction.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventInstruction", (RosettaPath)path, (String)EventInstructionCorporateAction.DEFINITION);
        }
    }

    public static class Default
    implements EventInstructionCorporateAction {
        @Override
        public ValidationResult<EventInstruction> validate(RosettaPath path, EventInstruction eventInstruction) {
            ComparisonResult result = this.executeDataRule(eventInstruction);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)EventInstructionCorporateAction.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventInstruction", (RosettaPath)path, (String)EventInstructionCorporateAction.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition EventInstructionCorporateAction failed.";
            }
            return ValidationResult.failure((String)EventInstructionCorporateAction.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventInstruction", (RosettaPath)path, (String)EventInstructionCorporateAction.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(EventInstruction eventInstruction) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)eventInstruction).map("getCorporateActionIntent", _eventInstruction -> _eventInstruction.getCorporateActionIntent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)eventInstruction).map("getIntent", _eventInstruction -> _eventInstruction.getIntent()), (Mapper)MapperS.of((Object)((Object)EventIntentEnum.CORPORATE_ACTION_ADJUSTMENT)), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

