/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.event.common.ActionEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Lineage;
import cdm.event.workflow.CreditLimitInformation;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.MessageInformation;
import cdm.event.workflow.WorkflowState;
import cdm.event.workflow.WorkflowStepApproval;
import cdm.event.workflow.meta.WorkflowStepMeta;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface WorkflowStep
extends RosettaModelObject,
GlobalKey {
    public static final WorkflowStepMeta metaData = new WorkflowStepMeta();

    public WorkflowStep build();

    public WorkflowStepBuilder toBuilder();

    public List<? extends Account> getAccount();

    public ActionEnum getAction();

    public List<? extends WorkflowStepApproval> getApproval();

    public BusinessEvent getBusinessEvent();

    public CreditLimitInformation getCreditLimitInformation();

    public List<? extends Identifier> getEventIdentifier();

    public Lineage getLineage();

    public MessageInformation getMessageInformation();

    public MetaFields getMeta();

    public EventInstruction getNextEvent();

    public List<? extends Party> getParty();

    public ReferenceWithMetaWorkflowStep getPreviousWorkflowStep();

    public EventInstruction getProposedEvent();

    public Boolean getRejected();

    public List<? extends EventTimestamp> getTimestamp();

    public WorkflowState getWorkflowState();

    default public RosettaMetaData<? extends WorkflowStep> metaData() {
        return metaData;
    }

    public static WorkflowStepBuilder builder() {
        return new WorkflowStepBuilderImpl();
    }

    default public Class<? extends WorkflowStep> getType() {
        return WorkflowStep.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("action"), ActionEnum.class, (Object)this.getAction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rejected"), Boolean.class, (Object)this.getRejected(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("account"), processor, Account.class, this.getAccount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approval"), processor, WorkflowStepApproval.class, this.getApproval(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEvent"), processor, BusinessEvent.class, this.getBusinessEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lineage"), processor, Lineage.class, this.getLineage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("messageInformation"), processor, MessageInformation.class, this.getMessageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nextEvent"), processor, EventInstruction.class, this.getNextEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("previousWorkflowStep"), processor, ReferenceWithMetaWorkflowStep.class, this.getPreviousWorkflowStep(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("proposedEvent"), processor, EventInstruction.class, this.getProposedEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("timestamp"), processor, EventTimestamp.class, this.getTimestamp(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("workflowState"), processor, WorkflowState.class, this.getWorkflowState(), new AttributeMeta[0]);
    }

    public static class WorkflowStepBuilderImpl
    implements WorkflowStepBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<Account.AccountBuilder> account = new ArrayList<Account.AccountBuilder>();
        protected ActionEnum action;
        protected List<WorkflowStepApproval.WorkflowStepApprovalBuilder> approval = new ArrayList<WorkflowStepApproval.WorkflowStepApprovalBuilder>();
        protected BusinessEvent.BusinessEventBuilder businessEvent;
        protected CreditLimitInformation.CreditLimitInformationBuilder creditLimitInformation;
        protected List<Identifier.IdentifierBuilder> eventIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected Lineage.LineageBuilder lineage;
        protected MessageInformation.MessageInformationBuilder messageInformation;
        protected MetaFields.MetaFieldsBuilder meta;
        protected EventInstruction.EventInstructionBuilder nextEvent;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder previousWorkflowStep;
        protected EventInstruction.EventInstructionBuilder proposedEvent;
        protected Boolean rejected;
        protected List<EventTimestamp.EventTimestampBuilder> timestamp = new ArrayList<EventTimestamp.EventTimestampBuilder>();
        protected WorkflowState.WorkflowStateBuilder workflowState;

        @Override
        public List<? extends Account.AccountBuilder> getAccount() {
            return this.account;
        }

        @Override
        public Account.AccountBuilder getOrCreateAccount(int _index) {
            if (this.account == null) {
                this.account = new ArrayList<Account.AccountBuilder>();
            }
            return (Account.AccountBuilder)this.getIndex(this.account, _index, () -> {
                Account.AccountBuilder newAccount = Account.builder();
                return newAccount;
            });
        }

        @Override
        public ActionEnum getAction() {
            return this.action;
        }

        @Override
        public List<? extends WorkflowStepApproval.WorkflowStepApprovalBuilder> getApproval() {
            return this.approval;
        }

        @Override
        public WorkflowStepApproval.WorkflowStepApprovalBuilder getOrCreateApproval(int _index) {
            if (this.approval == null) {
                this.approval = new ArrayList<WorkflowStepApproval.WorkflowStepApprovalBuilder>();
            }
            return (WorkflowStepApproval.WorkflowStepApprovalBuilder)this.getIndex(this.approval, _index, () -> {
                WorkflowStepApproval.WorkflowStepApprovalBuilder newApproval = WorkflowStepApproval.builder();
                return newApproval;
            });
        }

        @Override
        public BusinessEvent.BusinessEventBuilder getBusinessEvent() {
            return this.businessEvent;
        }

        @Override
        public BusinessEvent.BusinessEventBuilder getOrCreateBusinessEvent() {
            BusinessEvent.BusinessEventBuilder result = this.businessEvent != null ? this.businessEvent : (this.businessEvent = BusinessEvent.builder());
            return result;
        }

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation() {
            CreditLimitInformation.CreditLimitInformationBuilder result = this.creditLimitInformation != null ? this.creditLimitInformation : (this.creditLimitInformation = CreditLimitInformation.builder());
            return result;
        }

        @Override
        public List<? extends Identifier.IdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateEventIdentifier(int _index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.eventIdentifier, _index, () -> {
                Identifier.IdentifierBuilder newEventIdentifier = Identifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        public Lineage.LineageBuilder getLineage() {
            return this.lineage;
        }

        @Override
        public Lineage.LineageBuilder getOrCreateLineage() {
            Lineage.LineageBuilder result = this.lineage != null ? this.lineage : (this.lineage = Lineage.builder());
            return result;
        }

        @Override
        public MessageInformation.MessageInformationBuilder getMessageInformation() {
            return this.messageInformation;
        }

        @Override
        public MessageInformation.MessageInformationBuilder getOrCreateMessageInformation() {
            MessageInformation.MessageInformationBuilder result = this.messageInformation != null ? this.messageInformation : (this.messageInformation = MessageInformation.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public EventInstruction.EventInstructionBuilder getNextEvent() {
            return this.nextEvent;
        }

        @Override
        public EventInstruction.EventInstructionBuilder getOrCreateNextEvent() {
            EventInstruction.EventInstructionBuilder result = this.nextEvent != null ? this.nextEvent : (this.nextEvent = EventInstruction.builder());
            return result;
        }

        @Override
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getPreviousWorkflowStep() {
            return this.previousWorkflowStep;
        }

        @Override
        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getOrCreatePreviousWorkflowStep() {
            ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder result = this.previousWorkflowStep != null ? this.previousWorkflowStep : (this.previousWorkflowStep = ReferenceWithMetaWorkflowStep.builder());
            return result;
        }

        @Override
        public EventInstruction.EventInstructionBuilder getProposedEvent() {
            return this.proposedEvent;
        }

        @Override
        public EventInstruction.EventInstructionBuilder getOrCreateProposedEvent() {
            EventInstruction.EventInstructionBuilder result = this.proposedEvent != null ? this.proposedEvent : (this.proposedEvent = EventInstruction.builder());
            return result;
        }

        @Override
        public Boolean getRejected() {
            return this.rejected;
        }

        @Override
        public List<? extends EventTimestamp.EventTimestampBuilder> getTimestamp() {
            return this.timestamp;
        }

        @Override
        public EventTimestamp.EventTimestampBuilder getOrCreateTimestamp(int _index) {
            if (this.timestamp == null) {
                this.timestamp = new ArrayList<EventTimestamp.EventTimestampBuilder>();
            }
            return (EventTimestamp.EventTimestampBuilder)this.getIndex(this.timestamp, _index, () -> {
                EventTimestamp.EventTimestampBuilder newTimestamp = EventTimestamp.builder();
                return newTimestamp;
            });
        }

        @Override
        public WorkflowState.WorkflowStateBuilder getWorkflowState() {
            return this.workflowState;
        }

        @Override
        public WorkflowState.WorkflowStateBuilder getOrCreateWorkflowState() {
            WorkflowState.WorkflowStateBuilder result = this.workflowState != null ? this.workflowState : (this.workflowState = WorkflowState.builder());
            return result;
        }

        @Override
        public WorkflowStepBuilder addAccount(Account account) {
            if (account != null) {
                this.account.add(account.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder addAccount(Account account, int _idx) {
            this.getIndex(this.account, _idx, () -> account.toBuilder());
            return this;
        }

        @Override
        public WorkflowStepBuilder addAccount(List<? extends Account> accounts) {
            if (accounts != null) {
                for (Account account : accounts) {
                    this.account.add(account.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder setAccount(List<? extends Account> accounts) {
            this.account = accounts == null ? new ArrayList<Account.AccountBuilder>() : (List)accounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStepBuilder setAction(ActionEnum action) {
            this.action = action == null ? null : action;
            return this;
        }

        @Override
        public WorkflowStepBuilder addApproval(WorkflowStepApproval approval) {
            if (approval != null) {
                this.approval.add(approval.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder addApproval(WorkflowStepApproval approval, int _idx) {
            this.getIndex(this.approval, _idx, () -> approval.toBuilder());
            return this;
        }

        @Override
        public WorkflowStepBuilder addApproval(List<? extends WorkflowStepApproval> approvals) {
            if (approvals != null) {
                for (WorkflowStepApproval workflowStepApproval : approvals) {
                    this.approval.add(workflowStepApproval.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder setApproval(List<? extends WorkflowStepApproval> approvals) {
            this.approval = approvals == null ? new ArrayList<WorkflowStepApproval.WorkflowStepApprovalBuilder>() : (List)approvals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStepBuilder setBusinessEvent(BusinessEvent businessEvent) {
            this.businessEvent = businessEvent == null ? null : businessEvent.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setCreditLimitInformation(CreditLimitInformation creditLimitInformation) {
            this.creditLimitInformation = creditLimitInformation == null ? null : creditLimitInformation.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder addEventIdentifier(Identifier eventIdentifier) {
            if (eventIdentifier != null) {
                this.eventIdentifier.add(eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder addEventIdentifier(Identifier eventIdentifier, int _idx) {
            this.getIndex(this.eventIdentifier, _idx, () -> eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public WorkflowStepBuilder addEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (Identifier identifier : eventIdentifiers) {
                    this.eventIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder setEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStepBuilder setLineage(Lineage lineage) {
            this.lineage = lineage == null ? null : lineage.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setMessageInformation(MessageInformation messageInformation) {
            this.messageInformation = messageInformation == null ? null : messageInformation.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setNextEvent(EventInstruction nextEvent) {
            this.nextEvent = nextEvent == null ? null : nextEvent.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public WorkflowStepBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStepBuilder setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep previousWorkflowStep) {
            this.previousWorkflowStep = previousWorkflowStep == null ? null : previousWorkflowStep.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setPreviousWorkflowStepValue(WorkflowStep previousWorkflowStep) {
            this.getOrCreatePreviousWorkflowStep().setValue(previousWorkflowStep);
            return this;
        }

        @Override
        public WorkflowStepBuilder setProposedEvent(EventInstruction proposedEvent) {
            this.proposedEvent = proposedEvent == null ? null : proposedEvent.toBuilder();
            return this;
        }

        @Override
        public WorkflowStepBuilder setRejected(Boolean rejected) {
            this.rejected = rejected == null ? null : rejected;
            return this;
        }

        @Override
        public WorkflowStepBuilder addTimestamp(EventTimestamp timestamp) {
            if (timestamp != null) {
                this.timestamp.add(timestamp.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder addTimestamp(EventTimestamp timestamp, int _idx) {
            this.getIndex(this.timestamp, _idx, () -> timestamp.toBuilder());
            return this;
        }

        @Override
        public WorkflowStepBuilder addTimestamp(List<? extends EventTimestamp> timestamps) {
            if (timestamps != null) {
                for (EventTimestamp eventTimestamp : timestamps) {
                    this.timestamp.add(eventTimestamp.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStepBuilder setTimestamp(List<? extends EventTimestamp> timestamps) {
            this.timestamp = timestamps == null ? new ArrayList<EventTimestamp.EventTimestampBuilder>() : (List)timestamps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStepBuilder setWorkflowState(WorkflowState workflowState) {
            this.workflowState = workflowState == null ? null : workflowState.toBuilder();
            return this;
        }

        @Override
        public WorkflowStep build() {
            return new WorkflowStepImpl(this);
        }

        @Override
        public WorkflowStepBuilder toBuilder() {
            return this;
        }

        @Override
        public WorkflowStepBuilder prune() {
            this.account = this.account.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.approval = this.approval.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.businessEvent != null && !this.businessEvent.prune().hasData()) {
                this.businessEvent = null;
            }
            if (this.creditLimitInformation != null && !this.creditLimitInformation.prune().hasData()) {
                this.creditLimitInformation = null;
            }
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lineage != null && !this.lineage.prune().hasData()) {
                this.lineage = null;
            }
            if (this.messageInformation != null && !this.messageInformation.prune().hasData()) {
                this.messageInformation = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.nextEvent != null && !this.nextEvent.prune().hasData()) {
                this.nextEvent = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.previousWorkflowStep != null && !this.previousWorkflowStep.prune().hasData()) {
                this.previousWorkflowStep = null;
            }
            if (this.proposedEvent != null && !this.proposedEvent.prune().hasData()) {
                this.proposedEvent = null;
            }
            this.timestamp = this.timestamp.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.workflowState != null && !this.workflowState.prune().hasData()) {
                this.workflowState = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccount() != null && this.getAccount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAction() != null) {
                return true;
            }
            if (this.getApproval() != null && this.getApproval().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBusinessEvent() != null && this.getBusinessEvent().hasData()) {
                return true;
            }
            if (this.getCreditLimitInformation() != null && this.getCreditLimitInformation().hasData()) {
                return true;
            }
            if (this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLineage() != null && this.getLineage().hasData()) {
                return true;
            }
            if (this.getMessageInformation() != null && this.getMessageInformation().hasData()) {
                return true;
            }
            if (this.getNextEvent() != null && this.getNextEvent().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPreviousWorkflowStep() != null && this.getPreviousWorkflowStep().hasData()) {
                return true;
            }
            if (this.getProposedEvent() != null && this.getProposedEvent().hasData()) {
                return true;
            }
            if (this.getRejected() != null) {
                return true;
            }
            if (this.getTimestamp() != null && this.getTimestamp().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getWorkflowState() != null && this.getWorkflowState().hasData();
        }

        public WorkflowStepBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WorkflowStepBuilder o = (WorkflowStepBuilder)other;
            merger.mergeRosetta(this.getAccount(), o.getAccount(), this::getOrCreateAccount);
            merger.mergeRosetta(this.getApproval(), o.getApproval(), this::getOrCreateApproval);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessEvent(), (RosettaModelObjectBuilder)o.getBusinessEvent(), this::setBusinessEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditLimitInformation(), (RosettaModelObjectBuilder)o.getCreditLimitInformation(), this::setCreditLimitInformation);
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLineage(), (RosettaModelObjectBuilder)o.getLineage(), this::setLineage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMessageInformation(), (RosettaModelObjectBuilder)o.getMessageInformation(), this::setMessageInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNextEvent(), (RosettaModelObjectBuilder)o.getNextEvent(), this::setNextEvent);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPreviousWorkflowStep(), (RosettaModelObjectBuilder)o.getPreviousWorkflowStep(), this::setPreviousWorkflowStep);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProposedEvent(), (RosettaModelObjectBuilder)o.getProposedEvent(), this::setProposedEvent);
            merger.mergeRosetta(this.getTimestamp(), o.getTimestamp(), this::getOrCreateTimestamp);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWorkflowState(), (RosettaModelObjectBuilder)o.getWorkflowState(), this::setWorkflowState);
            merger.mergeBasic((Object)this.getAction(), (Object)o.getAction(), this::setAction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRejected(), (Object)o.getRejected(), this::setRejected, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WorkflowStep _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.approval, _that.getApproval())) {
                return false;
            }
            if (!Objects.equals(this.businessEvent, _that.getBusinessEvent())) {
                return false;
            }
            if (!Objects.equals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!Objects.equals(this.messageInformation, _that.getMessageInformation())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.nextEvent, _that.getNextEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.previousWorkflowStep, _that.getPreviousWorkflowStep())) {
                return false;
            }
            if (!Objects.equals(this.proposedEvent, _that.getProposedEvent())) {
                return false;
            }
            if (!Objects.equals(this.rejected, _that.getRejected())) {
                return false;
            }
            if (!ListEquals.listEquals(this.timestamp, _that.getTimestamp())) {
                return false;
            }
            return Objects.equals(this.workflowState, _that.getWorkflowState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.approval != null ? this.approval.hashCode() : 0);
            _result = 31 * _result + (this.businessEvent != null ? this.businessEvent.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.messageInformation != null ? this.messageInformation.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.nextEvent != null ? this.nextEvent.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.previousWorkflowStep != null ? this.previousWorkflowStep.hashCode() : 0);
            _result = 31 * _result + (this.proposedEvent != null ? this.proposedEvent.hashCode() : 0);
            _result = 31 * _result + (this.rejected != null ? this.rejected.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            _result = 31 * _result + (this.workflowState != null ? this.workflowState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WorkflowStepBuilder {account=" + this.account + ", action=" + (Object)((Object)this.action) + ", approval=" + this.approval + ", businessEvent=" + this.businessEvent + ", creditLimitInformation=" + this.creditLimitInformation + ", eventIdentifier=" + this.eventIdentifier + ", lineage=" + this.lineage + ", messageInformation=" + this.messageInformation + ", meta=" + this.meta + ", nextEvent=" + this.nextEvent + ", party=" + this.party + ", previousWorkflowStep=" + this.previousWorkflowStep + ", proposedEvent=" + this.proposedEvent + ", rejected=" + this.rejected + ", timestamp=" + this.timestamp + ", workflowState=" + this.workflowState + '}';
        }
    }

    public static class WorkflowStepImpl
    implements WorkflowStep {
        private final List<? extends Account> account;
        private final ActionEnum action;
        private final List<? extends WorkflowStepApproval> approval;
        private final BusinessEvent businessEvent;
        private final CreditLimitInformation creditLimitInformation;
        private final List<? extends Identifier> eventIdentifier;
        private final Lineage lineage;
        private final MessageInformation messageInformation;
        private final MetaFields meta;
        private final EventInstruction nextEvent;
        private final List<? extends Party> party;
        private final ReferenceWithMetaWorkflowStep previousWorkflowStep;
        private final EventInstruction proposedEvent;
        private final Boolean rejected;
        private final List<? extends EventTimestamp> timestamp;
        private final WorkflowState workflowState;

        protected WorkflowStepImpl(WorkflowStepBuilder builder) {
            this.account = Optional.ofNullable(builder.getAccount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.action = builder.getAction();
            this.approval = Optional.ofNullable(builder.getApproval()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.businessEvent = Optional.ofNullable(builder.getBusinessEvent()).map(f -> f.build()).orElse(null);
            this.creditLimitInformation = Optional.ofNullable(builder.getCreditLimitInformation()).map(f -> f.build()).orElse(null);
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lineage = Optional.ofNullable(builder.getLineage()).map(f -> f.build()).orElse(null);
            this.messageInformation = Optional.ofNullable(builder.getMessageInformation()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.nextEvent = Optional.ofNullable(builder.getNextEvent()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.previousWorkflowStep = Optional.ofNullable(builder.getPreviousWorkflowStep()).map(f -> f.build()).orElse(null);
            this.proposedEvent = Optional.ofNullable(builder.getProposedEvent()).map(f -> f.build()).orElse(null);
            this.rejected = builder.getRejected();
            this.timestamp = Optional.ofNullable(builder.getTimestamp()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.workflowState = Optional.ofNullable(builder.getWorkflowState()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends Account> getAccount() {
            return this.account;
        }

        @Override
        public ActionEnum getAction() {
            return this.action;
        }

        @Override
        public List<? extends WorkflowStepApproval> getApproval() {
            return this.approval;
        }

        @Override
        public BusinessEvent getBusinessEvent() {
            return this.businessEvent;
        }

        @Override
        public CreditLimitInformation getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        public List<? extends Identifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public Lineage getLineage() {
            return this.lineage;
        }

        @Override
        public MessageInformation getMessageInformation() {
            return this.messageInformation;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public EventInstruction getNextEvent() {
            return this.nextEvent;
        }

        @Override
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public ReferenceWithMetaWorkflowStep getPreviousWorkflowStep() {
            return this.previousWorkflowStep;
        }

        @Override
        public EventInstruction getProposedEvent() {
            return this.proposedEvent;
        }

        @Override
        public Boolean getRejected() {
            return this.rejected;
        }

        @Override
        public List<? extends EventTimestamp> getTimestamp() {
            return this.timestamp;
        }

        @Override
        public WorkflowState getWorkflowState() {
            return this.workflowState;
        }

        @Override
        public WorkflowStep build() {
            return this;
        }

        @Override
        public WorkflowStepBuilder toBuilder() {
            WorkflowStepBuilder builder = WorkflowStep.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WorkflowStepBuilder builder) {
            Optional.ofNullable(this.getAccount()).ifPresent(builder::setAccount);
            Optional.ofNullable(this.getAction()).ifPresent(builder::setAction);
            Optional.ofNullable(this.getApproval()).ifPresent(builder::setApproval);
            Optional.ofNullable(this.getBusinessEvent()).ifPresent(builder::setBusinessEvent);
            Optional.ofNullable(this.getCreditLimitInformation()).ifPresent(builder::setCreditLimitInformation);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getLineage()).ifPresent(builder::setLineage);
            Optional.ofNullable(this.getMessageInformation()).ifPresent(builder::setMessageInformation);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getNextEvent()).ifPresent(builder::setNextEvent);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPreviousWorkflowStep()).ifPresent(builder::setPreviousWorkflowStep);
            Optional.ofNullable(this.getProposedEvent()).ifPresent(builder::setProposedEvent);
            Optional.ofNullable(this.getRejected()).ifPresent(builder::setRejected);
            Optional.ofNullable(this.getTimestamp()).ifPresent(builder::setTimestamp);
            Optional.ofNullable(this.getWorkflowState()).ifPresent(builder::setWorkflowState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WorkflowStep _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.approval, _that.getApproval())) {
                return false;
            }
            if (!Objects.equals(this.businessEvent, _that.getBusinessEvent())) {
                return false;
            }
            if (!Objects.equals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!Objects.equals(this.messageInformation, _that.getMessageInformation())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.nextEvent, _that.getNextEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.previousWorkflowStep, _that.getPreviousWorkflowStep())) {
                return false;
            }
            if (!Objects.equals(this.proposedEvent, _that.getProposedEvent())) {
                return false;
            }
            if (!Objects.equals(this.rejected, _that.getRejected())) {
                return false;
            }
            if (!ListEquals.listEquals(this.timestamp, _that.getTimestamp())) {
                return false;
            }
            return Objects.equals(this.workflowState, _that.getWorkflowState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.approval != null ? this.approval.hashCode() : 0);
            _result = 31 * _result + (this.businessEvent != null ? this.businessEvent.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.messageInformation != null ? this.messageInformation.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.nextEvent != null ? this.nextEvent.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.previousWorkflowStep != null ? this.previousWorkflowStep.hashCode() : 0);
            _result = 31 * _result + (this.proposedEvent != null ? this.proposedEvent.hashCode() : 0);
            _result = 31 * _result + (this.rejected != null ? this.rejected.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            _result = 31 * _result + (this.workflowState != null ? this.workflowState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WorkflowStep {account=" + this.account + ", action=" + (Object)((Object)this.action) + ", approval=" + this.approval + ", businessEvent=" + this.businessEvent + ", creditLimitInformation=" + this.creditLimitInformation + ", eventIdentifier=" + this.eventIdentifier + ", lineage=" + this.lineage + ", messageInformation=" + this.messageInformation + ", meta=" + this.meta + ", nextEvent=" + this.nextEvent + ", party=" + this.party + ", previousWorkflowStep=" + this.previousWorkflowStep + ", proposedEvent=" + this.proposedEvent + ", rejected=" + this.rejected + ", timestamp=" + this.timestamp + ", workflowState=" + this.workflowState + '}';
        }
    }

    public static interface WorkflowStepBuilder
    extends WorkflowStep,
    RosettaModelObjectBuilder {
        public Account.AccountBuilder getOrCreateAccount(int var1);

        public List<? extends Account.AccountBuilder> getAccount();

        public WorkflowStepApproval.WorkflowStepApprovalBuilder getOrCreateApproval(int var1);

        public List<? extends WorkflowStepApproval.WorkflowStepApprovalBuilder> getApproval();

        public BusinessEvent.BusinessEventBuilder getOrCreateBusinessEvent();

        @Override
        public BusinessEvent.BusinessEventBuilder getBusinessEvent();

        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation();

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getCreditLimitInformation();

        public Identifier.IdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getEventIdentifier();

        public Lineage.LineageBuilder getOrCreateLineage();

        @Override
        public Lineage.LineageBuilder getLineage();

        public MessageInformation.MessageInformationBuilder getOrCreateMessageInformation();

        @Override
        public MessageInformation.MessageInformationBuilder getMessageInformation();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public EventInstruction.EventInstructionBuilder getOrCreateNextEvent();

        @Override
        public EventInstruction.EventInstructionBuilder getNextEvent();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getOrCreatePreviousWorkflowStep();

        @Override
        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getPreviousWorkflowStep();

        public EventInstruction.EventInstructionBuilder getOrCreateProposedEvent();

        @Override
        public EventInstruction.EventInstructionBuilder getProposedEvent();

        public EventTimestamp.EventTimestampBuilder getOrCreateTimestamp(int var1);

        public List<? extends EventTimestamp.EventTimestampBuilder> getTimestamp();

        public WorkflowState.WorkflowStateBuilder getOrCreateWorkflowState();

        @Override
        public WorkflowState.WorkflowStateBuilder getWorkflowState();

        public WorkflowStepBuilder addAccount(Account var1);

        public WorkflowStepBuilder addAccount(Account var1, int var2);

        public WorkflowStepBuilder addAccount(List<? extends Account> var1);

        public WorkflowStepBuilder setAccount(List<? extends Account> var1);

        public WorkflowStepBuilder setAction(ActionEnum var1);

        public WorkflowStepBuilder addApproval(WorkflowStepApproval var1);

        public WorkflowStepBuilder addApproval(WorkflowStepApproval var1, int var2);

        public WorkflowStepBuilder addApproval(List<? extends WorkflowStepApproval> var1);

        public WorkflowStepBuilder setApproval(List<? extends WorkflowStepApproval> var1);

        public WorkflowStepBuilder setBusinessEvent(BusinessEvent var1);

        public WorkflowStepBuilder setCreditLimitInformation(CreditLimitInformation var1);

        public WorkflowStepBuilder addEventIdentifier(Identifier var1);

        public WorkflowStepBuilder addEventIdentifier(Identifier var1, int var2);

        public WorkflowStepBuilder addEventIdentifier(List<? extends Identifier> var1);

        public WorkflowStepBuilder setEventIdentifier(List<? extends Identifier> var1);

        public WorkflowStepBuilder setLineage(Lineage var1);

        public WorkflowStepBuilder setMessageInformation(MessageInformation var1);

        public WorkflowStepBuilder setMeta(MetaFields var1);

        public WorkflowStepBuilder setNextEvent(EventInstruction var1);

        public WorkflowStepBuilder addParty(Party var1);

        public WorkflowStepBuilder addParty(Party var1, int var2);

        public WorkflowStepBuilder addParty(List<? extends Party> var1);

        public WorkflowStepBuilder setParty(List<? extends Party> var1);

        public WorkflowStepBuilder setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep var1);

        public WorkflowStepBuilder setPreviousWorkflowStepValue(WorkflowStep var1);

        public WorkflowStepBuilder setProposedEvent(EventInstruction var1);

        public WorkflowStepBuilder setRejected(Boolean var1);

        public WorkflowStepBuilder addTimestamp(EventTimestamp var1);

        public WorkflowStepBuilder addTimestamp(EventTimestamp var1, int var2);

        public WorkflowStepBuilder addTimestamp(List<? extends EventTimestamp> var1);

        public WorkflowStepBuilder setTimestamp(List<? extends EventTimestamp> var1);

        public WorkflowStepBuilder setWorkflowState(WorkflowState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("action"), ActionEnum.class, (Object)this.getAction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rejected"), Boolean.class, (Object)this.getRejected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("account"), processor, Account.AccountBuilder.class, this.getAccount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approval"), processor, WorkflowStepApproval.WorkflowStepApprovalBuilder.class, this.getApproval(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEvent"), processor, BusinessEvent.BusinessEventBuilder.class, this.getBusinessEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.CreditLimitInformationBuilder.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lineage"), processor, Lineage.LineageBuilder.class, this.getLineage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("messageInformation"), processor, MessageInformation.MessageInformationBuilder.class, this.getMessageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nextEvent"), processor, EventInstruction.EventInstructionBuilder.class, this.getNextEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("previousWorkflowStep"), processor, ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder.class, this.getPreviousWorkflowStep(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("proposedEvent"), processor, EventInstruction.EventInstructionBuilder.class, this.getProposedEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("timestamp"), processor, EventTimestamp.EventTimestampBuilder.class, this.getTimestamp(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("workflowState"), processor, WorkflowState.WorkflowStateBuilder.class, this.getWorkflowState(), new AttributeMeta[0]);
        }

        public WorkflowStepBuilder prune();
    }
}

