/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.event.workflow.PartyCustomisedWorkflow;
import cdm.event.workflow.WarehouseIdentityEnum;
import cdm.event.workflow.WorkflowStatusEnum;
import cdm.event.workflow.meta.WorkflowStateMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface WorkflowState
extends RosettaModelObject {
    public static final WorkflowStateMeta metaData = new WorkflowStateMeta();

    public WorkflowState build();

    public WorkflowStateBuilder toBuilder();

    public String getComment();

    public List<? extends PartyCustomisedWorkflow> getPartyCustomisedWorkflow();

    public WarehouseIdentityEnum getWarehouseIdentity();

    public WorkflowStatusEnum getWorkflowStatus();

    default public RosettaMetaData<? extends WorkflowState> metaData() {
        return metaData;
    }

    public static WorkflowStateBuilder builder() {
        return new WorkflowStateBuilderImpl();
    }

    default public Class<? extends WorkflowState> getType() {
        return WorkflowState.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("warehouseIdentity"), WarehouseIdentityEnum.class, (Object)this.getWarehouseIdentity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("workflowStatus"), WorkflowStatusEnum.class, (Object)this.getWorkflowStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyCustomisedWorkflow"), processor, PartyCustomisedWorkflow.class, this.getPartyCustomisedWorkflow(), new AttributeMeta[0]);
    }

    public static class WorkflowStateBuilderImpl
    implements WorkflowStateBuilder {
        protected String comment;
        protected List<PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder> partyCustomisedWorkflow = new ArrayList<PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder>();
        protected WarehouseIdentityEnum warehouseIdentity;
        protected WorkflowStatusEnum workflowStatus;

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public List<? extends PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder> getPartyCustomisedWorkflow() {
            return this.partyCustomisedWorkflow;
        }

        @Override
        public PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder getOrCreatePartyCustomisedWorkflow(int _index) {
            if (this.partyCustomisedWorkflow == null) {
                this.partyCustomisedWorkflow = new ArrayList<PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder>();
            }
            return (PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder)this.getIndex(this.partyCustomisedWorkflow, _index, () -> {
                PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder newPartyCustomisedWorkflow = PartyCustomisedWorkflow.builder();
                return newPartyCustomisedWorkflow;
            });
        }

        @Override
        public WarehouseIdentityEnum getWarehouseIdentity() {
            return this.warehouseIdentity;
        }

        @Override
        public WorkflowStatusEnum getWorkflowStatus() {
            return this.workflowStatus;
        }

        @Override
        public WorkflowStateBuilder setComment(String comment) {
            this.comment = comment == null ? null : comment;
            return this;
        }

        @Override
        public WorkflowStateBuilder addPartyCustomisedWorkflow(PartyCustomisedWorkflow partyCustomisedWorkflow) {
            if (partyCustomisedWorkflow != null) {
                this.partyCustomisedWorkflow.add(partyCustomisedWorkflow.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowStateBuilder addPartyCustomisedWorkflow(PartyCustomisedWorkflow partyCustomisedWorkflow, int _idx) {
            this.getIndex(this.partyCustomisedWorkflow, _idx, () -> partyCustomisedWorkflow.toBuilder());
            return this;
        }

        @Override
        public WorkflowStateBuilder addPartyCustomisedWorkflow(List<? extends PartyCustomisedWorkflow> partyCustomisedWorkflows) {
            if (partyCustomisedWorkflows != null) {
                for (PartyCustomisedWorkflow partyCustomisedWorkflow : partyCustomisedWorkflows) {
                    this.partyCustomisedWorkflow.add(partyCustomisedWorkflow.toBuilder());
                }
            }
            return this;
        }

        @Override
        public WorkflowStateBuilder setPartyCustomisedWorkflow(List<? extends PartyCustomisedWorkflow> partyCustomisedWorkflows) {
            this.partyCustomisedWorkflow = partyCustomisedWorkflows == null ? new ArrayList<PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder>() : (List)partyCustomisedWorkflows.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public WorkflowStateBuilder setWarehouseIdentity(WarehouseIdentityEnum warehouseIdentity) {
            this.warehouseIdentity = warehouseIdentity == null ? null : warehouseIdentity;
            return this;
        }

        @Override
        public WorkflowStateBuilder setWorkflowStatus(WorkflowStatusEnum workflowStatus) {
            this.workflowStatus = workflowStatus == null ? null : workflowStatus;
            return this;
        }

        @Override
        public WorkflowState build() {
            return new WorkflowStateImpl(this);
        }

        @Override
        public WorkflowStateBuilder toBuilder() {
            return this;
        }

        @Override
        public WorkflowStateBuilder prune() {
            this.partyCustomisedWorkflow = this.partyCustomisedWorkflow.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getComment() != null) {
                return true;
            }
            if (this.getPartyCustomisedWorkflow() != null && this.getPartyCustomisedWorkflow().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getWarehouseIdentity() != null) {
                return true;
            }
            return this.getWorkflowStatus() != null;
        }

        public WorkflowStateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WorkflowStateBuilder o = (WorkflowStateBuilder)other;
            merger.mergeRosetta(this.getPartyCustomisedWorkflow(), o.getPartyCustomisedWorkflow(), this::getOrCreatePartyCustomisedWorkflow);
            merger.mergeBasic((Object)this.getComment(), (Object)o.getComment(), this::setComment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWarehouseIdentity(), (Object)o.getWarehouseIdentity(), this::setWarehouseIdentity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWorkflowStatus(), (Object)o.getWorkflowStatus(), this::setWorkflowStatus, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WorkflowState _that = this.getType().cast(o);
            if (!Objects.equals(this.comment, _that.getComment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyCustomisedWorkflow, _that.getPartyCustomisedWorkflow())) {
                return false;
            }
            if (!Objects.equals((Object)this.warehouseIdentity, (Object)_that.getWarehouseIdentity())) {
                return false;
            }
            return Objects.equals((Object)this.workflowStatus, (Object)_that.getWorkflowStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            _result = 31 * _result + (this.partyCustomisedWorkflow != null ? this.partyCustomisedWorkflow.hashCode() : 0);
            _result = 31 * _result + (this.warehouseIdentity != null ? ((Object)((Object)this.warehouseIdentity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.workflowStatus != null ? ((Object)((Object)this.workflowStatus)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WorkflowStateBuilder {comment=" + this.comment + ", partyCustomisedWorkflow=" + this.partyCustomisedWorkflow + ", warehouseIdentity=" + (Object)((Object)this.warehouseIdentity) + ", workflowStatus=" + (Object)((Object)this.workflowStatus) + '}';
        }
    }

    public static class WorkflowStateImpl
    implements WorkflowState {
        private final String comment;
        private final List<? extends PartyCustomisedWorkflow> partyCustomisedWorkflow;
        private final WarehouseIdentityEnum warehouseIdentity;
        private final WorkflowStatusEnum workflowStatus;

        protected WorkflowStateImpl(WorkflowStateBuilder builder) {
            this.comment = builder.getComment();
            this.partyCustomisedWorkflow = Optional.ofNullable(builder.getPartyCustomisedWorkflow()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.warehouseIdentity = builder.getWarehouseIdentity();
            this.workflowStatus = builder.getWorkflowStatus();
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public List<? extends PartyCustomisedWorkflow> getPartyCustomisedWorkflow() {
            return this.partyCustomisedWorkflow;
        }

        @Override
        public WarehouseIdentityEnum getWarehouseIdentity() {
            return this.warehouseIdentity;
        }

        @Override
        public WorkflowStatusEnum getWorkflowStatus() {
            return this.workflowStatus;
        }

        @Override
        public WorkflowState build() {
            return this;
        }

        @Override
        public WorkflowStateBuilder toBuilder() {
            WorkflowStateBuilder builder = WorkflowState.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WorkflowStateBuilder builder) {
            Optional.ofNullable(this.getComment()).ifPresent(builder::setComment);
            Optional.ofNullable(this.getPartyCustomisedWorkflow()).ifPresent(builder::setPartyCustomisedWorkflow);
            Optional.ofNullable(this.getWarehouseIdentity()).ifPresent(builder::setWarehouseIdentity);
            Optional.ofNullable(this.getWorkflowStatus()).ifPresent(builder::setWorkflowStatus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WorkflowState _that = this.getType().cast(o);
            if (!Objects.equals(this.comment, _that.getComment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyCustomisedWorkflow, _that.getPartyCustomisedWorkflow())) {
                return false;
            }
            if (!Objects.equals((Object)this.warehouseIdentity, (Object)_that.getWarehouseIdentity())) {
                return false;
            }
            return Objects.equals((Object)this.workflowStatus, (Object)_that.getWorkflowStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            _result = 31 * _result + (this.partyCustomisedWorkflow != null ? this.partyCustomisedWorkflow.hashCode() : 0);
            _result = 31 * _result + (this.warehouseIdentity != null ? ((Object)((Object)this.warehouseIdentity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.workflowStatus != null ? ((Object)((Object)this.workflowStatus)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WorkflowState {comment=" + this.comment + ", partyCustomisedWorkflow=" + this.partyCustomisedWorkflow + ", warehouseIdentity=" + (Object)((Object)this.warehouseIdentity) + ", workflowStatus=" + (Object)((Object)this.workflowStatus) + '}';
        }
    }

    public static interface WorkflowStateBuilder
    extends WorkflowState,
    RosettaModelObjectBuilder {
        public PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder getOrCreatePartyCustomisedWorkflow(int var1);

        public List<? extends PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder> getPartyCustomisedWorkflow();

        public WorkflowStateBuilder setComment(String var1);

        public WorkflowStateBuilder addPartyCustomisedWorkflow(PartyCustomisedWorkflow var1);

        public WorkflowStateBuilder addPartyCustomisedWorkflow(PartyCustomisedWorkflow var1, int var2);

        public WorkflowStateBuilder addPartyCustomisedWorkflow(List<? extends PartyCustomisedWorkflow> var1);

        public WorkflowStateBuilder setPartyCustomisedWorkflow(List<? extends PartyCustomisedWorkflow> var1);

        public WorkflowStateBuilder setWarehouseIdentity(WarehouseIdentityEnum var1);

        public WorkflowStateBuilder setWorkflowStatus(WorkflowStatusEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("warehouseIdentity"), WarehouseIdentityEnum.class, (Object)this.getWarehouseIdentity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("workflowStatus"), WorkflowStatusEnum.class, (Object)this.getWorkflowStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyCustomisedWorkflow"), processor, PartyCustomisedWorkflow.PartyCustomisedWorkflowBuilder.class, this.getPartyCustomisedWorkflow(), new AttributeMeta[0]);
        }

        public WorkflowStateBuilder prune();
    }
}

