/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.event.workflow.CreditLimitTypeEnum;
import cdm.event.workflow.CreditLimitUtilisation;
import cdm.event.workflow.Velocity;
import cdm.event.workflow.meta.LimitApplicableMeta;
import cdm.event.workflow.metafields.FieldWithMetaCreditLimitTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface LimitApplicable
extends RosettaModelObject {
    public static final LimitApplicableMeta metaData = new LimitApplicableMeta();

    public LimitApplicable build();

    public LimitApplicableBuilder toBuilder();

    public BigDecimal getAmountRemaining();

    public BigDecimal getAmountUtilized();

    public Integer getClipSize();

    public FieldWithMetaString getCurrency();

    public FieldWithMetaCreditLimitTypeEnum getLimitType();

    public CreditLimitUtilisation getUtilization();

    public Velocity getVelocity();

    default public RosettaMetaData<? extends LimitApplicable> metaData() {
        return metaData;
    }

    public static LimitApplicableBuilder builder() {
        return new LimitApplicableBuilderImpl();
    }

    default public Class<? extends LimitApplicable> getType() {
        return LimitApplicable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("amountRemaining"), BigDecimal.class, (Object)this.getAmountRemaining(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amountUtilized"), BigDecimal.class, (Object)this.getAmountUtilized(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clipSize"), Integer.class, (Object)this.getClipSize(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("limitType"), processor, FieldWithMetaCreditLimitTypeEnum.class, this.getLimitType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("utilization"), processor, CreditLimitUtilisation.class, this.getUtilization(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("velocity"), processor, Velocity.class, this.getVelocity(), new AttributeMeta[0]);
    }

    public static class LimitApplicableBuilderImpl
    implements LimitApplicableBuilder {
        protected BigDecimal amountRemaining;
        protected BigDecimal amountUtilized;
        protected Integer clipSize;
        protected FieldWithMetaString.FieldWithMetaStringBuilder currency;
        protected FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder limitType;
        protected CreditLimitUtilisation.CreditLimitUtilisationBuilder utilization;
        protected Velocity.VelocityBuilder velocity;

        @Override
        public BigDecimal getAmountRemaining() {
            return this.amountRemaining;
        }

        @Override
        public BigDecimal getAmountUtilized() {
            return this.amountUtilized;
        }

        @Override
        public Integer getClipSize() {
            return this.clipSize;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.currency != null ? this.currency : (this.currency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder getLimitType() {
            return this.limitType;
        }

        @Override
        public FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder getOrCreateLimitType() {
            FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder result = this.limitType != null ? this.limitType : (this.limitType = FieldWithMetaCreditLimitTypeEnum.builder());
            return result;
        }

        @Override
        public CreditLimitUtilisation.CreditLimitUtilisationBuilder getUtilization() {
            return this.utilization;
        }

        @Override
        public CreditLimitUtilisation.CreditLimitUtilisationBuilder getOrCreateUtilization() {
            CreditLimitUtilisation.CreditLimitUtilisationBuilder result = this.utilization != null ? this.utilization : (this.utilization = CreditLimitUtilisation.builder());
            return result;
        }

        @Override
        public Velocity.VelocityBuilder getVelocity() {
            return this.velocity;
        }

        @Override
        public Velocity.VelocityBuilder getOrCreateVelocity() {
            Velocity.VelocityBuilder result = this.velocity != null ? this.velocity : (this.velocity = Velocity.builder());
            return result;
        }

        @Override
        public LimitApplicableBuilder setAmountRemaining(BigDecimal amountRemaining) {
            this.amountRemaining = amountRemaining == null ? null : amountRemaining;
            return this;
        }

        @Override
        public LimitApplicableBuilder setAmountUtilized(BigDecimal amountUtilized) {
            this.amountUtilized = amountUtilized == null ? null : amountUtilized;
            return this;
        }

        @Override
        public LimitApplicableBuilder setClipSize(Integer clipSize) {
            this.clipSize = clipSize == null ? null : clipSize;
            return this;
        }

        @Override
        public LimitApplicableBuilder setCurrency(FieldWithMetaString currency) {
            this.currency = currency == null ? null : currency.toBuilder();
            return this;
        }

        @Override
        public LimitApplicableBuilder setCurrencyValue(String currency) {
            this.getOrCreateCurrency().setValue(currency);
            return this;
        }

        @Override
        public LimitApplicableBuilder setLimitType(FieldWithMetaCreditLimitTypeEnum limitType) {
            this.limitType = limitType == null ? null : limitType.toBuilder();
            return this;
        }

        @Override
        public LimitApplicableBuilder setLimitTypeValue(CreditLimitTypeEnum limitType) {
            this.getOrCreateLimitType().setValue(limitType);
            return this;
        }

        @Override
        public LimitApplicableBuilder setUtilization(CreditLimitUtilisation utilization) {
            this.utilization = utilization == null ? null : utilization.toBuilder();
            return this;
        }

        @Override
        public LimitApplicableBuilder setVelocity(Velocity velocity) {
            this.velocity = velocity == null ? null : velocity.toBuilder();
            return this;
        }

        @Override
        public LimitApplicable build() {
            return new LimitApplicableImpl(this);
        }

        @Override
        public LimitApplicableBuilder toBuilder() {
            return this;
        }

        @Override
        public LimitApplicableBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.limitType != null && !this.limitType.prune().hasData()) {
                this.limitType = null;
            }
            if (this.utilization != null && !this.utilization.prune().hasData()) {
                this.utilization = null;
            }
            if (this.velocity != null && !this.velocity.prune().hasData()) {
                this.velocity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmountRemaining() != null) {
                return true;
            }
            if (this.getAmountUtilized() != null) {
                return true;
            }
            if (this.getClipSize() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getLimitType() != null) {
                return true;
            }
            if (this.getUtilization() != null && this.getUtilization().hasData()) {
                return true;
            }
            return this.getVelocity() != null && this.getVelocity().hasData();
        }

        public LimitApplicableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LimitApplicableBuilder o = (LimitApplicableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLimitType(), (RosettaModelObjectBuilder)o.getLimitType(), this::setLimitType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUtilization(), (RosettaModelObjectBuilder)o.getUtilization(), this::setUtilization);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVelocity(), (RosettaModelObjectBuilder)o.getVelocity(), this::setVelocity);
            merger.mergeBasic((Object)this.getAmountRemaining(), (Object)o.getAmountRemaining(), this::setAmountRemaining, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAmountUtilized(), (Object)o.getAmountUtilized(), this::setAmountUtilized, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClipSize(), (Object)o.getClipSize(), this::setClipSize, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LimitApplicable _that = this.getType().cast(o);
            if (!Objects.equals(this.amountRemaining, _that.getAmountRemaining())) {
                return false;
            }
            if (!Objects.equals(this.amountUtilized, _that.getAmountUtilized())) {
                return false;
            }
            if (!Objects.equals(this.clipSize, _that.getClipSize())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.limitType, _that.getLimitType())) {
                return false;
            }
            if (!Objects.equals(this.utilization, _that.getUtilization())) {
                return false;
            }
            return Objects.equals(this.velocity, _that.getVelocity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amountRemaining != null ? this.amountRemaining.hashCode() : 0);
            _result = 31 * _result + (this.amountUtilized != null ? this.amountUtilized.hashCode() : 0);
            _result = 31 * _result + (this.clipSize != null ? this.clipSize.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.limitType != null ? this.limitType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.utilization != null ? this.utilization.hashCode() : 0);
            _result = 31 * _result + (this.velocity != null ? this.velocity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LimitApplicableBuilder {amountRemaining=" + this.amountRemaining + ", amountUtilized=" + this.amountUtilized + ", clipSize=" + this.clipSize + ", currency=" + this.currency + ", limitType=" + this.limitType + ", utilization=" + this.utilization + ", velocity=" + this.velocity + '}';
        }
    }

    public static class LimitApplicableImpl
    implements LimitApplicable {
        private final BigDecimal amountRemaining;
        private final BigDecimal amountUtilized;
        private final Integer clipSize;
        private final FieldWithMetaString currency;
        private final FieldWithMetaCreditLimitTypeEnum limitType;
        private final CreditLimitUtilisation utilization;
        private final Velocity velocity;

        protected LimitApplicableImpl(LimitApplicableBuilder builder) {
            this.amountRemaining = builder.getAmountRemaining();
            this.amountUtilized = builder.getAmountUtilized();
            this.clipSize = builder.getClipSize();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.limitType = Optional.ofNullable(builder.getLimitType()).map(f -> f.build()).orElse(null);
            this.utilization = Optional.ofNullable(builder.getUtilization()).map(f -> f.build()).orElse(null);
            this.velocity = Optional.ofNullable(builder.getVelocity()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getAmountRemaining() {
            return this.amountRemaining;
        }

        @Override
        public BigDecimal getAmountUtilized() {
            return this.amountUtilized;
        }

        @Override
        public Integer getClipSize() {
            return this.clipSize;
        }

        @Override
        public FieldWithMetaString getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaCreditLimitTypeEnum getLimitType() {
            return this.limitType;
        }

        @Override
        public CreditLimitUtilisation getUtilization() {
            return this.utilization;
        }

        @Override
        public Velocity getVelocity() {
            return this.velocity;
        }

        @Override
        public LimitApplicable build() {
            return this;
        }

        @Override
        public LimitApplicableBuilder toBuilder() {
            LimitApplicableBuilder builder = LimitApplicable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LimitApplicableBuilder builder) {
            Optional.ofNullable(this.getAmountRemaining()).ifPresent(builder::setAmountRemaining);
            Optional.ofNullable(this.getAmountUtilized()).ifPresent(builder::setAmountUtilized);
            Optional.ofNullable(this.getClipSize()).ifPresent(builder::setClipSize);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getLimitType()).ifPresent(builder::setLimitType);
            Optional.ofNullable(this.getUtilization()).ifPresent(builder::setUtilization);
            Optional.ofNullable(this.getVelocity()).ifPresent(builder::setVelocity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LimitApplicable _that = this.getType().cast(o);
            if (!Objects.equals(this.amountRemaining, _that.getAmountRemaining())) {
                return false;
            }
            if (!Objects.equals(this.amountUtilized, _that.getAmountUtilized())) {
                return false;
            }
            if (!Objects.equals(this.clipSize, _that.getClipSize())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.limitType, _that.getLimitType())) {
                return false;
            }
            if (!Objects.equals(this.utilization, _that.getUtilization())) {
                return false;
            }
            return Objects.equals(this.velocity, _that.getVelocity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amountRemaining != null ? this.amountRemaining.hashCode() : 0);
            _result = 31 * _result + (this.amountUtilized != null ? this.amountUtilized.hashCode() : 0);
            _result = 31 * _result + (this.clipSize != null ? this.clipSize.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.limitType != null ? this.limitType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.utilization != null ? this.utilization.hashCode() : 0);
            _result = 31 * _result + (this.velocity != null ? this.velocity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LimitApplicable {amountRemaining=" + this.amountRemaining + ", amountUtilized=" + this.amountUtilized + ", clipSize=" + this.clipSize + ", currency=" + this.currency + ", limitType=" + this.limitType + ", utilization=" + this.utilization + ", velocity=" + this.velocity + '}';
        }
    }

    public static interface LimitApplicableBuilder
    extends LimitApplicable,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency();

        public FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder getOrCreateLimitType();

        @Override
        public FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder getLimitType();

        public CreditLimitUtilisation.CreditLimitUtilisationBuilder getOrCreateUtilization();

        @Override
        public CreditLimitUtilisation.CreditLimitUtilisationBuilder getUtilization();

        public Velocity.VelocityBuilder getOrCreateVelocity();

        @Override
        public Velocity.VelocityBuilder getVelocity();

        public LimitApplicableBuilder setAmountRemaining(BigDecimal var1);

        public LimitApplicableBuilder setAmountUtilized(BigDecimal var1);

        public LimitApplicableBuilder setClipSize(Integer var1);

        public LimitApplicableBuilder setCurrency(FieldWithMetaString var1);

        public LimitApplicableBuilder setCurrencyValue(String var1);

        public LimitApplicableBuilder setLimitType(FieldWithMetaCreditLimitTypeEnum var1);

        public LimitApplicableBuilder setLimitTypeValue(CreditLimitTypeEnum var1);

        public LimitApplicableBuilder setUtilization(CreditLimitUtilisation var1);

        public LimitApplicableBuilder setVelocity(Velocity var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("amountRemaining"), BigDecimal.class, (Object)this.getAmountRemaining(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amountUtilized"), BigDecimal.class, (Object)this.getAmountUtilized(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clipSize"), Integer.class, (Object)this.getClipSize(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("limitType"), processor, FieldWithMetaCreditLimitTypeEnum.FieldWithMetaCreditLimitTypeEnumBuilder.class, this.getLimitType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("utilization"), processor, CreditLimitUtilisation.CreditLimitUtilisationBuilder.class, this.getUtilization(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("velocity"), processor, Velocity.VelocityBuilder.class, this.getVelocity(), new AttributeMeta[0]);
        }

        public LimitApplicableBuilder prune();
    }
}

