/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.workflow.meta.EventInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface EventInstruction
extends RosettaModelObject {
    public static final EventInstructionMeta metaData = new EventInstructionMeta();

    public EventInstruction build();

    public EventInstructionBuilder toBuilder();

    public CorporateActionTypeEnum getCorporateActionIntent();

    public Date getEffectiveDate();

    public Date getEventDate();

    public List<? extends Instruction> getInstruction();

    public EventIntentEnum getIntent();

    public IdentifiedList getPackageInformation();

    default public RosettaMetaData<? extends EventInstruction> metaData() {
        return metaData;
    }

    public static EventInstructionBuilder builder() {
        return new EventInstructionBuilderImpl();
    }

    default public Class<? extends EventInstruction> getType() {
        return EventInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instruction"), processor, Instruction.class, this.getInstruction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.class, this.getPackageInformation(), new AttributeMeta[0]);
    }

    public static class EventInstructionBuilderImpl
    implements EventInstructionBuilder {
        protected CorporateActionTypeEnum corporateActionIntent;
        protected Date effectiveDate;
        protected Date eventDate;
        protected List<Instruction.InstructionBuilder> instruction = new ArrayList<Instruction.InstructionBuilder>();
        protected EventIntentEnum intent;
        protected IdentifiedList.IdentifiedListBuilder packageInformation;

        @Override
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        public List<? extends Instruction.InstructionBuilder> getInstruction() {
            return this.instruction;
        }

        @Override
        public Instruction.InstructionBuilder getOrCreateInstruction(int _index) {
            if (this.instruction == null) {
                this.instruction = new ArrayList<Instruction.InstructionBuilder>();
            }
            return (Instruction.InstructionBuilder)this.getIndex(this.instruction, _index, () -> {
                Instruction.InstructionBuilder newInstruction = Instruction.builder();
                return newInstruction;
            });
        }

        @Override
        public EventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation() {
            IdentifiedList.IdentifiedListBuilder result = this.packageInformation != null ? this.packageInformation : (this.packageInformation = IdentifiedList.builder());
            return result;
        }

        @Override
        public EventInstructionBuilder setCorporateActionIntent(CorporateActionTypeEnum corporateActionIntent) {
            this.corporateActionIntent = corporateActionIntent == null ? null : corporateActionIntent;
            return this;
        }

        @Override
        public EventInstructionBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        public EventInstructionBuilder setEventDate(Date eventDate) {
            this.eventDate = eventDate == null ? null : eventDate;
            return this;
        }

        @Override
        public EventInstructionBuilder addInstruction(Instruction instruction) {
            if (instruction != null) {
                this.instruction.add(instruction.toBuilder());
            }
            return this;
        }

        @Override
        public EventInstructionBuilder addInstruction(Instruction instruction, int _idx) {
            this.getIndex(this.instruction, _idx, () -> instruction.toBuilder());
            return this;
        }

        @Override
        public EventInstructionBuilder addInstruction(List<? extends Instruction> instructions) {
            if (instructions != null) {
                for (Instruction instruction : instructions) {
                    this.instruction.add(instruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        public EventInstructionBuilder setInstruction(List<? extends Instruction> instructions) {
            this.instruction = instructions == null ? new ArrayList<Instruction.InstructionBuilder>() : (List)instructions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EventInstructionBuilder setIntent(EventIntentEnum intent) {
            this.intent = intent == null ? null : intent;
            return this;
        }

        @Override
        public EventInstructionBuilder setPackageInformation(IdentifiedList packageInformation) {
            this.packageInformation = packageInformation == null ? null : packageInformation.toBuilder();
            return this;
        }

        @Override
        public EventInstruction build() {
            return new EventInstructionImpl(this);
        }

        @Override
        public EventInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public EventInstructionBuilder prune() {
            this.instruction = this.instruction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.packageInformation != null && !this.packageInformation.prune().hasData()) {
                this.packageInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCorporateActionIntent() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getInstruction() != null && this.getInstruction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIntent() != null) {
                return true;
            }
            return this.getPackageInformation() != null && this.getPackageInformation().hasData();
        }

        public EventInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EventInstructionBuilder o = (EventInstructionBuilder)other;
            merger.mergeRosetta(this.getInstruction(), o.getInstruction(), this::getOrCreateInstruction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInformation(), (RosettaModelObjectBuilder)o.getPackageInformation(), this::setPackageInformation);
            merger.mergeBasic((Object)this.getCorporateActionIntent(), (Object)o.getCorporateActionIntent(), this::setCorporateActionIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntent(), (Object)o.getIntent(), this::setIntent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EventInstruction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instruction, _that.getInstruction())) {
                return false;
            }
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            return Objects.equals(this.packageInformation, _that.getPackageInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.instruction != null ? this.instruction.hashCode() : 0);
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EventInstructionBuilder {corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", effectiveDate=" + this.effectiveDate + ", eventDate=" + this.eventDate + ", instruction=" + this.instruction + ", intent=" + (Object)((Object)this.intent) + ", packageInformation=" + this.packageInformation + '}';
        }
    }

    public static class EventInstructionImpl
    implements EventInstruction {
        private final CorporateActionTypeEnum corporateActionIntent;
        private final Date effectiveDate;
        private final Date eventDate;
        private final List<? extends Instruction> instruction;
        private final EventIntentEnum intent;
        private final IdentifiedList packageInformation;

        protected EventInstructionImpl(EventInstructionBuilder builder) {
            this.corporateActionIntent = builder.getCorporateActionIntent();
            this.effectiveDate = builder.getEffectiveDate();
            this.eventDate = builder.getEventDate();
            this.instruction = Optional.ofNullable(builder.getInstruction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.intent = builder.getIntent();
            this.packageInformation = Optional.ofNullable(builder.getPackageInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        public List<? extends Instruction> getInstruction() {
            return this.instruction;
        }

        @Override
        public EventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        public IdentifiedList getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public EventInstruction build() {
            return this;
        }

        @Override
        public EventInstructionBuilder toBuilder() {
            EventInstructionBuilder builder = EventInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EventInstructionBuilder builder) {
            Optional.ofNullable(this.getCorporateActionIntent()).ifPresent(builder::setCorporateActionIntent);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getInstruction()).ifPresent(builder::setInstruction);
            Optional.ofNullable(this.getIntent()).ifPresent(builder::setIntent);
            Optional.ofNullable(this.getPackageInformation()).ifPresent(builder::setPackageInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EventInstruction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instruction, _that.getInstruction())) {
                return false;
            }
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            return Objects.equals(this.packageInformation, _that.getPackageInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.instruction != null ? this.instruction.hashCode() : 0);
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EventInstruction {corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", effectiveDate=" + this.effectiveDate + ", eventDate=" + this.eventDate + ", instruction=" + this.instruction + ", intent=" + (Object)((Object)this.intent) + ", packageInformation=" + this.packageInformation + '}';
        }
    }

    public static interface EventInstructionBuilder
    extends EventInstruction,
    RosettaModelObjectBuilder {
        public Instruction.InstructionBuilder getOrCreateInstruction(int var1);

        public List<? extends Instruction.InstructionBuilder> getInstruction();

        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation();

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageInformation();

        public EventInstructionBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        public EventInstructionBuilder setEffectiveDate(Date var1);

        public EventInstructionBuilder setEventDate(Date var1);

        public EventInstructionBuilder addInstruction(Instruction var1);

        public EventInstructionBuilder addInstruction(Instruction var1, int var2);

        public EventInstructionBuilder addInstruction(List<? extends Instruction> var1);

        public EventInstructionBuilder setInstruction(List<? extends Instruction> var1);

        public EventInstructionBuilder setIntent(EventIntentEnum var1);

        public EventInstructionBuilder setPackageInformation(IdentifiedList var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instruction"), processor, Instruction.InstructionBuilder.class, this.getInstruction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.IdentifiedListBuilder.class, this.getPackageInformation(), new AttributeMeta[0]);
        }

        public EventInstructionBuilder prune();
    }
}

