/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.qualification.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrencyExists;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.event.common.BusinessEvent;
import cdm.event.common.TradeState;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.List;

@ImplementedBy(value=Qualify_StockSplitDefault.class)
public abstract class Qualify_StockSplit
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected FilterQuantityByCurrencyExists filterQuantityByCurrencyExists;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract Mapper<? extends TradeState> beforeTradeState(BusinessEvent var1);

    protected abstract Mapper<? extends TradeState> afterTradeState(BusinessEvent var1);

    protected abstract Mapper<? extends NonNegativeQuantitySchedule> beforeQuantities(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforeNoOfUnits(BusinessEvent var1);

    protected abstract Mapper<? extends NonNegativeQuantitySchedule> afterQuantities(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterNoOfUnits(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforeCurrencyAmount(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterCurrencyAmount(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforePrice(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterPrice(BusinessEvent var1);

    protected abstract Mapper<Boolean> currencyAmountUnchanged(BusinessEvent var1);

    protected abstract Mapper<Boolean> noOfUnitsChanged(BusinessEvent var1);

    protected abstract Mapper<Boolean> cashPriceChanged(BusinessEvent var1);

    protected abstract Mapper<Boolean> adjustmentRatioMatches(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_StockSplitDefault
    extends Qualify_StockSplit {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.currencyAmountUnchanged(businessEvent).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.noOfUnitsChanged(businessEvent).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.cashPriceChanged(businessEvent).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.adjustmentRatioMatches(businessEvent).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected Mapper<? extends TradeState> beforeTradeState(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)MapperS.of((Object)businessEvent).mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).map("getBefore", instruction -> instruction.getBefore()).map("getValue", _f -> _f.getValue()).get()));
        }

        @Override
        protected Mapper<? extends TradeState> afterTradeState(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).get()));
        }

        @Override
        protected Mapper<? extends NonNegativeQuantitySchedule> beforeQuantities(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradeState)this.beforeTradeState(businessEvent).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<BigDecimal> beforeNoOfUnits(BusinessEvent businessEvent) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperC.of((List)this.beforeQuantities(businessEvent).getMulti()).getMulti(), (FinancialUnitEnum)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get()))).get())).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<? extends NonNegativeQuantitySchedule> afterQuantities(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)this.afterTradeState(businessEvent).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<BigDecimal> afterNoOfUnits(BusinessEvent businessEvent) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperC.of((List)this.afterQuantities(businessEvent).getMulti()).getMulti(), (FinancialUnitEnum)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get()))).get())).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<BigDecimal> beforeCurrencyAmount(BusinessEvent businessEvent) {
            return MapperS.of((Object)((BigDecimal)ExpressionOperators.distinct((Mapper)MapperC.of(this.filterQuantityByCurrencyExists.evaluate(MapperC.of((List)this.beforeQuantities(businessEvent).getMulti()).getMulti())).map("getValue", measureBase -> measureBase.getValue())).get()));
        }

        @Override
        protected Mapper<BigDecimal> afterCurrencyAmount(BusinessEvent businessEvent) {
            return MapperS.of((Object)((BigDecimal)ExpressionOperators.distinct((Mapper)MapperC.of(this.filterQuantityByCurrencyExists.evaluate(MapperC.of((List)this.afterQuantities(businessEvent).getMulti()).getMulti())).map("getValue", measureBase -> measureBase.getValue())).get()));
        }

        @Override
        protected Mapper<BigDecimal> beforePrice(BusinessEvent businessEvent) {
            return (Mapper)((MapperC)MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradeState)this.beforeTradeState(businessEvent).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get()).apply(item -> item.mapItem(_item -> _item.map("getValue", measureBase -> measureBase.getValue())))).apply(item -> MapperS.of((Object)((BigDecimal)item.get())));
        }

        @Override
        protected Mapper<BigDecimal> afterPrice(BusinessEvent businessEvent) {
            return (Mapper)((MapperC)MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradeState)this.afterTradeState(businessEvent).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get()).apply(item -> item.mapItem(_item -> _item.map("getValue", measureBase -> measureBase.getValue())))).apply(item -> MapperS.of((Object)((BigDecimal)item.get())));
        }

        @Override
        protected Mapper<Boolean> currencyAmountUnchanged(BusinessEvent businessEvent) {
            return MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.beforeCurrencyAmount(businessEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.afterCurrencyAmount(businessEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((BigDecimal)this.beforeCurrencyAmount(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.afterCurrencyAmount(businessEvent).get())), (CardinalityOperator)CardinalityOperator.All);
                }
                return MapperS.of((Object)false);
            }));
        }

        @Override
        protected Mapper<Boolean> noOfUnitsChanged(BusinessEvent businessEvent) {
            return MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.beforeNoOfUnits(businessEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.afterNoOfUnits(businessEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)((BigDecimal)this.afterNoOfUnits(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.beforeNoOfUnits(businessEvent).get())), (CardinalityOperator)CardinalityOperator.Any);
                }
                return MapperS.of((Object)false);
            }));
        }

        @Override
        protected Mapper<Boolean> cashPriceChanged(BusinessEvent businessEvent) {
            return MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.beforePrice(businessEvent).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.afterPrice(businessEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)((BigDecimal)this.beforePrice(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.afterPrice(businessEvent).get())), (CardinalityOperator)CardinalityOperator.Any);
                }
                return MapperS.of((Object)false);
            }));
        }

        @Override
        protected Mapper<Boolean> adjustmentRatioMatches(BusinessEvent businessEvent) {
            return MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.beforeNoOfUnits(businessEvent).get()))).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)((BigDecimal)this.beforeNoOfUnits(businessEvent).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.afterNoOfUnits(businessEvent).get())))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.beforePrice(businessEvent).get())))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.afterPrice(businessEvent).get())))).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)((BigDecimal)this.afterPrice(businessEvent).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((BigDecimal)this.afterNoOfUnits(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.beforeNoOfUnits(businessEvent).get()))), (Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((BigDecimal)this.beforePrice(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.afterPrice(businessEvent).get()))), (CardinalityOperator)CardinalityOperator.All);
                }
                return MapperS.of((Object)false);
            }));
        }
    }
}

