/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.functions;

import cdm.event.position.Portfolio;
import cdm.event.position.PortfolioState;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;

@ImplementedBy(value=EvaluatePortfolioStateDefault.class)
public abstract class EvaluatePortfolioState
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PortfolioState evaluate(Portfolio portfolio) {
        PortfolioState.PortfolioStateBuilder portfolioState = this.doEvaluate(portfolio);
        if (portfolioState != null) {
            this.objectValidator.validate(PortfolioState.class, (RosettaModelObject)portfolioState);
        }
        return portfolioState;
    }

    protected abstract PortfolioState.PortfolioStateBuilder doEvaluate(Portfolio var1);

    public static class EvaluatePortfolioStateDefault
    extends EvaluatePortfolioState {
        @Override
        protected PortfolioState.PortfolioStateBuilder doEvaluate(Portfolio portfolio) {
            PortfolioState.PortfolioStateBuilder portfolioState = PortfolioState.builder();
            return this.assignOutput(portfolioState, portfolio);
        }

        protected PortfolioState.PortfolioStateBuilder assignOutput(PortfolioState.PortfolioStateBuilder portfolioState, Portfolio portfolio) {
            return Optional.ofNullable(portfolioState).map(o -> o.prune()).orElse(null);
        }
    }
}

