/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.event.common.Lineage;
import cdm.event.position.Position;
import cdm.event.position.meta.PortfolioStateMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PortfolioState
extends RosettaModelObject,
GlobalKey {
    public static final PortfolioStateMeta metaData = new PortfolioStateMeta();

    public PortfolioState build();

    public PortfolioStateBuilder toBuilder();

    public Lineage getLineage();

    public MetaFields getMeta();

    public List<? extends Position> getPositions();

    default public RosettaMetaData<? extends PortfolioState> metaData() {
        return metaData;
    }

    public static PortfolioStateBuilder builder() {
        return new PortfolioStateBuilderImpl();
    }

    default public Class<? extends PortfolioState> getType() {
        return PortfolioState.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("lineage"), processor, Lineage.class, this.getLineage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("positions"), processor, Position.class, this.getPositions(), new AttributeMeta[0]);
    }

    public static class PortfolioStateBuilderImpl
    implements PortfolioStateBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Lineage.LineageBuilder lineage;
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<Position.PositionBuilder> positions = new ArrayList<Position.PositionBuilder>();

        @Override
        public Lineage.LineageBuilder getLineage() {
            return this.lineage;
        }

        @Override
        public Lineage.LineageBuilder getOrCreateLineage() {
            Lineage.LineageBuilder result = this.lineage != null ? this.lineage : (this.lineage = Lineage.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<? extends Position.PositionBuilder> getPositions() {
            return this.positions;
        }

        @Override
        public Position.PositionBuilder getOrCreatePositions(int _index) {
            if (this.positions == null) {
                this.positions = new ArrayList<Position.PositionBuilder>();
            }
            return (Position.PositionBuilder)this.getIndex(this.positions, _index, () -> {
                Position.PositionBuilder newPositions = Position.builder();
                return newPositions;
            });
        }

        @Override
        public PortfolioStateBuilder setLineage(Lineage lineage) {
            this.lineage = lineage == null ? null : lineage.toBuilder();
            return this;
        }

        @Override
        public PortfolioStateBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PortfolioStateBuilder addPositions(Position positions) {
            if (positions != null) {
                this.positions.add(positions.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioStateBuilder addPositions(Position positions, int _idx) {
            this.getIndex(this.positions, _idx, () -> positions.toBuilder());
            return this;
        }

        @Override
        public PortfolioStateBuilder addPositions(List<? extends Position> positionss) {
            if (positionss != null) {
                for (Position position : positionss) {
                    this.positions.add(position.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PortfolioStateBuilder setPositions(List<? extends Position> positionss) {
            this.positions = positionss == null ? new ArrayList<Position.PositionBuilder>() : (List)positionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PortfolioState build() {
            return new PortfolioStateImpl(this);
        }

        @Override
        public PortfolioStateBuilder toBuilder() {
            return this;
        }

        @Override
        public PortfolioStateBuilder prune() {
            if (this.lineage != null && !this.lineage.prune().hasData()) {
                this.lineage = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            this.positions = this.positions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getLineage() != null && this.getLineage().hasData()) {
                return true;
            }
            return this.getPositions() != null && this.getPositions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PortfolioStateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PortfolioStateBuilder o = (PortfolioStateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLineage(), (RosettaModelObjectBuilder)o.getLineage(), this::setLineage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta(this.getPositions(), o.getPositions(), this::getOrCreatePositions);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioState _that = this.getType().cast(o);
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return ListEquals.listEquals(this.positions, _that.getPositions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.positions != null ? this.positions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioStateBuilder {lineage=" + this.lineage + ", meta=" + this.meta + ", positions=" + this.positions + '}';
        }
    }

    public static class PortfolioStateImpl
    implements PortfolioState {
        private final Lineage lineage;
        private final MetaFields meta;
        private final List<? extends Position> positions;

        protected PortfolioStateImpl(PortfolioStateBuilder builder) {
            this.lineage = Optional.ofNullable(builder.getLineage()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.positions = Optional.ofNullable(builder.getPositions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public Lineage getLineage() {
            return this.lineage;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<? extends Position> getPositions() {
            return this.positions;
        }

        @Override
        public PortfolioState build() {
            return this;
        }

        @Override
        public PortfolioStateBuilder toBuilder() {
            PortfolioStateBuilder builder = PortfolioState.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PortfolioStateBuilder builder) {
            Optional.ofNullable(this.getLineage()).ifPresent(builder::setLineage);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPositions()).ifPresent(builder::setPositions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioState _that = this.getType().cast(o);
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return ListEquals.listEquals(this.positions, _that.getPositions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.positions != null ? this.positions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioState {lineage=" + this.lineage + ", meta=" + this.meta + ", positions=" + this.positions + '}';
        }
    }

    public static interface PortfolioStateBuilder
    extends PortfolioState,
    RosettaModelObjectBuilder {
        public Lineage.LineageBuilder getOrCreateLineage();

        @Override
        public Lineage.LineageBuilder getLineage();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Position.PositionBuilder getOrCreatePositions(int var1);

        public List<? extends Position.PositionBuilder> getPositions();

        public PortfolioStateBuilder setLineage(Lineage var1);

        public PortfolioStateBuilder setMeta(MetaFields var1);

        public PortfolioStateBuilder addPositions(Position var1);

        public PortfolioStateBuilder addPositions(Position var1, int var2);

        public PortfolioStateBuilder addPositions(List<? extends Position> var1);

        public PortfolioStateBuilder setPositions(List<? extends Position> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("lineage"), processor, Lineage.LineageBuilder.class, this.getLineage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("positions"), processor, Position.PositionBuilder.class, this.getPositions(), new AttributeMeta[0]);
        }

        public PortfolioStateBuilder prune();
    }
}

