/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.event.common.metafields.ReferenceWithMetaTrade;
import cdm.event.position.PositionStatusEnum;
import cdm.event.position.meta.AggregationParametersMeta;
import cdm.product.template.Product;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface AggregationParameters
extends RosettaModelObject {
    public static final AggregationParametersMeta metaData = new AggregationParametersMeta();

    public AggregationParameters build();

    public AggregationParametersBuilder toBuilder();

    public ZonedDateTime getDateTime();

    public List<? extends ReferenceWithMetaParty> getParty();

    public PositionStatusEnum getPositionStatus();

    public List<? extends Product> getProduct();

    public List<String> getProductQualifier();

    public Boolean getTotalPosition();

    public List<? extends ReferenceWithMetaTrade> getTradeReference();

    default public RosettaMetaData<? extends AggregationParameters> metaData() {
        return metaData;
    }

    public static AggregationParametersBuilder builder() {
        return new AggregationParametersBuilderImpl();
    }

    default public Class<? extends AggregationParameters> getType() {
        return AggregationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, (Object)this.getDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("positionStatus"), PositionStatusEnum.class, (Object)this.getPositionStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productQualifier"), String.class, this.getProductQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalPosition"), Boolean.class, (Object)this.getTotalPosition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, ReferenceWithMetaParty.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.class, this.getTradeReference(), new AttributeMeta[0]);
    }

    public static class AggregationParametersBuilderImpl
    implements AggregationParametersBuilder {
        protected ZonedDateTime dateTime;
        protected List<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> party = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
        protected PositionStatusEnum positionStatus;
        protected List<Product.ProductBuilder> product = new ArrayList<Product.ProductBuilder>();
        protected List<String> productQualifier = new ArrayList<String>();
        protected Boolean totalPosition;
        protected List<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();

        @Override
        public ZonedDateTime getDateTime() {
            return this.dateTime;
        }

        @Override
        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
            }
            return (ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder)this.getIndex(this.party, _index, () -> {
                ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder newParty = ReferenceWithMetaParty.builder();
                return newParty;
            });
        }

        @Override
        public PositionStatusEnum getPositionStatus() {
            return this.positionStatus;
        }

        @Override
        public List<? extends Product.ProductBuilder> getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct(int _index) {
            if (this.product == null) {
                this.product = new ArrayList<Product.ProductBuilder>();
            }
            return (Product.ProductBuilder)this.getIndex(this.product, _index, () -> {
                Product.ProductBuilder newProduct = Product.builder();
                return newProduct;
            });
        }

        @Override
        public List<String> getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        public Boolean getTotalPosition() {
            return this.totalPosition;
        }

        @Override
        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int _index) {
            if (this.tradeReference == null) {
                this.tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();
            }
            return (ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder)this.getIndex(this.tradeReference, _index, () -> {
                ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder newTradeReference = ReferenceWithMetaTrade.builder();
                return newTradeReference;
            });
        }

        @Override
        public AggregationParametersBuilder setDateTime(ZonedDateTime dateTime) {
            this.dateTime = dateTime == null ? null : dateTime;
            return this;
        }

        @Override
        public AggregationParametersBuilder addParty(ReferenceWithMetaParty party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addParty(ReferenceWithMetaParty party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(Party party) {
            this.getOrCreateParty(-1).setValue(party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(Party party, int _idx) {
            this.getOrCreateParty(_idx).setValue(party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addParty(List<? extends ReferenceWithMetaParty> partys) {
            if (partys != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : partys) {
                    this.party.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setParty(List<? extends ReferenceWithMetaParty> partys) {
            this.party = partys == null ? new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.addPartyValue(party);
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setPartyValue(List<? extends Party> partys) {
            this.party.clear();
            if (partys != null) {
                partys.forEach(this::addPartyValue);
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setPositionStatus(PositionStatusEnum positionStatus) {
            this.positionStatus = positionStatus == null ? null : positionStatus;
            return this;
        }

        @Override
        public AggregationParametersBuilder addProduct(Product product) {
            if (product != null) {
                this.product.add(product.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addProduct(Product product, int _idx) {
            this.getIndex(this.product, _idx, () -> product.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addProduct(List<? extends Product> products) {
            if (products != null) {
                for (Product product : products) {
                    this.product.add(product.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setProduct(List<? extends Product> products) {
            this.product = products == null ? new ArrayList<Product.ProductBuilder>() : (List)products.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder addProductQualifier(String productQualifier) {
            if (productQualifier != null) {
                this.productQualifier.add(productQualifier);
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addProductQualifier(String productQualifier, int _idx) {
            this.getIndex(this.productQualifier, _idx, () -> productQualifier);
            return this;
        }

        @Override
        public AggregationParametersBuilder addProductQualifier(List<? extends String> productQualifiers) {
            if (productQualifiers != null) {
                for (String string : productQualifiers) {
                    this.productQualifier.add(string);
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setProductQualifier(List<? extends String> productQualifiers) {
            this.productQualifier = productQualifiers == null ? new ArrayList<String>() : (List)productQualifiers.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder setTotalPosition(Boolean totalPosition) {
            this.totalPosition = totalPosition == null ? null : totalPosition;
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade tradeReference) {
            if (tradeReference != null) {
                this.tradeReference.add(tradeReference.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade tradeReference, int _idx) {
            this.getIndex(this.tradeReference, _idx, () -> tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(Trade tradeReference) {
            this.getOrCreateTradeReference(-1).setValue(tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(Trade tradeReference, int _idx) {
            this.getOrCreateTradeReference(_idx).setValue(tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            if (tradeReferences != null) {
                for (ReferenceWithMetaTrade referenceWithMetaTrade : tradeReferences) {
                    this.tradeReference.add(referenceWithMetaTrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            this.tradeReference = tradeReferences == null ? new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>() : (List)tradeReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(List<? extends Trade> tradeReferences) {
            if (tradeReferences != null) {
                for (Trade trade : tradeReferences) {
                    this.addTradeReferenceValue(trade);
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setTradeReferenceValue(List<? extends Trade> tradeReferences) {
            this.tradeReference.clear();
            if (tradeReferences != null) {
                tradeReferences.forEach(this::addTradeReferenceValue);
            }
            return this;
        }

        @Override
        public AggregationParameters build() {
            return new AggregationParametersImpl(this);
        }

        @Override
        public AggregationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public AggregationParametersBuilder prune() {
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.product = this.product.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeReference = this.tradeReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDateTime() != null) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPositionStatus() != null) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductQualifier() != null && !this.getProductQualifier().isEmpty()) {
                return true;
            }
            if (this.getTotalPosition() != null) {
                return true;
            }
            return this.getTradeReference() != null && this.getTradeReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AggregationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AggregationParametersBuilder o = (AggregationParametersBuilder)other;
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getProduct(), o.getProduct(), this::getOrCreateProduct);
            merger.mergeRosetta(this.getTradeReference(), o.getTradeReference(), this::getOrCreateTradeReference);
            merger.mergeBasic((Object)this.getDateTime(), (Object)o.getDateTime(), this::setDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPositionStatus(), (Object)o.getPositionStatus(), this::setPositionStatus, new AttributeMeta[0]);
            merger.mergeBasic(this.getProductQualifier(), o.getProductQualifier(), this::addProductQualifier);
            merger.mergeBasic((Object)this.getTotalPosition(), (Object)o.getTotalPosition(), this::setTotalPosition, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AggregationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.dateTime, _that.getDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.positionStatus, (Object)_that.getPositionStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            if (!Objects.equals(this.totalPosition, _that.getTotalPosition())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.positionStatus != null ? ((Object)((Object)this.positionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.totalPosition != null ? this.totalPosition.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AggregationParametersBuilder {dateTime=" + this.dateTime + ", party=" + this.party + ", positionStatus=" + (Object)((Object)this.positionStatus) + ", product=" + this.product + ", productQualifier=" + this.productQualifier + ", totalPosition=" + this.totalPosition + ", tradeReference=" + this.tradeReference + '}';
        }
    }

    public static class AggregationParametersImpl
    implements AggregationParameters {
        private final ZonedDateTime dateTime;
        private final List<? extends ReferenceWithMetaParty> party;
        private final PositionStatusEnum positionStatus;
        private final List<? extends Product> product;
        private final List<String> productQualifier;
        private final Boolean totalPosition;
        private final List<? extends ReferenceWithMetaTrade> tradeReference;

        protected AggregationParametersImpl(AggregationParametersBuilder builder) {
            this.dateTime = builder.getDateTime();
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.positionStatus = builder.getPositionStatus();
            this.product = Optional.ofNullable(builder.getProduct()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productQualifier = Optional.ofNullable(builder.getProductQualifier()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.totalPosition = builder.getTotalPosition();
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public ZonedDateTime getDateTime() {
            return this.dateTime;
        }

        @Override
        public List<? extends ReferenceWithMetaParty> getParty() {
            return this.party;
        }

        @Override
        public PositionStatusEnum getPositionStatus() {
            return this.positionStatus;
        }

        @Override
        public List<? extends Product> getProduct() {
            return this.product;
        }

        @Override
        public List<String> getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        public Boolean getTotalPosition() {
            return this.totalPosition;
        }

        @Override
        public List<? extends ReferenceWithMetaTrade> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public AggregationParameters build() {
            return this;
        }

        @Override
        public AggregationParametersBuilder toBuilder() {
            AggregationParametersBuilder builder = AggregationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AggregationParametersBuilder builder) {
            Optional.ofNullable(this.getDateTime()).ifPresent(builder::setDateTime);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPositionStatus()).ifPresent(builder::setPositionStatus);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getProductQualifier()).ifPresent(builder::setProductQualifier);
            Optional.ofNullable(this.getTotalPosition()).ifPresent(builder::setTotalPosition);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AggregationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.dateTime, _that.getDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.positionStatus, (Object)_that.getPositionStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            if (!Objects.equals(this.totalPosition, _that.getTotalPosition())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.positionStatus != null ? ((Object)((Object)this.positionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.totalPosition != null ? this.totalPosition.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AggregationParameters {dateTime=" + this.dateTime + ", party=" + this.party + ", positionStatus=" + (Object)((Object)this.positionStatus) + ", product=" + this.product + ", productQualifier=" + this.productQualifier + ", totalPosition=" + this.totalPosition + ", tradeReference=" + this.tradeReference + '}';
        }
    }

    public static interface AggregationParametersBuilder
    extends AggregationParameters,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateParty(int var1);

        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getParty();

        public Product.ProductBuilder getOrCreateProduct(int var1);

        public List<? extends Product.ProductBuilder> getProduct();

        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int var1);

        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference();

        public AggregationParametersBuilder setDateTime(ZonedDateTime var1);

        public AggregationParametersBuilder addParty(ReferenceWithMetaParty var1);

        public AggregationParametersBuilder addParty(ReferenceWithMetaParty var1, int var2);

        public AggregationParametersBuilder addPartyValue(Party var1);

        public AggregationParametersBuilder addPartyValue(Party var1, int var2);

        public AggregationParametersBuilder addParty(List<? extends ReferenceWithMetaParty> var1);

        public AggregationParametersBuilder setParty(List<? extends ReferenceWithMetaParty> var1);

        public AggregationParametersBuilder addPartyValue(List<? extends Party> var1);

        public AggregationParametersBuilder setPartyValue(List<? extends Party> var1);

        public AggregationParametersBuilder setPositionStatus(PositionStatusEnum var1);

        public AggregationParametersBuilder addProduct(Product var1);

        public AggregationParametersBuilder addProduct(Product var1, int var2);

        public AggregationParametersBuilder addProduct(List<? extends Product> var1);

        public AggregationParametersBuilder setProduct(List<? extends Product> var1);

        public AggregationParametersBuilder addProductQualifier(String var1);

        public AggregationParametersBuilder addProductQualifier(String var1, int var2);

        public AggregationParametersBuilder addProductQualifier(List<? extends String> var1);

        public AggregationParametersBuilder setProductQualifier(List<? extends String> var1);

        public AggregationParametersBuilder setTotalPosition(Boolean var1);

        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade var1);

        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade var1, int var2);

        public AggregationParametersBuilder addTradeReferenceValue(Trade var1);

        public AggregationParametersBuilder addTradeReferenceValue(Trade var1, int var2);

        public AggregationParametersBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public AggregationParametersBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public AggregationParametersBuilder addTradeReferenceValue(List<? extends Trade> var1);

        public AggregationParametersBuilder setTradeReferenceValue(List<? extends Trade> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, (Object)this.getDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("positionStatus"), PositionStatusEnum.class, (Object)this.getPositionStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productQualifier"), String.class, this.getProductQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalPosition"), Boolean.class, (Object)this.getTotalPosition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
        }

        public AggregationParametersBuilder prune();
    }
}

