/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ValuationValuationType")
@ImplementedBy(value=Default.class)
public interface ValuationValuationType
extends Validator<Valuation> {
    public static final String NAME = "ValuationValuationType";
    public static final String DEFINITION = "required choice method, source";

    public ValidationResult<Valuation> validate(RosettaPath var1, Valuation var2);

    public static class NoOp
    implements ValuationValuationType {
        @Override
        public ValidationResult<Valuation> validate(RosettaPath path, Valuation valuation) {
            return ValidationResult.success((String)ValuationValuationType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Valuation", (RosettaPath)path, (String)ValuationValuationType.DEFINITION);
        }
    }

    public static class Default
    implements ValuationValuationType {
        @Override
        public ValidationResult<Valuation> validate(RosettaPath path, Valuation valuation) {
            ComparisonResult result = this.executeDataRule(valuation);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ValuationValuationType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Valuation", (RosettaPath)path, (String)ValuationValuationType.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ValuationValuationType failed.";
            }
            return ValidationResult.failure((String)ValuationValuationType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Valuation", (RosettaPath)path, (String)ValuationValuationType.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Valuation valuation) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)valuation), Arrays.asList("method", "source"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

