/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradePackageTrade")
@ImplementedBy(value=Default.class)
public interface TradePackageTrade
extends Validator<Trade> {
    public static final String NAME = "TradePackageTrade";
    public static final String DEFINITION = "if executionDetails -> packageReference exists then executionDetails -> packageReference -> componentId -> assignedIdentifier contains tradeIdentifier -> assignedIdentifier";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradePackageTrade {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradePackageTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradePackageTrade.DEFINITION);
        }
    }

    public static class Default
    implements TradePackageTrade {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradePackageTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradePackageTrade.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradePackageTrade failed.";
            }
            return ValidationResult.failure((String)TradePackageTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradePackageTrade.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getExecutionDetails", _trade -> _trade.getExecutionDetails()).map("getPackageReference", executionDetails -> executionDetails.getPackageReference())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).map("getExecutionDetails", _trade -> _trade.getExecutionDetails()).map("getPackageReference", executionDetails -> executionDetails.getPackageReference()).mapC("getComponentId", identifiedList -> identifiedList.getComponentId()).mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()), (Mapper)MapperS.of((Object)trade).mapC("getTradeIdentifier", _trade -> _trade.getTradeIdentifier()).mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

