/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.State;
import cdm.event.position.PositionStatusEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="StateClosedStateExists")
@ImplementedBy(value=Default.class)
public interface StateClosedStateExists
extends Validator<State> {
    public static final String NAME = "StateClosedStateExists";
    public static final String DEFINITION = "if positionState = PositionStatusEnum -> Closed then closedState exists";

    public ValidationResult<State> validate(RosettaPath var1, State var2);

    public static class NoOp
    implements StateClosedStateExists {
        @Override
        public ValidationResult<State> validate(RosettaPath path, State state) {
            return ValidationResult.success((String)StateClosedStateExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"State", (RosettaPath)path, (String)StateClosedStateExists.DEFINITION);
        }
    }

    public static class Default
    implements StateClosedStateExists {
        @Override
        public ValidationResult<State> validate(RosettaPath path, State state) {
            ComparisonResult result = this.executeDataRule(state);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)StateClosedStateExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"State", (RosettaPath)path, (String)StateClosedStateExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition StateClosedStateExists failed.";
            }
            return ValidationResult.failure((String)StateClosedStateExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"State", (RosettaPath)path, (String)StateClosedStateExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(State state) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)state).map("getPositionState", _state -> _state.getPositionState()), (Mapper)MapperS.of((Object)((Object)PositionStatusEnum.CLOSED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)state).map("getClosedState", _state -> _state.getClosedState()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

