/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.event.common.Confirmation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ConfirmationBothBuyerAndSellerPartyRolesMustExist")
@ImplementedBy(value=Default.class)
public interface ConfirmationBothBuyerAndSellerPartyRolesMustExist
extends Validator<Confirmation> {
    public static final String NAME = "ConfirmationBothBuyerAndSellerPartyRolesMustExist";
    public static final String DEFINITION = "if lineage -> tradeReference -> tradableProduct -> product -> security exists then partyRole -> role contains PartyRoleEnum -> Buyer or partyRole -> role contains PartyRoleEnum -> Seller";

    public ValidationResult<Confirmation> validate(RosettaPath var1, Confirmation var2);

    public static class NoOp
    implements ConfirmationBothBuyerAndSellerPartyRolesMustExist {
        @Override
        public ValidationResult<Confirmation> validate(RosettaPath path, Confirmation confirmation) {
            return ValidationResult.success((String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Confirmation", (RosettaPath)path, (String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION);
        }
    }

    public static class Default
    implements ConfirmationBothBuyerAndSellerPartyRolesMustExist {
        @Override
        public ValidationResult<Confirmation> validate(RosettaPath path, Confirmation confirmation) {
            ComparisonResult result = this.executeDataRule(confirmation);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Confirmation", (RosettaPath)path, (String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ConfirmationBothBuyerAndSellerPartyRolesMustExist failed.";
            }
            return ValidationResult.failure((String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Confirmation", (RosettaPath)path, (String)ConfirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Confirmation confirmation) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)confirmation).map("getLineage", _confirmation -> _confirmation.getLineage()).mapC("getTradeReference", lineage -> lineage.getTradeReference()).map("getValue", _f -> _f.getValue()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)confirmation).mapC("getPartyRole", _confirmation -> _confirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BUYER))).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)confirmation).mapC("getPartyRole", _confirmation -> _confirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.SELLER))));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

