/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.CollateralPosition;
import cdm.event.common.CollateralStatusEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CollateralPositionCollateralPositionStatusSettledOrInTransitOnly")
@ImplementedBy(value=Default.class)
public interface CollateralPositionCollateralPositionStatusSettledOrInTransitOnly
extends Validator<CollateralPosition> {
    public static final String NAME = "CollateralPositionCollateralPositionStatusSettledOrInTransitOnly";
    public static final String DEFINITION = "if collateralPositionStatus exists then collateralPositionStatus = CollateralStatusEnum -> SettledAmount or collateralPositionStatus = CollateralStatusEnum -> InTransitAmount";

    public ValidationResult<CollateralPosition> validate(RosettaPath var1, CollateralPosition var2);

    public static class NoOp
    implements CollateralPositionCollateralPositionStatusSettledOrInTransitOnly {
        @Override
        public ValidationResult<CollateralPosition> validate(RosettaPath path, CollateralPosition collateralPosition) {
            return ValidationResult.success((String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralPosition", (RosettaPath)path, (String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.DEFINITION);
        }
    }

    public static class Default
    implements CollateralPositionCollateralPositionStatusSettledOrInTransitOnly {
        @Override
        public ValidationResult<CollateralPosition> validate(RosettaPath path, CollateralPosition collateralPosition) {
            ComparisonResult result = this.executeDataRule(collateralPosition);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralPosition", (RosettaPath)path, (String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CollateralPositionCollateralPositionStatusSettledOrInTransitOnly failed.";
            }
            return ValidationResult.failure((String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralPosition", (RosettaPath)path, (String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(CollateralPosition collateralPosition) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus()), (Mapper)MapperS.of((Object)((Object)CollateralStatusEnum.SETTLED_AMOUNT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus()), (Mapper)MapperS.of((Object)((Object)CollateralStatusEnum.IN_TRANSIT_AMOUNT)), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

