/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.BillingSummary;
import cdm.event.common.RecordAmountTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="BillingSummaryAccountTotal")
@ImplementedBy(value=Default.class)
public interface BillingSummaryAccountTotal
extends Validator<BillingSummary> {
    public static final String NAME = "BillingSummaryAccountTotal";
    public static final String DEFINITION = "if summaryAmountType = RecordAmountTypeEnum -> AccountTotal then summaryTransfer->payerReceiver->payerAccountReference exists and summaryTransfer->payerReceiver->receiverAccountReference exists";

    public ValidationResult<BillingSummary> validate(RosettaPath var1, BillingSummary var2);

    public static class NoOp
    implements BillingSummaryAccountTotal {
        @Override
        public ValidationResult<BillingSummary> validate(RosettaPath path, BillingSummary billingSummary) {
            return ValidationResult.success((String)BillingSummaryAccountTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryAccountTotal.DEFINITION);
        }
    }

    public static class Default
    implements BillingSummaryAccountTotal {
        @Override
        public ValidationResult<BillingSummary> validate(RosettaPath path, BillingSummary billingSummary) {
            ComparisonResult result = this.executeDataRule(billingSummary);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)BillingSummaryAccountTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryAccountTotal.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition BillingSummaryAccountTotal failed.";
            }
            return ValidationResult.failure((String)BillingSummaryAccountTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryAccountTotal.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(BillingSummary billingSummary) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)billingSummary).map("getSummaryAmountType", _billingSummary -> _billingSummary.getSummaryAmountType()), (Mapper)MapperS.of((Object)((Object)RecordAmountTypeEnum.ACCOUNT_TOTAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transferBase -> transferBase.getPayerReceiver()).map("getPayerAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getPayerAccountReference()).map("getValue", _f -> _f.getValue())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transferBase -> transferBase.getPayerReceiver()).map("getReceiverAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverAccountReference()).map("getValue", _f -> _f.getValue())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

