/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.event.common.Affirmation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="AffirmationBothBuyerAndSellerPartyRolesMustExist")
@ImplementedBy(value=Default.class)
public interface AffirmationBothBuyerAndSellerPartyRolesMustExist
extends Validator<Affirmation> {
    public static final String NAME = "AffirmationBothBuyerAndSellerPartyRolesMustExist";
    public static final String DEFINITION = "if lineage -> tradeReference -> tradableProduct -> product -> security exists then partyRole -> role contains PartyRoleEnum -> Buyer or partyRole -> role contains PartyRoleEnum -> Seller";

    public ValidationResult<Affirmation> validate(RosettaPath var1, Affirmation var2);

    public static class NoOp
    implements AffirmationBothBuyerAndSellerPartyRolesMustExist {
        @Override
        public ValidationResult<Affirmation> validate(RosettaPath path, Affirmation affirmation) {
            return ValidationResult.success((String)AffirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Affirmation", (RosettaPath)path, (String)AffirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION);
        }
    }

    public static class Default
    implements AffirmationBothBuyerAndSellerPartyRolesMustExist {
        @Override
        public ValidationResult<Affirmation> validate(RosettaPath path, Affirmation affirmation) {
            ComparisonResult result = this.executeDataRule(affirmation);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)AffirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Affirmation", (RosettaPath)path, (String)AffirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition AffirmationBothBuyerAndSellerPartyRolesMustExist failed.";
            }
            return ValidationResult.failure((String)AffirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Affirmation", (RosettaPath)path, (String)AffirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Affirmation affirmation) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)affirmation).map("getLineage", _affirmation -> _affirmation.getLineage()).mapC("getTradeReference", lineage -> lineage.getTradeReference()).map("getValue", _f -> _f.getValue()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)affirmation).mapC("getPartyRole", _affirmation -> _affirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BUYER))).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)affirmation).mapC("getPartyRole", _affirmation -> _affirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.SELLER))));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

