/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.metafields;

import cdm.event.common.Trade;
import cdm.event.common.metafields.ReferenceWithMetaTradeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ReferenceWithMetaTrade
extends RosettaModelObject,
ReferenceWithMeta<Trade> {
    public static final ReferenceWithMetaTradeMeta metaData = new ReferenceWithMetaTradeMeta();

    public ReferenceWithMetaTrade build();

    public ReferenceWithMetaTradeBuilder toBuilder();

    public String getExternalReference();

    public String getGlobalReference();

    public Reference getReference();

    public Trade getValue();

    default public RosettaMetaData<? extends ReferenceWithMetaTrade> metaData() {
        return metaData;
    }

    public static ReferenceWithMetaTradeBuilder builder() {
        return new ReferenceWithMetaTradeBuilderImpl();
    }

    default public Class<? extends ReferenceWithMetaTrade> getType() {
        return ReferenceWithMetaTrade.class;
    }

    default public Class<Trade> getValueType() {
        return Trade.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        this.processRosetta(path.newSubPath("reference"), processor, Reference.class, (RosettaModelObject)this.getReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("value"), processor, Trade.class, this.getValue(), new AttributeMeta[0]);
    }

    public static class ReferenceWithMetaTradeBuilderImpl
    implements ReferenceWithMetaTradeBuilder {
        protected String externalReference;
        protected String globalReference;
        protected Reference.ReferenceBuilder reference;
        protected Trade.TradeBuilder value;

        @Override
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        public Reference.ReferenceBuilder getReference() {
            return this.reference;
        }

        @Override
        public Reference.ReferenceBuilder getOrCreateReference() {
            Reference.ReferenceBuilder result = this.reference != null ? this.reference : (this.reference = Reference.builder());
            return result;
        }

        @Override
        public Trade.TradeBuilder getValue() {
            return this.value;
        }

        @Override
        public Trade.TradeBuilder getOrCreateValue() {
            Trade.TradeBuilder result = this.value != null ? this.value : (this.value = Trade.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaTradeBuilder setExternalReference(String externalReference) {
            this.externalReference = externalReference == null ? null : externalReference;
            return this;
        }

        @Override
        public ReferenceWithMetaTradeBuilder setGlobalReference(String globalReference) {
            this.globalReference = globalReference == null ? null : globalReference;
            return this;
        }

        @Override
        public ReferenceWithMetaTradeBuilder setReference(Reference reference) {
            this.reference = reference == null ? null : reference.toBuilder();
            return this;
        }

        @Override
        public ReferenceWithMetaTradeBuilder setValue(Trade value) {
            this.value = value == null ? null : value.toBuilder();
            return this;
        }

        @Override
        public ReferenceWithMetaTrade build() {
            return new ReferenceWithMetaTradeImpl(this);
        }

        @Override
        public ReferenceWithMetaTradeBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceWithMetaTradeBuilder prune() {
            if (this.reference != null && !this.reference.prune().hasData()) {
                this.reference = null;
            }
            if (this.value != null && !this.value.prune().hasData()) {
                this.value = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExternalReference() != null) {
                return true;
            }
            if (this.getGlobalReference() != null) {
                return true;
            }
            if (this.getReference() != null && this.getReference().hasData()) {
                return true;
            }
            return this.getValue() != null && this.getValue().hasData();
        }

        public ReferenceWithMetaTradeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceWithMetaTradeBuilder o = (ReferenceWithMetaTradeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReference(), (RosettaModelObjectBuilder)o.getReference(), this::setReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValue(), (RosettaModelObjectBuilder)o.getValue(), this::setValue);
            merger.mergeBasic((Object)this.getExternalReference(), (Object)o.getExternalReference(), this::setExternalReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGlobalReference(), (Object)o.getGlobalReference(), this::setGlobalReference, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaTrade _that = this.getType().cast(o);
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.reference, _that.getReference())) {
                return false;
            }
            return Objects.equals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaTradeBuilder {externalReference=" + this.externalReference + ", globalReference=" + this.globalReference + ", reference=" + this.reference + ", value=" + this.value + '}';
        }
    }

    public static class ReferenceWithMetaTradeImpl
    implements ReferenceWithMetaTrade {
        private final String externalReference;
        private final String globalReference;
        private final Reference reference;
        private final Trade value;

        protected ReferenceWithMetaTradeImpl(ReferenceWithMetaTradeBuilder builder) {
            this.externalReference = builder.getExternalReference();
            this.globalReference = builder.getGlobalReference();
            this.reference = Optional.ofNullable(builder.getReference()).map(f -> f.build()).orElse(null);
            this.value = Optional.ofNullable(builder.getValue()).map(f -> f.build()).orElse(null);
        }

        @Override
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        public Reference getReference() {
            return this.reference;
        }

        @Override
        public Trade getValue() {
            return this.value;
        }

        @Override
        public ReferenceWithMetaTrade build() {
            return this;
        }

        @Override
        public ReferenceWithMetaTradeBuilder toBuilder() {
            ReferenceWithMetaTradeBuilder builder = ReferenceWithMetaTrade.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceWithMetaTradeBuilder builder) {
            Optional.ofNullable(this.getExternalReference()).ifPresent(builder::setExternalReference);
            Optional.ofNullable(this.getGlobalReference()).ifPresent(builder::setGlobalReference);
            Optional.ofNullable(this.getReference()).ifPresent(builder::setReference);
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaTrade _that = this.getType().cast(o);
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.reference, _that.getReference())) {
                return false;
            }
            return Objects.equals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaTrade {externalReference=" + this.externalReference + ", globalReference=" + this.globalReference + ", reference=" + this.reference + ", value=" + this.value + '}';
        }
    }

    public static interface ReferenceWithMetaTradeBuilder
    extends ReferenceWithMetaTrade,
    RosettaModelObjectBuilder,
    ReferenceWithMeta.ReferenceWithMetaBuilder<Trade> {
        public Reference.ReferenceBuilder getOrCreateReference();

        public Reference.ReferenceBuilder getReference();

        public Trade.TradeBuilder getOrCreateValue();

        @Override
        public Trade.TradeBuilder getValue();

        public ReferenceWithMetaTradeBuilder setExternalReference(String var1);

        public ReferenceWithMetaTradeBuilder setGlobalReference(String var1);

        public ReferenceWithMetaTradeBuilder setReference(Reference var1);

        public ReferenceWithMetaTradeBuilder setValue(Trade var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            this.processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, (RosettaModelObjectBuilder)this.getReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("value"), processor, Trade.TradeBuilder.class, this.getValue(), new AttributeMeta[0]);
        }

        public ReferenceWithMetaTradeBuilder prune();
    }
}

