/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Transfer;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=TransfersForDateDefault.class)
public abstract class TransfersForDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Transfer> evaluate(List<? extends Transfer> transfers, Date date) {
        List<Transfer.TransferBuilder> transfersForDate = this.doEvaluate(transfers, date);
        if (transfersForDate != null) {
            this.objectValidator.validate(Transfer.class, transfersForDate);
        }
        return transfersForDate;
    }

    protected abstract List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> var1, Date var2);

    public static class TransfersForDateDefault
    extends TransfersForDate {
        @Override
        protected List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> transfers, Date date) {
            ArrayList<Transfer.TransferBuilder> transfersForDate = new ArrayList<Transfer.TransferBuilder>();
            return this.assignOutput(transfersForDate, transfers, date);
        }

        protected List<Transfer.TransferBuilder> assignOutput(List<Transfer.TransferBuilder> transfersForDate, List<? extends Transfer> transfers, Date date) {
            List addVar = this.toBuilder(MapperC.of(transfers).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getSettlementDate", transferBase -> transferBase.getSettlementDate()).map("getAdjustedDate", adjustableOrAdjustedOrRelativeDate -> adjustableOrAdjustedOrRelativeDate.getAdjustedDate()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)date), (CardinalityOperator)CardinalityOperator.All).get()).getMulti());
            transfersForDate.addAll(addVar);
            return Optional.ofNullable(transfersForDate).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

