/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Quantity;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.functions.FilterPrice;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.template.AssetPayout;
import cdm.product.template.metafields.ReferenceWithMetaAssetPayout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=SecurityFinanceCashSettlementAmountDefault.class)
public abstract class SecurityFinanceCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterPrice filterPrice;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Transfer evaluate(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)quantity)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)quantity).map("getUnit", measureBase -> measureBase.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return MapperS.ofNull();
        })), "");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).map("getSecurityInformation", _assetPayout -> _assetPayout.getSecurityInformation()).map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", productBase -> productBase.getProductIdentifier()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.All), "");
        Transfer.TransferBuilder cashSettlementAmount = this.doEvaluate(tradeState, date, quantity, payerReceiver);
        if (cashSettlementAmount != null) {
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)cashSettlementAmount);
        }
        return cashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract Mapper<? extends AssetPayout> assetPayout(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract Mapper<? extends Collateral> collateral(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract Mapper<? extends QuantitySchedule> securityQuantity(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract Mapper<? extends PriceSchedule> securityPrice(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract Mapper<BigDecimal> marginRatio(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    public static class SecurityFinanceCashSettlementAmountDefault
    extends SecurityFinanceCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            Transfer.TransferBuilder cashSettlementAmount = Transfer.builder();
            return this.assignOutput(cashSettlementAmount, tradeState, date, quantity, payerReceiver);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder cashSettlementAmount, TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            cashSettlementAmount.getOrCreateQuantity().setValue((BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)((PriceSchedule)this.securityPrice(tradeState, date, quantity, payerReceiver).get())).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperC.of((List)this.securityQuantity(tradeState, date, quantity, payerReceiver).getMulti()).map("getValue", measureBase -> measureBase.getValue())), (Mapper)MapperS.of((Object)((BigDecimal)this.marginRatio(tradeState, date, quantity, payerReceiver).get()))).get());
            cashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)((PriceSchedule)this.securityPrice(tradeState, date, quantity, payerReceiver).get())).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            cashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payerReceiver)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)payerReceiver).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                return MapperS.ofNull();
            }).get());
            cashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)payerReceiver)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)payerReceiver).map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", _payerReceiver -> _payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                return MapperS.ofNull();
            }).get());
            cashSettlementAmount.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)date).get());
            cashSettlementAmount.getOrCreateSettlementOrigin().setAssetPayout(ReferenceWithMetaAssetPayout.builder().setGlobalReference(Optional.ofNullable((AssetPayout)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((AssetPayout)MapperS.of((Object)((AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get())).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(cashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends AssetPayout> assetPayout(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)((AssetPayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
        }

        @Override
        protected Mapper<? extends Collateral> collateral(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral());
        }

        @Override
        protected Mapper<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperUtils.runMultiPolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)quantity)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)quantity);
                }
                return MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).getMulti(), (FinancialUnitEnum)((Object)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get()))));
            });
        }

        @Override
        protected Mapper<? extends PriceSchedule> securityPrice(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)this.filterPrice.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).getMulti(), (PriceTypeEnum)((Object)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)).get()), null, null, null, null, null, null));
        }

        @Override
        protected Mapper<BigDecimal> marginRatio(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, date, quantity, payerReceiver).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperMaths.divide((Mapper)MapperS.of((Object)1), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)new BigDecimal("1.0")), (Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, date, quantity, payerReceiver).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, date, quantity, payerReceiver).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, date, quantity, payerReceiver).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage());
                }
                return MapperS.of((Object)new BigDecimal("1.0"));
            });
        }
    }
}

