/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.Quantity;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.CalculateTransferInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.functions.EquityCashSettlementAmount;
import cdm.event.common.functions.InterestCashSettlementAmount;
import cdm.event.common.functions.SecurityFinanceCashSettlementAmount;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;

@ImplementedBy(value=ResolveTransferDefault.class)
public abstract class ResolveTransfer
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EquityCashSettlementAmount equityCashSettlementAmount;
    @Inject
    protected InterestCashSettlementAmount interestCashSettlementAmount;
    @Inject
    protected SecurityFinanceCashSettlementAmount securityFinanceCashSettlementAmount;

    public Transfer evaluate(CalculateTransferInstruction instruction) {
        Transfer.TransferBuilder transfer = this.doEvaluate(instruction);
        if (transfer != null) {
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction var1);

    protected abstract Mapper<? extends Payout> payout(CalculateTransferInstruction var1);

    public static class ResolveTransferDefault
    extends ResolveTransfer {
        @Override
        protected Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction instruction) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, instruction);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, CalculateTransferInstruction instruction) {
            transfer = (Transfer.TransferBuilder)this.toBuilder((RosettaModelObject)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Payout)this.payout(instruction).get())).mapC("getAssetPayout", _payout -> _payout.getAssetPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.securityFinanceCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get(), (Quantity)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity()).get(), (PayerReceiver)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).get()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Payout)this.payout(instruction).get())).mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.equityCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Payout)this.payout(instruction).get())).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)((Payout)this.payout(instruction).get())).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.interestCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (InterestRatePayout)MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)((Payout)this.payout(instruction).get())).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).get())).get(), MapperS.of((Object)instruction).mapC("getResets", calculateTransferInstruction -> calculateTransferInstruction.getResets()).getMulti(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get()));
                }
                return MapperS.ofNull();
            }).get());
            transfer.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends Payout> payout(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)instruction).map("getPayout", calculateTransferInstruction -> calculateTransferInstruction.getPayout()).map("getValue", _f -> _f.getValue());
        }
    }
}

