/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.base.math.functions.Create_NonNegativeQuantitySchedule;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_QuantityChangeInstruction;
import cdm.event.workflow.EventInstruction;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.functions.Create_PriceQuantity;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=ResolveRepurchaseTransferInstructionDefault.class)
public abstract class ResolveRepurchaseTransferInstruction
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_NonNegativeQuantitySchedule create_NonNegativeQuantitySchedule;
    @Inject
    protected Create_PriceQuantity create_PriceQuantity;
    @Inject
    protected Create_QuantityChangeInstruction create_QuantityChangeInstruction;

    public EventInstruction evaluate(TradeState tradeState, Date repurchaseDate) {
        EventInstruction.EventInstructionBuilder repurchaseInstruction = this.doEvaluate(tradeState, repurchaseDate);
        if (repurchaseInstruction != null) {
            this.objectValidator.validate(EventInstruction.class, (RosettaModelObject)repurchaseInstruction);
        }
        return repurchaseInstruction;
    }

    protected abstract EventInstruction.EventInstructionBuilder doEvaluate(TradeState var1, Date var2);

    protected abstract Mapper<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState var1, Date var2);

    protected abstract Mapper<? extends PriceQuantity> changePriceQuantity(TradeState var1, Date var2);

    public static class ResolveRepurchaseTransferInstructionDefault
    extends ResolveRepurchaseTransferInstruction {
        @Override
        protected EventInstruction.EventInstructionBuilder doEvaluate(TradeState tradeState, Date repurchaseDate) {
            EventInstruction.EventInstructionBuilder repurchaseInstruction = EventInstruction.builder();
            return this.assignOutput(repurchaseInstruction, tradeState, repurchaseDate);
        }

        protected EventInstruction.EventInstructionBuilder assignOutput(EventInstruction.EventInstructionBuilder repurchaseInstruction, TradeState tradeState, Date repurchaseDate) {
            repurchaseInstruction.setIntent((EventIntentEnum)((Object)MapperS.of((Object)((Object)EventIntentEnum.REPURCHASE)).get()));
            repurchaseInstruction.getOrCreateInstruction(0).setBeforeValue((TradeState)MapperS.of((Object)tradeState).get());
            repurchaseInstruction.getOrCreateInstruction(0).getOrCreatePrimitiveInstruction().setQuantityChange((QuantityChangeInstruction)MapperS.of((Object)this.create_QuantityChangeInstruction.evaluate(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((PriceQuantity)this.changePriceQuantity(tradeState, repurchaseDate).get()))}).getMulti(), (QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get()), Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()))).get());
            return Optional.ofNullable(repurchaseInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState tradeState, Date repurchaseDate) {
            return (Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).mapItem(item -> MapperS.of((Object)this.create_NonNegativeQuantitySchedule.evaluate((BigDecimal)MapperS.of((Object)new BigDecimal("0.0")).get(), (UnitType)item.map("getUnit", measureBase -> measureBase.getUnit()).get()))).apply(item -> ExpressionOperators.distinct((Mapper)item));
        }

        @Override
        protected Mapper<? extends PriceQuantity> changePriceQuantity(TradeState tradeState, Date repurchaseDate) {
            return MapperS.of((Object)this.create_PriceQuantity.evaluate(Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()), MapperC.of((List)this.changeQuantity(tradeState, repurchaseDate).getMulti()).getMulti(), null));
        }
    }
}

