/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Reset;
import cdm.observable.asset.Price;
import cdm.observable.event.Observation;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;

@ImplementedBy(value=ResolvePerformanceResetDefault.class)
public abstract class ResolvePerformanceReset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Reset evaluate(PerformancePayout performancePayout, Observation observation, Date date) {
        Reset.ResetBuilder reset = this.doEvaluate(performancePayout, observation, date);
        if (reset != null) {
            this.objectValidator.validate(Reset.class, (RosettaModelObject)reset);
        }
        return reset;
    }

    protected abstract Reset.ResetBuilder doEvaluate(PerformancePayout var1, Observation var2, Date var3);

    public static class ResolvePerformanceResetDefault
    extends ResolvePerformanceReset {
        @Override
        protected Reset.ResetBuilder doEvaluate(PerformancePayout performancePayout, Observation observation, Date date) {
            Reset.ResetBuilder reset = Reset.builder();
            return this.assignOutput(reset, performancePayout, observation, date);
        }

        protected Reset.ResetBuilder assignOutput(Reset.ResetBuilder reset, PerformancePayout performancePayout, Observation observation, Date date) {
            reset.setResetValue((Price)MapperS.of((Object)observation).map("getObservedValue", _observation -> _observation.getObservedValue()).get());
            reset.setResetDate((Date)MapperS.of((Object)date).get());
            reset.addObservationsValue(MapperS.of((Object)observation).getMulti());
            return Optional.ofNullable(reset).map(o -> o.prune()).orElse(null);
        }
    }
}

