/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.legaldocumentation.master.EquitySwapMasterConfirmation2018;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.util.Optional;

@ImplementedBy(value=NewFloatingPayoutDefault.class)
public abstract class NewFloatingPayout
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public InterestRatePayout evaluate(EquitySwapMasterConfirmation2018 masterConfirmation) {
        InterestRatePayout.InterestRatePayoutBuilder interestRatePayout = this.doEvaluate(masterConfirmation);
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)masterConfirmation)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()), (Mapper)MapperS.of((Object)masterConfirmation).map("getEquityCashSettlementDates", equitySwapMasterConfirmation2018 -> equitySwapMasterConfirmation2018.getEquityCashSettlementDates()), (CardinalityOperator)CardinalityOperator.All);
            }
            return MapperS.ofNull();
        })), "Interest rate payout must inherit terms from the Master Confirmation Agreement when it exists.");
        if (interestRatePayout != null) {
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRatePayout);
        }
        return interestRatePayout;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(EquitySwapMasterConfirmation2018 var1);

    public static class NewFloatingPayoutDefault
    extends NewFloatingPayout {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(EquitySwapMasterConfirmation2018 masterConfirmation) {
            InterestRatePayout.InterestRatePayoutBuilder interestRatePayout = InterestRatePayout.builder();
            return this.assignOutput(interestRatePayout, masterConfirmation);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRatePayout, EquitySwapMasterConfirmation2018 masterConfirmation) {
            return Optional.ofNullable(interestRatePayout).map(o -> o.prune()).orElse(null);
        }
    }
}

