/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.event.common.functions.NewFloatingPayout;
import cdm.event.common.functions.NewSingleNameEquityPerformancePayout;
import cdm.legaldocumentation.master.EquitySwapMasterConfirmation2018;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.util.Arrays;
import java.util.Optional;

@ImplementedBy(value=NewEquitySwapProductDefault.class)
public abstract class NewEquitySwapProduct
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected NewFloatingPayout newFloatingPayout;
    @Inject
    protected NewSingleNameEquityPerformancePayout newSingleNameEquityPerformancePayout;

    public Product evaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)security).map("getSecurityType", _security -> _security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All), "Security must be equity (single name).");
        Product.ProductBuilder product = this.doEvaluate(security, masterConfirmation);
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)masterConfirmation)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).mapC("getCashflow", _payout -> _payout.getCashflow()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).mapC("getForwardPayout", _payout -> _payout.getForwardPayout()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).mapC("getFixedPricePayout", _payout -> _payout.getFixedPricePayout()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.payout(product.toBuilder(), security, masterConfirmation).build()).mapC("getOptionPayout", _payout -> _payout.getOptionPayout())));
            }
            return MapperS.ofNull();
        })), "Other payout types must be absent.");
        this.conditionValidator.validate(() -> ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()))), "Non-contractual product types must be absent.");
        if (product != null) {
            this.objectValidator.validate(Product.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract Product.ProductBuilder doEvaluate(Security var1, EquitySwapMasterConfirmation2018 var2);

    protected abstract Payout.PayoutBuilder payout(Product.ProductBuilder var1, Security var2, EquitySwapMasterConfirmation2018 var3);

    public static class NewEquitySwapProductDefault
    extends NewEquitySwapProduct {
        @Override
        protected Product.ProductBuilder doEvaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            Product.ProductBuilder product = Product.builder();
            return this.assignOutput(product, security, masterConfirmation);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            product.getOrCreateContractualProduct().getOrCreateEconomicTerms().getOrCreatePayout().addPerformancePayout(MapperS.of((Object)this.newSingleNameEquityPerformancePayout.evaluate((Security)MapperS.of((Object)security).get(), (EquitySwapMasterConfirmation2018)MapperS.of((Object)masterConfirmation).get())).getMulti());
            product.getOrCreateContractualProduct().getOrCreateEconomicTerms().getOrCreatePayout().addInterestRatePayout(MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)masterConfirmation)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.newFloatingPayout.evaluate((EquitySwapMasterConfirmation2018)MapperS.of((Object)masterConfirmation).get()));
                }
                return MapperS.ofNull();
            }).getMulti());
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Payout.PayoutBuilder payout(Product.ProductBuilder product, Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            return (Payout.PayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).get());
        }
    }
}

