/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import cdm.product.asset.metafields.ReferenceWithMetaInterestRatePayout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=InterestCashSettlementAmountDefault.class)
public abstract class InterestCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FixedAmount fixedAmount;
    @Inject
    protected FloatingAmount floatingAmount;

    public Transfer evaluate(TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
        Transfer.TransferBuilder interestCashSettlementAmount = this.doEvaluate(tradeState, interestRatePayout, resets, date);
        if (interestCashSettlementAmount != null) {
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)interestCashSettlementAmount);
        }
        return interestCashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, InterestRatePayout var2, List<? extends Reset> var3, Date var4);

    protected abstract Mapper<BigDecimal> performance(TradeState var1, InterestRatePayout var2, List<? extends Reset> var3, Date var4);

    protected abstract Mapper<? extends Party> payer(TradeState var1, InterestRatePayout var2, List<? extends Reset> var3, Date var4);

    protected abstract Mapper<? extends Party> receiver(TradeState var1, InterestRatePayout var2, List<? extends Reset> var3, Date var4);

    public static class InterestCashSettlementAmountDefault
    extends InterestCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
            Transfer.TransferBuilder interestCashSettlementAmount = Transfer.builder();
            return this.assignOutput(interestCashSettlementAmount, tradeState, interestRatePayout, resets, date);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder interestCashSettlementAmount, TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
            interestCashSettlementAmount.getOrCreateQuantity().setValue((BigDecimal)MapperS.of((Object)((BigDecimal)this.performance(tradeState, interestRatePayout, resets, date).get())).get());
            interestCashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            interestCashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.performance(tradeState, interestRatePayout, resets, date).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.payer(tradeState, interestRatePayout, resets, date).get()));
                }
                return MapperS.of((Object)((Party)this.receiver(tradeState, interestRatePayout, resets, date).get()));
            }).get());
            interestCashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.performance(tradeState, interestRatePayout, resets, date).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.receiver(tradeState, interestRatePayout, resets, date).get()));
                }
                return MapperS.of((Object)((Party)this.payer(tradeState, interestRatePayout, resets, date).get()));
            }).get());
            interestCashSettlementAmount.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)date).get());
            interestCashSettlementAmount.getOrCreateSettlementOrigin().setInterestRatePayout(ReferenceWithMetaInterestRatePayout.builder().setGlobalReference(Optional.ofNullable((InterestRatePayout)MapperS.of((Object)interestRatePayout).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((InterestRatePayout)MapperS.of((Object)interestRatePayout).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(interestCashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> performance(TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.fixedAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (BigDecimal)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()).get(), (Date)MapperS.of((Object)date).get(), null));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.floatingAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (BigDecimal)MapperS.of((Object)((Reset)MapperC.of((List)resets).get())).map("getResetValue", reset -> reset.getResetValue()).map("getValue", measureBase -> measureBase.getValue()).get(), (BigDecimal)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()).get(), (Date)MapperS.of((Object)date).get(), null));
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected Mapper<? extends Party> payer(TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)interestRatePayout).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<? extends Party> receiver(TradeState tradeState, InterestRatePayout interestRatePayout, List<? extends Reset> resets, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)interestRatePayout).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }
    }
}

