/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.TradeState;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=FilterClosedTradeStatesDefault.class)
public abstract class FilterClosedTradeStates
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends TradeState> evaluate(List<? extends TradeState> tradeStates) {
        List<TradeState.TradeStateBuilder> closedTradeStates = this.doEvaluate(tradeStates);
        if (closedTradeStates != null) {
            this.objectValidator.validate(TradeState.class, closedTradeStates);
        }
        return closedTradeStates;
    }

    protected abstract List<TradeState.TradeStateBuilder> doEvaluate(List<? extends TradeState> var1);

    public static class FilterClosedTradeStatesDefault
    extends FilterClosedTradeStates {
        @Override
        protected List<TradeState.TradeStateBuilder> doEvaluate(List<? extends TradeState> tradeStates) {
            ArrayList<TradeState.TradeStateBuilder> closedTradeStates = new ArrayList<TradeState.TradeStateBuilder>();
            return this.assignOutput(closedTradeStates, tradeStates);
        }

        protected List<TradeState.TradeStateBuilder> assignOutput(List<TradeState.TradeStateBuilder> closedTradeStates, List<? extends TradeState> tradeStates) {
            List addVar = this.toBuilder(MapperC.of(tradeStates).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getState", tradeState -> tradeState.getState()).map("getClosedState", state -> state.getClosedState())).get()).getMulti());
            closedTradeStates.addAll(addVar);
            return Optional.ofNullable(closedTradeStates).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

