/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Transfer;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=FilterCashTransfersDefault.class)
public abstract class FilterCashTransfers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Transfer> evaluate(List<? extends Transfer> transfers) {
        List<Transfer.TransferBuilder> cashTransfers = this.doEvaluate(transfers);
        if (cashTransfers != null) {
            this.objectValidator.validate(Transfer.class, cashTransfers);
        }
        return cashTransfers;
    }

    protected abstract List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> var1);

    public static class FilterCashTransfersDefault
    extends FilterCashTransfers {
        @Override
        protected List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> transfers) {
            ArrayList<Transfer.TransferBuilder> cashTransfers = new ArrayList<Transfer.TransferBuilder>();
            return this.assignOutput(cashTransfers, transfers);
        }

        protected List<Transfer.TransferBuilder> assignOutput(List<Transfer.TransferBuilder> cashTransfers, List<? extends Transfer> transfers) {
            List addVar = this.toBuilder(MapperC.of(transfers).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getQuantity", transferBase -> transferBase.getQuantity()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue())).get()).getMulti());
            cashTransfers.addAll(addVar);
            return Optional.ofNullable(cashTransfers).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

