/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Trade;
import cdm.event.common.functions.EquityNotionalAmount;
import cdm.event.common.functions.RateOfReturn;
import cdm.observable.asset.Observable;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.functions.ResolvePerformancePeriodStartPrice;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;

@ImplementedBy(value=EquityPerformanceDefault.class)
public abstract class EquityPerformance
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected EquityNotionalAmount equityNotionalAmount;
    @Inject
    protected RateOfReturn rateOfReturn0;
    @Inject
    protected ResolvePerformancePeriodStartPrice resolvePerformancePeriodStartPrice;

    public BigDecimal evaluate(Trade trade, Price observation, Date date) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms())), "");
        BigDecimal equityPerformance = this.doEvaluate(trade, observation, date);
        return equityPerformance;
    }

    protected abstract BigDecimal doEvaluate(Trade var1, Price var2, Date var3);

    protected abstract Mapper<? extends PerformancePayout> performancePayout(Trade var1, Price var2, Date var3);

    protected abstract Mapper<? extends PriceSchedule> periodStartPrice(Trade var1, Price var2, Date var3);

    protected abstract Mapper<? extends Price> periodEndPrice(Trade var1, Price var2, Date var3);

    protected abstract Mapper<BigDecimal> numberOfSecurities(Trade var1, Price var2, Date var3);

    protected abstract Mapper<BigDecimal> rateOfReturn1(Trade var1, Price var2, Date var3);

    protected abstract Mapper<BigDecimal> notionalAmount(Trade var1, Price var2, Date var3);

    public static class EquityPerformanceDefault
    extends EquityPerformance {
        @Override
        protected BigDecimal doEvaluate(Trade trade, Price observation, Date date) {
            BigDecimal equityPerformance = null;
            return this.assignOutput(equityPerformance, trade, observation, date);
        }

        protected BigDecimal assignOutput(BigDecimal equityPerformance, Trade trade, Price observation, Date date) {
            equityPerformance = (BigDecimal)MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.rateOfReturn1(trade, observation, date).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.notionalAmount(trade, observation, date).get()))).get();
            return equityPerformance;
        }

        @Override
        protected Mapper<? extends PerformancePayout> performancePayout(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()));
        }

        @Override
        protected Mapper<? extends PriceSchedule> periodStartPrice(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)this.resolvePerformancePeriodStartPrice.evaluate((PerformancePayout)MapperS.of((Object)((PerformancePayout)this.performancePayout(trade, observation, date).get())).get(), MapperS.of((Object)((TradeLot)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).getMulti(), (Observable)MapperS.of((Object)((Observable)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).get())).get(), (Date)MapperS.of((Object)date).get()));
        }

        @Override
        protected Mapper<? extends Price> periodEndPrice(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)observation);
        }

        @Override
        protected Mapper<BigDecimal> numberOfSecurities(Trade trade, Price observation, Date date) {
            return MapperMaths.divide((Mapper)MapperS.of((Object)((PerformancePayout)this.performancePayout(trade, observation, date).get())).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperS.of((Object)((PriceSchedule)this.periodStartPrice(trade, observation, date).get())).map("getValue", measureBase -> measureBase.getValue()));
        }

        @Override
        protected Mapper<BigDecimal> rateOfReturn1(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)this.rateOfReturn0.evaluate((PriceSchedule)MapperS.of((Object)((PriceSchedule)this.periodStartPrice(trade, observation, date).get())).get(), (PriceSchedule)MapperS.of((Object)((Price)this.periodEndPrice(trade, observation, date).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> notionalAmount(Trade trade, Price observation, Date date) {
            return MapperS.of((Object)this.equityNotionalAmount.evaluate((BigDecimal)MapperS.of((Object)((BigDecimal)this.numberOfSecurities(trade, observation, date).get())).get(), (Price)MapperS.of((Object)((Price)this.periodEndPrice(trade, observation, date).get())).get()));
        }
    }
}

