/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.Quantity;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.product.common.settlement.TransferSettlementEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.Arrays;
import java.util.Optional;

@ImplementedBy(value=Create_SecurityTransferDefault.class)
public abstract class Create_SecurityTransfer
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public Transfer evaluate(TradeState tradeState, Date date, Quantity quantity) {
        Transfer.TransferBuilder transfer = this.doEvaluate(tradeState, date, quantity);
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getSecurity", product -> product.getSecurity())).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((TransferSettlementEnum)((Object)((Object)((Object)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).map("getSettlementTerms", priceQuantity -> priceQuantity.getSettlementTerms()).map("getTransferSettlementType", settlementBase -> settlementBase.getTransferSettlementType()).get())))))), (Mapper)MapperS.of((Object)((Object)TransferSettlementEnum.DELIVERY_VERSUS_PAYMENT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)transfer).map("getQuantity", transferBase -> transferBase.getQuantity()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)transfer).map("getObservable", transferBase -> transferBase.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("getValue", _f -> _f.getValue())));
            }
            return MapperS.ofNull();
        })), "");
        if (transfer != null) {
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Date var2, Quantity var3);

    public static class Create_SecurityTransferDefault
    extends Create_SecurityTransfer {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Date date, Quantity quantity) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, tradeState, date, quantity);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, TradeState tradeState, Date date, Quantity quantity) {
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }
    }
}

