/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TermsChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_PrimitiveInstruction;
import cdm.event.common.functions.Create_QuantityChangeInstruction;
import cdm.event.common.functions.Create_RollTermChangeInstruction;
import cdm.event.common.functions.Create_TerminationInstruction;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=Create_RollPrimitiveInstructionDefault.class)
public abstract class Create_RollPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_PrimitiveInstruction create_PrimitiveInstruction;
    @Inject
    protected Create_QuantityChangeInstruction create_QuantityChangeInstruction;
    @Inject
    protected Create_RollTermChangeInstruction create_RollTermChangeInstruction;
    @Inject
    protected Create_TerminationInstruction create_TerminationInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveRollDate, AdjustableOrRelativeDate terminationDate, List<? extends PriceQuantity> priceQuantity) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct())), "Only a contractual product can be rolled.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instruction = this.doEvaluate(tradeState, effectiveRollDate, terminationDate, priceQuantity);
        if (instruction != null) {
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, AdjustableOrRelativeDate var2, AdjustableOrRelativeDate var3, List<? extends PriceQuantity> var4);

    public static class Create_RollPrimitiveInstructionDefault
    extends Create_RollPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, AdjustableOrRelativeDate effectiveRollDate, AdjustableOrRelativeDate terminationDate, List<? extends PriceQuantity> priceQuantity) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, effectiveRollDate, terminationDate, priceQuantity);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, AdjustableOrRelativeDate effectiveRollDate, AdjustableOrRelativeDate terminationDate, List<? extends PriceQuantity> priceQuantity) {
            instruction.getOrCreateSplit().setBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.create_TerminationInstruction.evaluate((TradeState)MapperS.of((Object)tradeState).get()))}).getMulti());
            instruction.getOrCreateSplit().addBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.create_PrimitiveInstruction.evaluate(null, null, null, null, (QuantityChangeInstruction)MapperS.of((Object)this.create_QuantityChangeInstruction.evaluate(MapperC.of(priceQuantity).getMulti(), (QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get()), Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()))).get(), null, null, (TermsChangeInstruction)MapperS.of((Object)this.create_RollTermChangeInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), (AdjustableOrRelativeDate)MapperS.of((Object)effectiveRollDate).get(), (AdjustableOrRelativeDate)MapperS.of((Object)terminationDate).get())).get(), null, null, null, null))}).getMulti());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

