/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.functions.Create_QuantityChangeInstruction;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.functions.Create_Price;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.functions.Create_PriceQuantity;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=Create_OnDemandRateChangePriceChangeInstructionDefault.class)
public abstract class Create_OnDemandRateChangePriceChangeInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_Price create_Price;
    @Inject
    protected Create_PriceQuantity create_PriceQuantity;
    @Inject
    protected Create_QuantityChangeInstruction create_QuantityChangeInstruction;

    public QuantityChangeInstruction evaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get()))), "There should be 1 and only 1 rate type price in the current price.");
        QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction = this.doEvaluate(priceQuantity, newRate);
        if (quantityChangeInstruction != null) {
            this.objectValidator.validate(QuantityChangeInstruction.class, (RosettaModelObject)quantityChangeInstruction);
        }
        return quantityChangeInstruction;
    }

    protected abstract QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends PriceSchedule> currentRatePrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends Price> newPrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract Mapper<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> var1, BigDecimal var2);

    public static class Create_OnDemandRateChangePriceChangeInstructionDefault
    extends Create_OnDemandRateChangePriceChangeInstruction {
        @Override
        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction = QuantityChangeInstruction.builder();
            return this.assignOutput(quantityChangeInstruction, priceQuantity, newRate);
        }

        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder assignOutput(QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction, List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            quantityChangeInstruction = (QuantityChangeInstruction.QuantityChangeInstructionBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.create_QuantityChangeInstruction.evaluate(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((PriceQuantity)this.newPriceQuantity(priceQuantity, newRate).get()))}).getMulti(), (QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get()), Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()))).get());
            return Optional.ofNullable(quantityChangeInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends PriceSchedule> currentRatePrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return (Mapper)((MapperC)((MapperC)MapperC.of(priceQuantity).mapItemToList(item -> item.mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue())).apply(item -> item.flattenList())).apply(item -> item.filterItemNullSafe(_item -> ExpressionOperators.areEqual((Mapper)_item.map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get()))).apply(item -> MapperS.of((Object)((PriceSchedule)item.get())));
        }

        @Override
        protected Mapper<? extends Price> newPrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)this.create_Price.evaluate((BigDecimal)MapperS.of((Object)newRate).get(), (UnitType)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getUnit", measureBase -> measureBase.getUnit()).get(), (UnitType)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get(), (PriceExpression)MapperS.of((Object)((PriceSchedule)this.currentRatePrice(priceQuantity, newRate).get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get()));
        }

        @Override
        protected Mapper<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)this.create_PriceQuantity.evaluate(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Price)this.newPrice(priceQuantity, newRate).get()))}).getMulti(), Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()), null));
        }
    }
}

