/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TermsChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_Cashflow;
import cdm.event.common.functions.Create_CashflowTermsChangeInstruction;
import cdm.event.common.functions.Create_CashflowType;
import cdm.event.common.functions.Create_PrimitiveInstruction;
import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.ScheduledTransferEnum;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=Create_OnDemandInterestPaymentPrimitiveInstructionDefault.class)
public abstract class Create_OnDemandInterestPaymentPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_Cashflow create_Cashflow;
    @Inject
    protected Create_CashflowTermsChangeInstruction create_CashflowTermsChangeInstruction;
    @Inject
    protected Create_CashflowType create_CashflowType;
    @Inject
    protected Create_PrimitiveInstruction create_PrimitiveInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, interestAmount, settlementDate).get()))), "Only a contractual product with a single interest rate payout can have an on-demand interest payment.");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)interestAmount).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, interestAmount, settlementDate).get())).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()), (CardinalityOperator)CardinalityOperator.All), "The currency of the interest amount must match the currency of the original interest rate payout.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instruction = this.doEvaluate(tradeState, interestAmount, settlementDate);
        if (instruction != null) {
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, Money var2, SettlementDate var3);

    protected abstract Mapper<? extends InterestRatePayout> interestRatePayout(TradeState var1, Money var2, SettlementDate var3);

    protected abstract Mapper<? extends Cashflow> cashflow(TradeState var1, Money var2, SettlementDate var3);

    public static class Create_OnDemandInterestPaymentPrimitiveInstructionDefault
    extends Create_OnDemandInterestPaymentPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, interestAmount, settlementDate);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            instruction = (PrimitiveInstruction.PrimitiveInstructionBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.create_PrimitiveInstruction.evaluate(null, null, null, null, null, null, null, (TermsChangeInstruction)MapperS.of((Object)this.create_CashflowTermsChangeInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), (Cashflow)MapperS.of((Object)((Cashflow)this.cashflow(tradeState, interestAmount, settlementDate).get())).get())).get(), null, null, null, null)).get());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()));
        }

        @Override
        protected Mapper<? extends Cashflow> cashflow(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)this.create_Cashflow.evaluate((BigDecimal)MapperS.of((Object)interestAmount).map("getValue", measureBase -> measureBase.getValue()).get(), (String)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, interestAmount, settlementDate).get())).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get(), (SettlementDate)MapperS.of((Object)settlementDate).get(), (PayerReceiver)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, interestAmount, settlementDate).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).get(), (CashflowType)MapperS.of((Object)this.create_CashflowType.evaluate((ScheduledTransferEnum)((Object)MapperS.of((Object)((Object)ScheduledTransferEnum.NET_INTEREST)).get()), null, null, null)).get(), null));
        }
    }
}

