/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.ContractFormationInstruction;
import cdm.event.common.TradeState;
import cdm.event.position.PositionStatusEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;

@ImplementedBy(value=Create_ContractFormationDefault.class)
public abstract class Create_ContractFormation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeState evaluate(ContractFormationInstruction instruction, TradeState execution) {
        TradeState.TradeStateBuilder contractFormation = this.doEvaluate(instruction, execution);
        if (contractFormation != null) {
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)contractFormation);
        }
        return contractFormation;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(ContractFormationInstruction var1, TradeState var2);

    public static class Create_ContractFormationDefault
    extends Create_ContractFormation {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(ContractFormationInstruction instruction, TradeState execution) {
            TradeState.TradeStateBuilder contractFormation = TradeState.builder();
            return this.assignOutput(contractFormation, instruction, execution);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder contractFormation, ContractFormationInstruction instruction, TradeState execution) {
            contractFormation = (TradeState.TradeStateBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)execution).get());
            contractFormation.getOrCreateTrade().getOrCreateContractDetails().addDocumentation(MapperS.of((Object)instruction).mapC("getLegalAgreement", contractFormationInstruction -> contractFormationInstruction.getLegalAgreement()).getMulti());
            contractFormation.getOrCreateState().setPositionState((PositionStatusEnum)((Object)MapperS.of((Object)((Object)PositionStatusEnum.FORMED)).get()));
            return Optional.ofNullable(contractFormation).map(o -> o.prune()).orElse(null);
        }
    }
}

