/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.ValuationSourceEnum;
import cdm.event.common.ValuationTypeEnum;
import cdm.event.common.meta.ValuationMeta;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Valuation
extends RosettaModelObject {
    public static final ValuationMeta metaData = new ValuationMeta();

    public Valuation build();

    public ValuationBuilder toBuilder();

    public Money getAmount();

    public BigDecimal getDelta();

    public ValuationTypeEnum getMethod();

    public ValuationSourceEnum getSource();

    public ZonedDateTime getTimestamp();

    default public RosettaMetaData<? extends Valuation> metaData() {
        return metaData;
    }

    public static ValuationBuilder builder() {
        return new ValuationBuilderImpl();
    }

    default public Class<? extends Valuation> getType() {
        return Valuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("method"), ValuationTypeEnum.class, (Object)this.getMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("source"), ValuationSourceEnum.class, (Object)this.getSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("timestamp"), ZonedDateTime.class, (Object)this.getTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class ValuationBuilderImpl
    implements ValuationBuilder {
        protected Money.MoneyBuilder amount;
        protected BigDecimal delta;
        protected ValuationTypeEnum method;
        protected ValuationSourceEnum source;
        protected ZonedDateTime timestamp;

        @Override
        public Money.MoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmount() {
            Money.MoneyBuilder result = this.amount != null ? this.amount : (this.amount = Money.builder());
            return result;
        }

        @Override
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        public ValuationTypeEnum getMethod() {
            return this.method;
        }

        @Override
        public ValuationSourceEnum getSource() {
            return this.source;
        }

        @Override
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public ValuationBuilder setAmount(Money amount) {
            this.amount = amount == null ? null : amount.toBuilder();
            return this;
        }

        @Override
        public ValuationBuilder setDelta(BigDecimal delta) {
            this.delta = delta == null ? null : delta;
            return this;
        }

        @Override
        public ValuationBuilder setMethod(ValuationTypeEnum method) {
            this.method = method == null ? null : method;
            return this;
        }

        @Override
        public ValuationBuilder setSource(ValuationSourceEnum source) {
            this.source = source == null ? null : source;
            return this;
        }

        @Override
        public ValuationBuilder setTimestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp == null ? null : timestamp;
            return this;
        }

        @Override
        public Valuation build() {
            return new ValuationImpl(this);
        }

        @Override
        public ValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getMethod() != null) {
                return true;
            }
            if (this.getSource() != null) {
                return true;
            }
            return this.getTimestamp() != null;
        }

        public ValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationBuilder o = (ValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMethod(), (Object)o.getMethod(), this::setMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSource(), (Object)o.getSource(), this::setSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTimestamp(), (Object)o.getTimestamp(), this::setTimestamp, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Valuation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.source, (Object)_that.getSource())) {
                return false;
            }
            return Objects.equals(this.timestamp, _that.getTimestamp());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.source != null ? ((Object)((Object)this.source)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationBuilder {amount=" + this.amount + ", delta=" + this.delta + ", method=" + (Object)((Object)this.method) + ", source=" + (Object)((Object)this.source) + ", timestamp=" + this.timestamp + '}';
        }
    }

    public static class ValuationImpl
    implements Valuation {
        private final Money amount;
        private final BigDecimal delta;
        private final ValuationTypeEnum method;
        private final ValuationSourceEnum source;
        private final ZonedDateTime timestamp;

        protected ValuationImpl(ValuationBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.delta = builder.getDelta();
            this.method = builder.getMethod();
            this.source = builder.getSource();
            this.timestamp = builder.getTimestamp();
        }

        @Override
        public Money getAmount() {
            return this.amount;
        }

        @Override
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        public ValuationTypeEnum getMethod() {
            return this.method;
        }

        @Override
        public ValuationSourceEnum getSource() {
            return this.source;
        }

        @Override
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Valuation build() {
            return this;
        }

        @Override
        public ValuationBuilder toBuilder() {
            ValuationBuilder builder = Valuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getMethod()).ifPresent(builder::setMethod);
            Optional.ofNullable(this.getSource()).ifPresent(builder::setSource);
            Optional.ofNullable(this.getTimestamp()).ifPresent(builder::setTimestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Valuation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.source, (Object)_that.getSource())) {
                return false;
            }
            return Objects.equals(this.timestamp, _that.getTimestamp());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.source != null ? ((Object)((Object)this.source)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Valuation {amount=" + this.amount + ", delta=" + this.delta + ", method=" + (Object)((Object)this.method) + ", source=" + (Object)((Object)this.source) + ", timestamp=" + this.timestamp + '}';
        }
    }

    public static interface ValuationBuilder
    extends Valuation,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAmount();

        @Override
        public Money.MoneyBuilder getAmount();

        public ValuationBuilder setAmount(Money var1);

        public ValuationBuilder setDelta(BigDecimal var1);

        public ValuationBuilder setMethod(ValuationTypeEnum var1);

        public ValuationBuilder setSource(ValuationSourceEnum var1);

        public ValuationBuilder setTimestamp(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("method"), ValuationTypeEnum.class, (Object)this.getMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("source"), ValuationSourceEnum.class, (Object)this.getSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("timestamp"), ZonedDateTime.class, (Object)this.getTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        public ValuationBuilder prune();
    }
}

