/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.TransferState;
import cdm.event.common.meta.TransferInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface TransferInstruction
extends RosettaModelObject {
    public static final TransferInstructionMeta metaData = new TransferInstructionMeta();

    public TransferInstruction build();

    public TransferInstructionBuilder toBuilder();

    public List<? extends TransferState> getTransferState();

    default public RosettaMetaData<? extends TransferInstruction> metaData() {
        return metaData;
    }

    public static TransferInstructionBuilder builder() {
        return new TransferInstructionBuilderImpl();
    }

    default public Class<? extends TransferInstruction> getType() {
        return TransferInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("transferState"), processor, TransferState.class, this.getTransferState(), new AttributeMeta[0]);
    }

    public static class TransferInstructionBuilderImpl
    implements TransferInstructionBuilder {
        protected List<TransferState.TransferStateBuilder> transferState = new ArrayList<TransferState.TransferStateBuilder>();

        @Override
        public List<? extends TransferState.TransferStateBuilder> getTransferState() {
            return this.transferState;
        }

        @Override
        public TransferState.TransferStateBuilder getOrCreateTransferState(int _index) {
            if (this.transferState == null) {
                this.transferState = new ArrayList<TransferState.TransferStateBuilder>();
            }
            return (TransferState.TransferStateBuilder)this.getIndex(this.transferState, _index, () -> {
                TransferState.TransferStateBuilder newTransferState = TransferState.builder();
                return newTransferState;
            });
        }

        @Override
        public TransferInstructionBuilder addTransferState(TransferState transferState) {
            if (transferState != null) {
                this.transferState.add(transferState.toBuilder());
            }
            return this;
        }

        @Override
        public TransferInstructionBuilder addTransferState(TransferState transferState, int _idx) {
            this.getIndex(this.transferState, _idx, () -> transferState.toBuilder());
            return this;
        }

        @Override
        public TransferInstructionBuilder addTransferState(List<? extends TransferState> transferStates) {
            if (transferStates != null) {
                for (TransferState transferState : transferStates) {
                    this.transferState.add(transferState.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TransferInstructionBuilder setTransferState(List<? extends TransferState> transferStates) {
            this.transferState = transferStates == null ? new ArrayList<TransferState.TransferStateBuilder>() : (List)transferStates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TransferInstruction build() {
            return new TransferInstructionImpl(this);
        }

        @Override
        public TransferInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferInstructionBuilder prune() {
            this.transferState = this.transferState.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getTransferState() != null && this.getTransferState().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TransferInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransferInstructionBuilder o = (TransferInstructionBuilder)other;
            merger.mergeRosetta(this.getTransferState(), o.getTransferState(), this::getOrCreateTransferState);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferInstruction _that = this.getType().cast(o);
            return ListEquals.listEquals(this.transferState, _that.getTransferState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.transferState != null ? this.transferState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferInstructionBuilder {transferState=" + this.transferState + '}';
        }
    }

    public static class TransferInstructionImpl
    implements TransferInstruction {
        private final List<? extends TransferState> transferState;

        protected TransferInstructionImpl(TransferInstructionBuilder builder) {
            this.transferState = Optional.ofNullable(builder.getTransferState()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends TransferState> getTransferState() {
            return this.transferState;
        }

        @Override
        public TransferInstruction build() {
            return this;
        }

        @Override
        public TransferInstructionBuilder toBuilder() {
            TransferInstructionBuilder builder = TransferInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferInstructionBuilder builder) {
            Optional.ofNullable(this.getTransferState()).ifPresent(builder::setTransferState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferInstruction _that = this.getType().cast(o);
            return ListEquals.listEquals(this.transferState, _that.getTransferState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.transferState != null ? this.transferState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferInstruction {transferState=" + this.transferState + '}';
        }
    }

    public static interface TransferInstructionBuilder
    extends TransferInstruction,
    RosettaModelObjectBuilder {
        public TransferState.TransferStateBuilder getOrCreateTransferState(int var1);

        public List<? extends TransferState.TransferStateBuilder> getTransferState();

        public TransferInstructionBuilder addTransferState(TransferState var1);

        public TransferInstructionBuilder addTransferState(TransferState var1, int var2);

        public TransferInstructionBuilder addTransferState(List<? extends TransferState> var1);

        public TransferInstructionBuilder setTransferState(List<? extends TransferState> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("transferState"), processor, TransferState.TransferStateBuilder.class, this.getTransferState(), new AttributeMeta[0]);
        }

        public TransferInstructionBuilder prune();
    }
}

