/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.TimeZone;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.event.common.Trade;
import cdm.event.common.meta.TradePricingReportMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface TradePricingReport
extends RosettaModelObject {
    public static final TradePricingReportMeta metaData = new TradePricingReportMeta();

    public TradePricingReport build();

    public TradePricingReportBuilder toBuilder();

    public FloatingRateIndexEnum getDiscountingIndex();

    public TimeZone getPricingTime();

    public Trade getTrade();

    default public RosettaMetaData<? extends TradePricingReport> metaData() {
        return metaData;
    }

    public static TradePricingReportBuilder builder() {
        return new TradePricingReportBuilderImpl();
    }

    default public Class<? extends TradePricingReport> getType() {
        return TradePricingReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("discountingIndex"), FloatingRateIndexEnum.class, (Object)this.getDiscountingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingTime"), processor, TimeZone.class, this.getPricingTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
    }

    public static class TradePricingReportBuilderImpl
    implements TradePricingReportBuilder {
        protected FloatingRateIndexEnum discountingIndex;
        protected TimeZone.TimeZoneBuilder pricingTime;
        protected Trade.TradeBuilder trade;

        @Override
        public FloatingRateIndexEnum getDiscountingIndex() {
            return this.discountingIndex;
        }

        @Override
        public TimeZone.TimeZoneBuilder getPricingTime() {
            return this.pricingTime;
        }

        @Override
        public TimeZone.TimeZoneBuilder getOrCreatePricingTime() {
            TimeZone.TimeZoneBuilder result = this.pricingTime != null ? this.pricingTime : (this.pricingTime = TimeZone.builder());
            return result;
        }

        @Override
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        public TradePricingReportBuilder setDiscountingIndex(FloatingRateIndexEnum discountingIndex) {
            this.discountingIndex = discountingIndex == null ? null : discountingIndex;
            return this;
        }

        @Override
        public TradePricingReportBuilder setPricingTime(TimeZone pricingTime) {
            this.pricingTime = pricingTime == null ? null : pricingTime.toBuilder();
            return this;
        }

        @Override
        public TradePricingReportBuilder setTrade(Trade trade) {
            this.trade = trade == null ? null : trade.toBuilder();
            return this;
        }

        @Override
        public TradePricingReport build() {
            return new TradePricingReportImpl(this);
        }

        @Override
        public TradePricingReportBuilder toBuilder() {
            return this;
        }

        @Override
        public TradePricingReportBuilder prune() {
            if (this.pricingTime != null && !this.pricingTime.prune().hasData()) {
                this.pricingTime = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDiscountingIndex() != null) {
                return true;
            }
            if (this.getPricingTime() != null && this.getPricingTime().hasData()) {
                return true;
            }
            return this.getTrade() != null && this.getTrade().hasData();
        }

        public TradePricingReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradePricingReportBuilder o = (TradePricingReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingTime(), (RosettaModelObjectBuilder)o.getPricingTime(), this::setPricingTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeBasic((Object)this.getDiscountingIndex(), (Object)o.getDiscountingIndex(), this::setDiscountingIndex, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePricingReport _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.discountingIndex, (Object)_that.getDiscountingIndex())) {
                return false;
            }
            if (!Objects.equals(this.pricingTime, _that.getPricingTime())) {
                return false;
            }
            return Objects.equals(this.trade, _that.getTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountingIndex != null ? ((Object)((Object)this.discountingIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricingTime != null ? this.pricingTime.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePricingReportBuilder {discountingIndex=" + (Object)((Object)this.discountingIndex) + ", pricingTime=" + this.pricingTime + ", trade=" + this.trade + '}';
        }
    }

    public static class TradePricingReportImpl
    implements TradePricingReport {
        private final FloatingRateIndexEnum discountingIndex;
        private final TimeZone pricingTime;
        private final Trade trade;

        protected TradePricingReportImpl(TradePricingReportBuilder builder) {
            this.discountingIndex = builder.getDiscountingIndex();
            this.pricingTime = Optional.ofNullable(builder.getPricingTime()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
        }

        @Override
        public FloatingRateIndexEnum getDiscountingIndex() {
            return this.discountingIndex;
        }

        @Override
        public TimeZone getPricingTime() {
            return this.pricingTime;
        }

        @Override
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        public TradePricingReport build() {
            return this;
        }

        @Override
        public TradePricingReportBuilder toBuilder() {
            TradePricingReportBuilder builder = TradePricingReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradePricingReportBuilder builder) {
            Optional.ofNullable(this.getDiscountingIndex()).ifPresent(builder::setDiscountingIndex);
            Optional.ofNullable(this.getPricingTime()).ifPresent(builder::setPricingTime);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePricingReport _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.discountingIndex, (Object)_that.getDiscountingIndex())) {
                return false;
            }
            if (!Objects.equals(this.pricingTime, _that.getPricingTime())) {
                return false;
            }
            return Objects.equals(this.trade, _that.getTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountingIndex != null ? ((Object)((Object)this.discountingIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricingTime != null ? this.pricingTime.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePricingReport {discountingIndex=" + (Object)((Object)this.discountingIndex) + ", pricingTime=" + this.pricingTime + ", trade=" + this.trade + '}';
        }
    }

    public static interface TradePricingReportBuilder
    extends TradePricingReport,
    RosettaModelObjectBuilder {
        public TimeZone.TimeZoneBuilder getOrCreatePricingTime();

        @Override
        public TimeZone.TimeZoneBuilder getPricingTime();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public TradePricingReportBuilder setDiscountingIndex(FloatingRateIndexEnum var1);

        public TradePricingReportBuilder setPricingTime(TimeZone var1);

        public TradePricingReportBuilder setTrade(Trade var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("discountingIndex"), FloatingRateIndexEnum.class, (Object)this.getDiscountingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingTime"), processor, TimeZone.TimeZoneBuilder.class, this.getPricingTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
        }

        public TradePricingReportBuilder prune();
    }
}

