/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ContractDetails;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.TradeMeta;
import cdm.product.collateral.Collateral;
import cdm.product.template.TradableProduct;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Trade
extends RosettaModelObject,
GlobalKey {
    public static final TradeMeta metaData = new TradeMeta();

    public Trade build();

    public TradeBuilder toBuilder();

    public List<? extends Account> getAccount();

    public Date getClearedDate();

    public Collateral getCollateral();

    public ContractDetails getContractDetails();

    public ExecutionDetails getExecutionDetails();

    public MetaFields getMeta();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public TradableProduct getTradableProduct();

    public FieldWithMetaDate getTradeDate();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    default public RosettaMetaData<? extends Trade> metaData() {
        return metaData;
    }

    public static TradeBuilder builder() {
        return new TradeBuilderImpl();
    }

    default public Class<? extends Trade> getType() {
        return Trade.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("clearedDate"), Date.class, (Object)this.getClearedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("account"), processor, Account.class, this.getAccount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractDetails"), processor, ContractDetails.class, this.getContractDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradableProduct"), processor, TradableProduct.class, this.getTradableProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
    }

    public static class TradeBuilderImpl
    implements TradeBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<Account.AccountBuilder> account = new ArrayList<Account.AccountBuilder>();
        protected Date clearedDate;
        protected Collateral.CollateralBuilder collateral;
        protected ContractDetails.ContractDetailsBuilder contractDetails;
        protected ExecutionDetails.ExecutionDetailsBuilder executionDetails;
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected TradableProduct.TradableProductBuilder tradableProduct;
        protected FieldWithMetaDate.FieldWithMetaDateBuilder tradeDate;
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();

        @Override
        public List<? extends Account.AccountBuilder> getAccount() {
            return this.account;
        }

        @Override
        public Account.AccountBuilder getOrCreateAccount(int _index) {
            if (this.account == null) {
                this.account = new ArrayList<Account.AccountBuilder>();
            }
            return (Account.AccountBuilder)this.getIndex(this.account, _index, () -> {
                Account.AccountBuilder newAccount = Account.builder();
                return newAccount;
            });
        }

        @Override
        public Date getClearedDate() {
            return this.clearedDate;
        }

        @Override
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        public ContractDetails.ContractDetailsBuilder getContractDetails() {
            return this.contractDetails;
        }

        @Override
        public ContractDetails.ContractDetailsBuilder getOrCreateContractDetails() {
            ContractDetails.ContractDetailsBuilder result = this.contractDetails != null ? this.contractDetails : (this.contractDetails = ContractDetails.builder());
            return result;
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails() {
            ExecutionDetails.ExecutionDetailsBuilder result = this.executionDetails != null ? this.executionDetails : (this.executionDetails = ExecutionDetails.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int _index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        public TradableProduct.TradableProductBuilder getTradableProduct() {
            return this.tradableProduct;
        }

        @Override
        public TradableProduct.TradableProductBuilder getOrCreateTradableProduct() {
            TradableProduct.TradableProductBuilder result = this.tradableProduct != null ? this.tradableProduct : (this.tradableProduct = TradableProduct.builder());
            return result;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.tradeDate != null ? this.tradeDate : (this.tradeDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int _index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, _index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        public TradeBuilder addAccount(Account account) {
            if (account != null) {
                this.account.add(account.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addAccount(Account account, int _idx) {
            this.getIndex(this.account, _idx, () -> account.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addAccount(List<? extends Account> accounts) {
            if (accounts != null) {
                for (Account account : accounts) {
                    this.account.add(account.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradeBuilder setAccount(List<? extends Account> accounts) {
            this.account = accounts == null ? new ArrayList<Account.AccountBuilder>() : (List)accounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeBuilder setClearedDate(Date clearedDate) {
            this.clearedDate = clearedDate == null ? null : clearedDate;
            return this;
        }

        @Override
        public TradeBuilder setCollateral(Collateral collateral) {
            this.collateral = collateral == null ? null : collateral.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setContractDetails(ContractDetails contractDetails) {
            this.contractDetails = contractDetails == null ? null : contractDetails.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setExecutionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails == null ? null : executionDetails.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradeBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradeBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeBuilder setTradableProduct(TradableProduct tradableProduct) {
            this.tradableProduct = tradableProduct == null ? null : tradableProduct.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setTradeDate(FieldWithMetaDate tradeDate) {
            this.tradeDate = tradeDate == null ? null : tradeDate.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setTradeDateValue(Date tradeDate) {
            this.getOrCreateTradeDate().setValue(tradeDate);
            return this;
        }

        @Override
        public TradeBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier) {
            if (tradeIdentifier != null) {
                this.tradeIdentifier.add(tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier, int _idx) {
            this.getIndex(this.tradeIdentifier, _idx, () -> tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradeBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Trade build() {
            return new TradeImpl(this);
        }

        @Override
        public TradeBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeBuilder prune() {
            this.account = this.account.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.contractDetails != null && !this.contractDetails.prune().hasData()) {
                this.contractDetails = null;
            }
            if (this.executionDetails != null && !this.executionDetails.prune().hasData()) {
                this.executionDetails = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradableProduct != null && !this.tradableProduct.prune().hasData()) {
                this.tradableProduct = null;
            }
            if (this.tradeDate != null && !this.tradeDate.prune().hasData()) {
                this.tradeDate = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAccount() != null && this.getAccount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getClearedDate() != null) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getContractDetails() != null && this.getContractDetails().hasData()) {
                return true;
            }
            if (this.getExecutionDetails() != null && this.getExecutionDetails().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradableProduct() != null && this.getTradableProduct().hasData()) {
                return true;
            }
            if (this.getTradeDate() != null) {
                return true;
            }
            return this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeBuilder o = (TradeBuilder)other;
            merger.mergeRosetta(this.getAccount(), o.getAccount(), this::getOrCreateAccount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContractDetails(), (RosettaModelObjectBuilder)o.getContractDetails(), this::setContractDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDetails(), (RosettaModelObjectBuilder)o.getExecutionDetails(), this::setExecutionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradableProduct(), (RosettaModelObjectBuilder)o.getTradableProduct(), this::setTradableProduct);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeDate(), (RosettaModelObjectBuilder)o.getTradeDate(), this::setTradeDate);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeBasic((Object)this.getClearedDate(), (Object)o.getClearedDate(), this::setClearedDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals(this.clearedDate, _that.getClearedDate())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.tradableProduct, _that.getTradableProduct())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.tradableProduct != null ? this.tradableProduct.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeBuilder {account=" + this.account + ", clearedDate=" + this.clearedDate + ", collateral=" + this.collateral + ", contractDetails=" + this.contractDetails + ", executionDetails=" + this.executionDetails + ", meta=" + this.meta + ", party=" + this.party + ", partyRole=" + this.partyRole + ", tradableProduct=" + this.tradableProduct + ", tradeDate=" + this.tradeDate + ", tradeIdentifier=" + this.tradeIdentifier + '}';
        }
    }

    public static class TradeImpl
    implements Trade {
        private final List<? extends Account> account;
        private final Date clearedDate;
        private final Collateral collateral;
        private final ContractDetails contractDetails;
        private final ExecutionDetails executionDetails;
        private final MetaFields meta;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final TradableProduct tradableProduct;
        private final FieldWithMetaDate tradeDate;
        private final List<? extends TradeIdentifier> tradeIdentifier;

        protected TradeImpl(TradeBuilder builder) {
            this.account = Optional.ofNullable(builder.getAccount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.clearedDate = builder.getClearedDate();
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.contractDetails = Optional.ofNullable(builder.getContractDetails()).map(f -> f.build()).orElse(null);
            this.executionDetails = Optional.ofNullable(builder.getExecutionDetails()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradableProduct = Optional.ofNullable(builder.getTradableProduct()).map(f -> f.build()).orElse(null);
            this.tradeDate = Optional.ofNullable(builder.getTradeDate()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends Account> getAccount() {
            return this.account;
        }

        @Override
        public Date getClearedDate() {
            return this.clearedDate;
        }

        @Override
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        public ContractDetails getContractDetails() {
            return this.contractDetails;
        }

        @Override
        public ExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public TradableProduct getTradableProduct() {
            return this.tradableProduct;
        }

        @Override
        public FieldWithMetaDate getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public Trade build() {
            return this;
        }

        @Override
        public TradeBuilder toBuilder() {
            TradeBuilder builder = Trade.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeBuilder builder) {
            Optional.ofNullable(this.getAccount()).ifPresent(builder::setAccount);
            Optional.ofNullable(this.getClearedDate()).ifPresent(builder::setClearedDate);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getContractDetails()).ifPresent(builder::setContractDetails);
            Optional.ofNullable(this.getExecutionDetails()).ifPresent(builder::setExecutionDetails);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getTradableProduct()).ifPresent(builder::setTradableProduct);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals(this.clearedDate, _that.getClearedDate())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.tradableProduct, _that.getTradableProduct())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.tradableProduct != null ? this.tradableProduct.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trade {account=" + this.account + ", clearedDate=" + this.clearedDate + ", collateral=" + this.collateral + ", contractDetails=" + this.contractDetails + ", executionDetails=" + this.executionDetails + ", meta=" + this.meta + ", party=" + this.party + ", partyRole=" + this.partyRole + ", tradableProduct=" + this.tradableProduct + ", tradeDate=" + this.tradeDate + ", tradeIdentifier=" + this.tradeIdentifier + '}';
        }
    }

    public static interface TradeBuilder
    extends Trade,
    RosettaModelObjectBuilder {
        public Account.AccountBuilder getOrCreateAccount(int var1);

        public List<? extends Account.AccountBuilder> getAccount();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public ContractDetails.ContractDetailsBuilder getOrCreateContractDetails();

        @Override
        public ContractDetails.ContractDetailsBuilder getContractDetails();

        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails();

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public TradableProduct.TradableProductBuilder getOrCreateTradableProduct();

        @Override
        public TradableProduct.TradableProductBuilder getTradableProduct();

        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public TradeBuilder addAccount(Account var1);

        public TradeBuilder addAccount(Account var1, int var2);

        public TradeBuilder addAccount(List<? extends Account> var1);

        public TradeBuilder setAccount(List<? extends Account> var1);

        public TradeBuilder setClearedDate(Date var1);

        public TradeBuilder setCollateral(Collateral var1);

        public TradeBuilder setContractDetails(ContractDetails var1);

        public TradeBuilder setExecutionDetails(ExecutionDetails var1);

        public TradeBuilder setMeta(MetaFields var1);

        public TradeBuilder addParty(Party var1);

        public TradeBuilder addParty(Party var1, int var2);

        public TradeBuilder addParty(List<? extends Party> var1);

        public TradeBuilder setParty(List<? extends Party> var1);

        public TradeBuilder addPartyRole(PartyRole var1);

        public TradeBuilder addPartyRole(PartyRole var1, int var2);

        public TradeBuilder addPartyRole(List<? extends PartyRole> var1);

        public TradeBuilder setPartyRole(List<? extends PartyRole> var1);

        public TradeBuilder setTradableProduct(TradableProduct var1);

        public TradeBuilder setTradeDate(FieldWithMetaDate var1);

        public TradeBuilder setTradeDateValue(Date var1);

        public TradeBuilder addTradeIdentifier(TradeIdentifier var1);

        public TradeBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public TradeBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public TradeBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("clearedDate"), Date.class, (Object)this.getClearedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("account"), processor, Account.AccountBuilder.class, this.getAccount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractDetails"), processor, ContractDetails.ContractDetailsBuilder.class, this.getContractDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.ExecutionDetailsBuilder.class, this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradableProduct"), processor, TradableProduct.TradableProductBuilder.class, this.getTradableProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        }

        public TradeBuilder prune();
    }
}

