/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.Party;
import cdm.event.common.BillingRecord;
import cdm.event.common.BillingSummary;
import cdm.event.common.meta.SecurityLendingInvoiceMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface SecurityLendingInvoice
extends RosettaModelObject,
GlobalKey {
    public static final SecurityLendingInvoiceMeta metaData = new SecurityLendingInvoiceMeta();

    public SecurityLendingInvoice build();

    public SecurityLendingInvoiceBuilder toBuilder();

    public Date getBillingEndDate();

    public List<? extends BillingRecord> getBillingRecord();

    public Date getBillingStartDate();

    public List<? extends BillingSummary> getBillingSummary();

    public MetaFields getMeta();

    public Party getReceivingParty();

    public Party getSendingParty();

    default public RosettaMetaData<? extends SecurityLendingInvoice> metaData() {
        return metaData;
    }

    public static SecurityLendingInvoiceBuilder builder() {
        return new SecurityLendingInvoiceBuilderImpl();
    }

    default public Class<? extends SecurityLendingInvoice> getType() {
        return SecurityLendingInvoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingRecord"), processor, BillingRecord.class, this.getBillingRecord(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummary.class, this.getBillingSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("receivingParty"), processor, Party.class, this.getReceivingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sendingParty"), processor, Party.class, this.getSendingParty(), new AttributeMeta[0]);
    }

    public static class SecurityLendingInvoiceBuilderImpl
    implements SecurityLendingInvoiceBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date billingEndDate;
        protected List<BillingRecord.BillingRecordBuilder> billingRecord = new ArrayList<BillingRecord.BillingRecordBuilder>();
        protected Date billingStartDate;
        protected List<BillingSummary.BillingSummaryBuilder> billingSummary = new ArrayList<BillingSummary.BillingSummaryBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;
        protected Party.PartyBuilder receivingParty;
        protected Party.PartyBuilder sendingParty;

        @Override
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        public List<? extends BillingRecord.BillingRecordBuilder> getBillingRecord() {
            return this.billingRecord;
        }

        @Override
        public BillingRecord.BillingRecordBuilder getOrCreateBillingRecord(int _index) {
            if (this.billingRecord == null) {
                this.billingRecord = new ArrayList<BillingRecord.BillingRecordBuilder>();
            }
            return (BillingRecord.BillingRecordBuilder)this.getIndex(this.billingRecord, _index, () -> {
                BillingRecord.BillingRecordBuilder newBillingRecord = BillingRecord.builder();
                return newBillingRecord;
            });
        }

        @Override
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        public List<? extends BillingSummary.BillingSummaryBuilder> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        public BillingSummary.BillingSummaryBuilder getOrCreateBillingSummary(int _index) {
            if (this.billingSummary == null) {
                this.billingSummary = new ArrayList<BillingSummary.BillingSummaryBuilder>();
            }
            return (BillingSummary.BillingSummaryBuilder)this.getIndex(this.billingSummary, _index, () -> {
                BillingSummary.BillingSummaryBuilder newBillingSummary = BillingSummary.builder();
                return newBillingSummary;
            });
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Party.PartyBuilder getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateReceivingParty() {
            Party.PartyBuilder result = this.receivingParty != null ? this.receivingParty : (this.receivingParty = Party.builder());
            return result;
        }

        @Override
        public Party.PartyBuilder getSendingParty() {
            return this.sendingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateSendingParty() {
            Party.PartyBuilder result = this.sendingParty != null ? this.sendingParty : (this.sendingParty = Party.builder());
            return result;
        }

        @Override
        public SecurityLendingInvoiceBuilder setBillingEndDate(Date billingEndDate) {
            this.billingEndDate = billingEndDate == null ? null : billingEndDate;
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord billingRecord) {
            if (billingRecord != null) {
                this.billingRecord.add(billingRecord.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord billingRecord, int _idx) {
            this.getIndex(this.billingRecord, _idx, () -> billingRecord.toBuilder());
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(List<? extends BillingRecord> billingRecords) {
            if (billingRecords != null) {
                for (BillingRecord billingRecord : billingRecords) {
                    this.billingRecord.add(billingRecord.toBuilder());
                }
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setBillingRecord(List<? extends BillingRecord> billingRecords) {
            this.billingRecord = billingRecords == null ? new ArrayList<BillingRecord.BillingRecordBuilder>() : (List)billingRecords.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setBillingStartDate(Date billingStartDate) {
            this.billingStartDate = billingStartDate == null ? null : billingStartDate;
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary billingSummary) {
            if (billingSummary != null) {
                this.billingSummary.add(billingSummary.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary billingSummary, int _idx) {
            this.getIndex(this.billingSummary, _idx, () -> billingSummary.toBuilder());
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(List<? extends BillingSummary> billingSummarys) {
            if (billingSummarys != null) {
                for (BillingSummary billingSummary : billingSummarys) {
                    this.billingSummary.add(billingSummary.toBuilder());
                }
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setBillingSummary(List<? extends BillingSummary> billingSummarys) {
            this.billingSummary = billingSummarys == null ? new ArrayList<BillingSummary.BillingSummaryBuilder>() : (List)billingSummarys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setReceivingParty(Party receivingParty) {
            this.receivingParty = receivingParty == null ? null : receivingParty.toBuilder();
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder setSendingParty(Party sendingParty) {
            this.sendingParty = sendingParty == null ? null : sendingParty.toBuilder();
            return this;
        }

        @Override
        public SecurityLendingInvoice build() {
            return new SecurityLendingInvoiceImpl(this);
        }

        @Override
        public SecurityLendingInvoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder prune() {
            this.billingRecord = this.billingRecord.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.billingSummary = this.billingSummary.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.receivingParty != null && !this.receivingParty.prune().hasData()) {
                this.receivingParty = null;
            }
            if (this.sendingParty != null && !this.sendingParty.prune().hasData()) {
                this.sendingParty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBillingEndDate() != null) {
                return true;
            }
            if (this.getBillingRecord() != null && this.getBillingRecord().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBillingStartDate() != null) {
                return true;
            }
            if (this.getBillingSummary() != null && this.getBillingSummary().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReceivingParty() != null && this.getReceivingParty().hasData()) {
                return true;
            }
            return this.getSendingParty() != null && this.getSendingParty().hasData();
        }

        public SecurityLendingInvoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SecurityLendingInvoiceBuilder o = (SecurityLendingInvoiceBuilder)other;
            merger.mergeRosetta(this.getBillingRecord(), o.getBillingRecord(), this::getOrCreateBillingRecord);
            merger.mergeRosetta(this.getBillingSummary(), o.getBillingSummary(), this::getOrCreateBillingSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReceivingParty(), (RosettaModelObjectBuilder)o.getReceivingParty(), this::setReceivingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSendingParty(), (RosettaModelObjectBuilder)o.getSendingParty(), this::setSendingParty);
            merger.mergeBasic((Object)this.getBillingEndDate(), (Object)o.getBillingEndDate(), this::setBillingEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBillingStartDate(), (Object)o.getBillingStartDate(), this::setBillingStartDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingInvoice _that = this.getType().cast(o);
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecord, _that.getBillingRecord())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingSummary, _that.getBillingSummary())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            return Objects.equals(this.sendingParty, _that.getSendingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecord != null ? this.billingRecord.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingInvoiceBuilder {billingEndDate=" + this.billingEndDate + ", billingRecord=" + this.billingRecord + ", billingStartDate=" + this.billingStartDate + ", billingSummary=" + this.billingSummary + ", meta=" + this.meta + ", receivingParty=" + this.receivingParty + ", sendingParty=" + this.sendingParty + '}';
        }
    }

    public static class SecurityLendingInvoiceImpl
    implements SecurityLendingInvoice {
        private final Date billingEndDate;
        private final List<? extends BillingRecord> billingRecord;
        private final Date billingStartDate;
        private final List<? extends BillingSummary> billingSummary;
        private final MetaFields meta;
        private final Party receivingParty;
        private final Party sendingParty;

        protected SecurityLendingInvoiceImpl(SecurityLendingInvoiceBuilder builder) {
            this.billingEndDate = builder.getBillingEndDate();
            this.billingRecord = Optional.ofNullable(builder.getBillingRecord()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.billingStartDate = builder.getBillingStartDate();
            this.billingSummary = Optional.ofNullable(builder.getBillingSummary()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.receivingParty = Optional.ofNullable(builder.getReceivingParty()).map(f -> f.build()).orElse(null);
            this.sendingParty = Optional.ofNullable(builder.getSendingParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        public List<? extends BillingRecord> getBillingRecord() {
            return this.billingRecord;
        }

        @Override
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        public List<? extends BillingSummary> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Party getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        public Party getSendingParty() {
            return this.sendingParty;
        }

        @Override
        public SecurityLendingInvoice build() {
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder toBuilder() {
            SecurityLendingInvoiceBuilder builder = SecurityLendingInvoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityLendingInvoiceBuilder builder) {
            Optional.ofNullable(this.getBillingEndDate()).ifPresent(builder::setBillingEndDate);
            Optional.ofNullable(this.getBillingRecord()).ifPresent(builder::setBillingRecord);
            Optional.ofNullable(this.getBillingStartDate()).ifPresent(builder::setBillingStartDate);
            Optional.ofNullable(this.getBillingSummary()).ifPresent(builder::setBillingSummary);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getReceivingParty()).ifPresent(builder::setReceivingParty);
            Optional.ofNullable(this.getSendingParty()).ifPresent(builder::setSendingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingInvoice _that = this.getType().cast(o);
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecord, _that.getBillingRecord())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingSummary, _that.getBillingSummary())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            return Objects.equals(this.sendingParty, _that.getSendingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecord != null ? this.billingRecord.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingInvoice {billingEndDate=" + this.billingEndDate + ", billingRecord=" + this.billingRecord + ", billingStartDate=" + this.billingStartDate + ", billingSummary=" + this.billingSummary + ", meta=" + this.meta + ", receivingParty=" + this.receivingParty + ", sendingParty=" + this.sendingParty + '}';
        }
    }

    public static interface SecurityLendingInvoiceBuilder
    extends SecurityLendingInvoice,
    RosettaModelObjectBuilder {
        public BillingRecord.BillingRecordBuilder getOrCreateBillingRecord(int var1);

        public List<? extends BillingRecord.BillingRecordBuilder> getBillingRecord();

        public BillingSummary.BillingSummaryBuilder getOrCreateBillingSummary(int var1);

        public List<? extends BillingSummary.BillingSummaryBuilder> getBillingSummary();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Party.PartyBuilder getOrCreateReceivingParty();

        @Override
        public Party.PartyBuilder getReceivingParty();

        public Party.PartyBuilder getOrCreateSendingParty();

        @Override
        public Party.PartyBuilder getSendingParty();

        public SecurityLendingInvoiceBuilder setBillingEndDate(Date var1);

        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord var1);

        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord var1, int var2);

        public SecurityLendingInvoiceBuilder addBillingRecord(List<? extends BillingRecord> var1);

        public SecurityLendingInvoiceBuilder setBillingRecord(List<? extends BillingRecord> var1);

        public SecurityLendingInvoiceBuilder setBillingStartDate(Date var1);

        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary var1);

        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary var1, int var2);

        public SecurityLendingInvoiceBuilder addBillingSummary(List<? extends BillingSummary> var1);

        public SecurityLendingInvoiceBuilder setBillingSummary(List<? extends BillingSummary> var1);

        public SecurityLendingInvoiceBuilder setMeta(MetaFields var1);

        public SecurityLendingInvoiceBuilder setReceivingParty(Party var1);

        public SecurityLendingInvoiceBuilder setSendingParty(Party var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingRecord"), processor, BillingRecord.BillingRecordBuilder.class, this.getBillingRecord(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummary.BillingSummaryBuilder.class, this.getBillingSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("receivingParty"), processor, Party.PartyBuilder.class, this.getReceivingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sendingParty"), processor, Party.PartyBuilder.class, this.getSendingParty(), new AttributeMeta[0]);
        }

        public SecurityLendingInvoiceBuilder prune();
    }
}

