/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ResetInstructionMeta;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ResetInstruction
extends RosettaModelObject {
    public static final ResetInstructionMeta metaData = new ResetInstructionMeta();

    public ResetInstruction build();

    public ResetInstructionBuilder toBuilder();

    public ReferenceWithMetaPayout getPayout();

    public Date getRateRecordDate();

    public Date getResetDate();

    default public RosettaMetaData<? extends ResetInstruction> metaData() {
        return metaData;
    }

    public static ResetInstructionBuilder builder() {
        return new ResetInstructionBuilderImpl();
    }

    default public Class<? extends ResetInstruction> getType() {
        return ResetInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.class, this.getPayout(), new AttributeMeta[0]);
    }

    public static class ResetInstructionBuilderImpl
    implements ResetInstructionBuilder {
        protected ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder payout;
        protected Date rateRecordDate;
        protected Date resetDate;

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout() {
            return this.payout;
        }

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout() {
            ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder result = this.payout != null ? this.payout : (this.payout = ReferenceWithMetaPayout.builder());
            return result;
        }

        @Override
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public ResetInstructionBuilder setPayout(ReferenceWithMetaPayout payout) {
            this.payout = payout == null ? null : payout.toBuilder();
            return this;
        }

        @Override
        public ResetInstructionBuilder setPayoutValue(Payout payout) {
            this.getOrCreatePayout().setValue(payout);
            return this;
        }

        @Override
        public ResetInstructionBuilder setRateRecordDate(Date rateRecordDate) {
            this.rateRecordDate = rateRecordDate == null ? null : rateRecordDate;
            return this;
        }

        @Override
        public ResetInstructionBuilder setResetDate(Date resetDate) {
            this.resetDate = resetDate == null ? null : resetDate;
            return this;
        }

        @Override
        public ResetInstruction build() {
            return new ResetInstructionImpl(this);
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetInstructionBuilder prune() {
            if (this.payout != null && !this.payout.prune().hasData()) {
                this.payout = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPayout() != null && this.getPayout().hasData()) {
                return true;
            }
            if (this.getRateRecordDate() != null) {
                return true;
            }
            return this.getResetDate() != null;
        }

        public ResetInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ResetInstructionBuilder o = (ResetInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayout(), (RosettaModelObjectBuilder)o.getPayout(), this::setPayout);
            merger.mergeBasic((Object)this.getRateRecordDate(), (Object)o.getRateRecordDate(), this::setRateRecordDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstructionBuilder {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }

    public static class ResetInstructionImpl
    implements ResetInstruction {
        private final ReferenceWithMetaPayout payout;
        private final Date rateRecordDate;
        private final Date resetDate;

        protected ResetInstructionImpl(ResetInstructionBuilder builder) {
            this.payout = Optional.ofNullable(builder.getPayout()).map(f -> f.build()).orElse(null);
            this.rateRecordDate = builder.getRateRecordDate();
            this.resetDate = builder.getResetDate();
        }

        @Override
        public ReferenceWithMetaPayout getPayout() {
            return this.payout;
        }

        @Override
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public ResetInstruction build() {
            return this;
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            ResetInstructionBuilder builder = ResetInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetInstructionBuilder builder) {
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getRateRecordDate()).ifPresent(builder::setRateRecordDate);
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstruction {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }

    public static interface ResetInstructionBuilder
    extends ResetInstruction,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout();

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout();

        public ResetInstructionBuilder setPayout(ReferenceWithMetaPayout var1);

        public ResetInstructionBuilder setPayoutValue(Payout var1);

        public ResetInstructionBuilder setRateRecordDate(Date var1);

        public ResetInstructionBuilder setResetDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
        }

        public ResetInstructionBuilder prune();
    }
}

