/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.meta.QuantityChangeInstructionMeta;
import cdm.product.common.settlement.PriceQuantity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface QuantityChangeInstruction
extends RosettaModelObject {
    public static final QuantityChangeInstructionMeta metaData = new QuantityChangeInstructionMeta();

    public QuantityChangeInstruction build();

    public QuantityChangeInstructionBuilder toBuilder();

    public List<? extends PriceQuantity> getChange();

    public QuantityChangeDirectionEnum getDirection();

    public List<? extends Identifier> getLotIdentifier();

    default public RosettaMetaData<? extends QuantityChangeInstruction> metaData() {
        return metaData;
    }

    public static QuantityChangeInstructionBuilder builder() {
        return new QuantityChangeInstructionBuilderImpl();
    }

    default public Class<? extends QuantityChangeInstruction> getType() {
        return QuantityChangeInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("direction"), QuantityChangeDirectionEnum.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("change"), processor, PriceQuantity.class, this.getChange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.class, this.getLotIdentifier(), new AttributeMeta[0]);
    }

    public static class QuantityChangeInstructionBuilderImpl
    implements QuantityChangeInstructionBuilder {
        protected List<PriceQuantity.PriceQuantityBuilder> change = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected QuantityChangeDirectionEnum direction;
        protected List<Identifier.IdentifierBuilder> lotIdentifier = new ArrayList<Identifier.IdentifierBuilder>();

        @Override
        public List<? extends PriceQuantity.PriceQuantityBuilder> getChange() {
            return this.change;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreateChange(int _index) {
            if (this.change == null) {
                this.change = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.change, _index, () -> {
                PriceQuantity.PriceQuantityBuilder newChange = PriceQuantity.builder();
                return newChange;
            });
        }

        @Override
        public QuantityChangeDirectionEnum getDirection() {
            return this.direction;
        }

        @Override
        public List<? extends Identifier.IdentifierBuilder> getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateLotIdentifier(int _index) {
            if (this.lotIdentifier == null) {
                this.lotIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.lotIdentifier, _index, () -> {
                Identifier.IdentifierBuilder newLotIdentifier = Identifier.builder();
                return newLotIdentifier;
            });
        }

        @Override
        public QuantityChangeInstructionBuilder addChange(PriceQuantity change) {
            if (change != null) {
                this.change.add(change.toBuilder());
            }
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder addChange(PriceQuantity change, int _idx) {
            this.getIndex(this.change, _idx, () -> change.toBuilder());
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder addChange(List<? extends PriceQuantity> changes) {
            if (changes != null) {
                for (PriceQuantity priceQuantity : changes) {
                    this.change.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder setChange(List<? extends PriceQuantity> changes) {
            this.change = changes == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)changes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder setDirection(QuantityChangeDirectionEnum direction) {
            this.direction = direction == null ? null : direction;
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder addLotIdentifier(Identifier lotIdentifier) {
            if (lotIdentifier != null) {
                this.lotIdentifier.add(lotIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder addLotIdentifier(Identifier lotIdentifier, int _idx) {
            this.getIndex(this.lotIdentifier, _idx, () -> lotIdentifier.toBuilder());
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder addLotIdentifier(List<? extends Identifier> lotIdentifiers) {
            if (lotIdentifiers != null) {
                for (Identifier identifier : lotIdentifiers) {
                    this.lotIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder setLotIdentifier(List<? extends Identifier> lotIdentifiers) {
            this.lotIdentifier = lotIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)lotIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuantityChangeInstruction build() {
            return new QuantityChangeInstructionImpl(this);
        }

        @Override
        public QuantityChangeInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder prune() {
            this.change = this.change.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.lotIdentifier = this.lotIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getChange() != null && this.getChange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDirection() != null) {
                return true;
            }
            return this.getLotIdentifier() != null && this.getLotIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public QuantityChangeInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuantityChangeInstructionBuilder o = (QuantityChangeInstructionBuilder)other;
            merger.mergeRosetta(this.getChange(), o.getChange(), this::getOrCreateChange);
            merger.mergeRosetta(this.getLotIdentifier(), o.getLotIdentifier(), this::getOrCreateLotIdentifier);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuantityChangeInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            return ListEquals.listEquals(this.lotIdentifier, _that.getLotIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantityChangeInstructionBuilder {change=" + this.change + ", direction=" + (Object)((Object)this.direction) + ", lotIdentifier=" + this.lotIdentifier + '}';
        }
    }

    public static class QuantityChangeInstructionImpl
    implements QuantityChangeInstruction {
        private final List<? extends PriceQuantity> change;
        private final QuantityChangeDirectionEnum direction;
        private final List<? extends Identifier> lotIdentifier;

        protected QuantityChangeInstructionImpl(QuantityChangeInstructionBuilder builder) {
            this.change = Optional.ofNullable(builder.getChange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.direction = builder.getDirection();
            this.lotIdentifier = Optional.ofNullable(builder.getLotIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends PriceQuantity> getChange() {
            return this.change;
        }

        @Override
        public QuantityChangeDirectionEnum getDirection() {
            return this.direction;
        }

        @Override
        public List<? extends Identifier> getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        public QuantityChangeInstruction build() {
            return this;
        }

        @Override
        public QuantityChangeInstructionBuilder toBuilder() {
            QuantityChangeInstructionBuilder builder = QuantityChangeInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantityChangeInstructionBuilder builder) {
            Optional.ofNullable(this.getChange()).ifPresent(builder::setChange);
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getLotIdentifier()).ifPresent(builder::setLotIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuantityChangeInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            return ListEquals.listEquals(this.lotIdentifier, _that.getLotIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantityChangeInstruction {change=" + this.change + ", direction=" + (Object)((Object)this.direction) + ", lotIdentifier=" + this.lotIdentifier + '}';
        }
    }

    public static interface QuantityChangeInstructionBuilder
    extends QuantityChangeInstruction,
    RosettaModelObjectBuilder {
        public PriceQuantity.PriceQuantityBuilder getOrCreateChange(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getChange();

        public Identifier.IdentifierBuilder getOrCreateLotIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getLotIdentifier();

        public QuantityChangeInstructionBuilder addChange(PriceQuantity var1);

        public QuantityChangeInstructionBuilder addChange(PriceQuantity var1, int var2);

        public QuantityChangeInstructionBuilder addChange(List<? extends PriceQuantity> var1);

        public QuantityChangeInstructionBuilder setChange(List<? extends PriceQuantity> var1);

        public QuantityChangeInstructionBuilder setDirection(QuantityChangeDirectionEnum var1);

        public QuantityChangeInstructionBuilder addLotIdentifier(Identifier var1);

        public QuantityChangeInstructionBuilder addLotIdentifier(Identifier var1, int var2);

        public QuantityChangeInstructionBuilder addLotIdentifier(List<? extends Identifier> var1);

        public QuantityChangeInstructionBuilder setLotIdentifier(List<? extends Identifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("direction"), QuantityChangeDirectionEnum.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("change"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getChange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getLotIdentifier(), new AttributeMeta[0]);
        }

        public QuantityChangeInstructionBuilder prune();
    }
}

