/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.CorporateAction;
import cdm.event.common.CreditEvent;
import cdm.event.common.meta.ObservationEventMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ObservationEvent
extends RosettaModelObject {
    public static final ObservationEventMeta metaData = new ObservationEventMeta();

    public ObservationEvent build();

    public ObservationEventBuilder toBuilder();

    public CorporateAction getCorporateAction();

    public CreditEvent getCreditEvent();

    default public RosettaMetaData<? extends ObservationEvent> metaData() {
        return metaData;
    }

    public static ObservationEventBuilder builder() {
        return new ObservationEventBuilderImpl();
    }

    default public Class<? extends ObservationEvent> getType() {
        return ObservationEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("corporateAction"), processor, CorporateAction.class, this.getCorporateAction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEvent"), processor, CreditEvent.class, this.getCreditEvent(), new AttributeMeta[0]);
    }

    public static class ObservationEventBuilderImpl
    implements ObservationEventBuilder {
        protected CorporateAction.CorporateActionBuilder corporateAction;
        protected CreditEvent.CreditEventBuilder creditEvent;

        @Override
        public CorporateAction.CorporateActionBuilder getCorporateAction() {
            return this.corporateAction;
        }

        @Override
        public CorporateAction.CorporateActionBuilder getOrCreateCorporateAction() {
            CorporateAction.CorporateActionBuilder result = this.corporateAction != null ? this.corporateAction : (this.corporateAction = CorporateAction.builder());
            return result;
        }

        @Override
        public CreditEvent.CreditEventBuilder getCreditEvent() {
            return this.creditEvent;
        }

        @Override
        public CreditEvent.CreditEventBuilder getOrCreateCreditEvent() {
            CreditEvent.CreditEventBuilder result = this.creditEvent != null ? this.creditEvent : (this.creditEvent = CreditEvent.builder());
            return result;
        }

        @Override
        public ObservationEventBuilder setCorporateAction(CorporateAction corporateAction) {
            this.corporateAction = corporateAction == null ? null : corporateAction.toBuilder();
            return this;
        }

        @Override
        public ObservationEventBuilder setCreditEvent(CreditEvent creditEvent) {
            this.creditEvent = creditEvent == null ? null : creditEvent.toBuilder();
            return this;
        }

        @Override
        public ObservationEvent build() {
            return new ObservationEventImpl(this);
        }

        @Override
        public ObservationEventBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationEventBuilder prune() {
            if (this.corporateAction != null && !this.corporateAction.prune().hasData()) {
                this.corporateAction = null;
            }
            if (this.creditEvent != null && !this.creditEvent.prune().hasData()) {
                this.creditEvent = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCorporateAction() != null && this.getCorporateAction().hasData()) {
                return true;
            }
            return this.getCreditEvent() != null && this.getCreditEvent().hasData();
        }

        public ObservationEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationEventBuilder o = (ObservationEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorporateAction(), (RosettaModelObjectBuilder)o.getCorporateAction(), this::setCorporateAction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEvent(), (RosettaModelObjectBuilder)o.getCreditEvent(), this::setCreditEvent);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.corporateAction, _that.getCorporateAction())) {
                return false;
            }
            return Objects.equals(this.creditEvent, _that.getCreditEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateAction != null ? this.corporateAction.hashCode() : 0);
            _result = 31 * _result + (this.creditEvent != null ? this.creditEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationEventBuilder {corporateAction=" + this.corporateAction + ", creditEvent=" + this.creditEvent + '}';
        }
    }

    public static class ObservationEventImpl
    implements ObservationEvent {
        private final CorporateAction corporateAction;
        private final CreditEvent creditEvent;

        protected ObservationEventImpl(ObservationEventBuilder builder) {
            this.corporateAction = Optional.ofNullable(builder.getCorporateAction()).map(f -> f.build()).orElse(null);
            this.creditEvent = Optional.ofNullable(builder.getCreditEvent()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CorporateAction getCorporateAction() {
            return this.corporateAction;
        }

        @Override
        public CreditEvent getCreditEvent() {
            return this.creditEvent;
        }

        @Override
        public ObservationEvent build() {
            return this;
        }

        @Override
        public ObservationEventBuilder toBuilder() {
            ObservationEventBuilder builder = ObservationEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationEventBuilder builder) {
            Optional.ofNullable(this.getCorporateAction()).ifPresent(builder::setCorporateAction);
            Optional.ofNullable(this.getCreditEvent()).ifPresent(builder::setCreditEvent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.corporateAction, _that.getCorporateAction())) {
                return false;
            }
            return Objects.equals(this.creditEvent, _that.getCreditEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateAction != null ? this.corporateAction.hashCode() : 0);
            _result = 31 * _result + (this.creditEvent != null ? this.creditEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationEvent {corporateAction=" + this.corporateAction + ", creditEvent=" + this.creditEvent + '}';
        }
    }

    public static interface ObservationEventBuilder
    extends ObservationEvent,
    RosettaModelObjectBuilder {
        public CorporateAction.CorporateActionBuilder getOrCreateCorporateAction();

        @Override
        public CorporateAction.CorporateActionBuilder getCorporateAction();

        public CreditEvent.CreditEventBuilder getOrCreateCreditEvent();

        @Override
        public CreditEvent.CreditEventBuilder getCreditEvent();

        public ObservationEventBuilder setCorporateAction(CorporateAction var1);

        public ObservationEventBuilder setCreditEvent(CreditEvent var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("corporateAction"), processor, CorporateAction.CorporateActionBuilder.class, this.getCorporateAction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEvent"), processor, CreditEvent.CreditEventBuilder.class, this.getCreditEvent(), new AttributeMeta[0]);
        }

        public ObservationEventBuilder prune();
    }
}

