/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.MarginCallBase;
import cdm.event.common.MarginCallExposure;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.MarginCallResponseAction;
import cdm.event.common.MarginCallResponseTypeEnum;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallResponseMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MarginCallResponse
extends MarginCallBase {
    public static final MarginCallResponseMeta metaData = new MarginCallResponseMeta();

    @Override
    public MarginCallResponse build();

    @Override
    public MarginCallResponseBuilder toBuilder();

    public Money getAgreedAmountBaseCurrency();

    public List<? extends MarginCallResponseAction> getMarginCallResponseAction();

    public MarginCallResponseTypeEnum getMarginResponseType();

    default public RosettaMetaData<? extends MarginCallResponse> metaData() {
        return metaData;
    }

    public static MarginCallResponseBuilder builder() {
        return new MarginCallResponseBuilderImpl();
    }

    default public Class<? extends MarginCallResponse> getType() {
        return MarginCallResponse.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MarginCallBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("marginResponseType"), MarginCallResponseTypeEnum.class, (Object)this.getMarginResponseType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreedAmountBaseCurrency"), processor, Money.class, this.getAgreedAmountBaseCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marginCallResponseAction"), processor, MarginCallResponseAction.class, this.getMarginCallResponseAction(), new AttributeMeta[0]);
    }

    public static class MarginCallResponseBuilderImpl
    extends MarginCallBase.MarginCallBaseBuilderImpl
    implements MarginCallResponseBuilder {
        protected Money.MoneyBuilder agreedAmountBaseCurrency;
        protected List<MarginCallResponseAction.MarginCallResponseActionBuilder> marginCallResponseAction = new ArrayList<MarginCallResponseAction.MarginCallResponseActionBuilder>();
        protected MarginCallResponseTypeEnum marginResponseType;

        @Override
        public Money.MoneyBuilder getAgreedAmountBaseCurrency() {
            return this.agreedAmountBaseCurrency;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreedAmountBaseCurrency() {
            Money.MoneyBuilder result = this.agreedAmountBaseCurrency != null ? this.agreedAmountBaseCurrency : (this.agreedAmountBaseCurrency = Money.builder());
            return result;
        }

        @Override
        public List<? extends MarginCallResponseAction.MarginCallResponseActionBuilder> getMarginCallResponseAction() {
            return this.marginCallResponseAction;
        }

        @Override
        public MarginCallResponseAction.MarginCallResponseActionBuilder getOrCreateMarginCallResponseAction(int _index) {
            if (this.marginCallResponseAction == null) {
                this.marginCallResponseAction = new ArrayList<MarginCallResponseAction.MarginCallResponseActionBuilder>();
            }
            return (MarginCallResponseAction.MarginCallResponseActionBuilder)this.getIndex(this.marginCallResponseAction, _index, () -> {
                MarginCallResponseAction.MarginCallResponseActionBuilder newMarginCallResponseAction = MarginCallResponseAction.builder();
                return newMarginCallResponseAction;
            });
        }

        @Override
        public MarginCallResponseTypeEnum getMarginResponseType() {
            return this.marginResponseType;
        }

        @Override
        public MarginCallResponseBuilder setAgreedAmountBaseCurrency(Money agreedAmountBaseCurrency) {
            this.agreedAmountBaseCurrency = agreedAmountBaseCurrency == null ? null : agreedAmountBaseCurrency.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder addMarginCallResponseAction(MarginCallResponseAction marginCallResponseAction) {
            if (marginCallResponseAction != null) {
                this.marginCallResponseAction.add(marginCallResponseAction.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder addMarginCallResponseAction(MarginCallResponseAction marginCallResponseAction, int _idx) {
            this.getIndex(this.marginCallResponseAction, _idx, () -> marginCallResponseAction.toBuilder());
            return this;
        }

        @Override
        public MarginCallResponseBuilder addMarginCallResponseAction(List<? extends MarginCallResponseAction> marginCallResponseActions) {
            if (marginCallResponseActions != null) {
                for (MarginCallResponseAction marginCallResponseAction : marginCallResponseActions) {
                    this.marginCallResponseAction.add(marginCallResponseAction.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder setMarginCallResponseAction(List<? extends MarginCallResponseAction> marginCallResponseActions) {
            this.marginCallResponseAction = marginCallResponseActions == null ? new ArrayList<MarginCallResponseAction.MarginCallResponseActionBuilder>() : (List)marginCallResponseActions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallResponseBuilder setMarginResponseType(MarginCallResponseTypeEnum marginResponseType) {
            this.marginResponseType = marginResponseType == null ? null : marginResponseType;
            return this;
        }

        @Override
        public MarginCallResponseBuilder setAgreementMinimumTransferAmount(Money agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = agreementMinimumTransferAmount == null ? null : agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setAgreementRounding(Money agreementRounding) {
            this.agreementRounding = agreementRounding == null ? null : agreementRounding.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setAgreementThreshold(Money agreementThreshold) {
            this.agreementThreshold = agreementThreshold == null ? null : agreementThreshold.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setBaseCurrencyExposure(MarginCallExposure baseCurrencyExposure) {
            this.baseCurrencyExposure = baseCurrencyExposure == null ? null : baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setCallAgreementType(AgreementName callAgreementType) {
            this.callAgreementType = callAgreementType == null ? null : callAgreementType.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setCallIdentifier(Identifier callIdentifier) {
            this.callIdentifier = callIdentifier == null ? null : callIdentifier.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setClearingBroker(Party clearingBroker) {
            this.clearingBroker = clearingBroker == null ? null : clearingBroker.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio) {
            this.collateralPortfolio = collateralPortfolio == null ? null : collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setCollateralPortfolioValue(CollateralPortfolio collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(collateralPortfolio);
            return this;
        }

        @Override
        public MarginCallResponseBuilder setIndependentAmountBalance(CollateralBalance independentAmountBalance) {
            this.independentAmountBalance = independentAmountBalance == null ? null : independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder setInstructionType(MarginCallInstructionType instructionType) {
            this.instructionType = instructionType == null ? null : instructionType.toBuilder();
            return this;
        }

        @Override
        public MarginCallResponseBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public MarginCallResponseBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallResponseBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallResponseBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallResponseBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallResponseBuilder setRegIMRole(RegIMRoleEnum regIMRole) {
            this.regIMRole = regIMRole == null ? null : regIMRole;
            return this;
        }

        @Override
        public MarginCallResponseBuilder setRegMarginType(RegMarginTypeEnum regMarginType) {
            this.regMarginType = regMarginType == null ? null : regMarginType;
            return this;
        }

        @Override
        public MarginCallResponse build() {
            return new MarginCallResponseImpl(this);
        }

        @Override
        public MarginCallResponseBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallResponseBuilder prune() {
            super.prune();
            if (this.agreedAmountBaseCurrency != null && !this.agreedAmountBaseCurrency.prune().hasData()) {
                this.agreedAmountBaseCurrency = null;
            }
            this.marginCallResponseAction = this.marginCallResponseAction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAgreedAmountBaseCurrency() != null && this.getAgreedAmountBaseCurrency().hasData()) {
                return true;
            }
            if (this.getMarginCallResponseAction() != null && this.getMarginCallResponseAction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getMarginResponseType() != null;
        }

        @Override
        public MarginCallResponseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MarginCallResponseBuilder o = (MarginCallResponseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreedAmountBaseCurrency(), (RosettaModelObjectBuilder)o.getAgreedAmountBaseCurrency(), this::setAgreedAmountBaseCurrency);
            merger.mergeRosetta(this.getMarginCallResponseAction(), o.getMarginCallResponseAction(), this::getOrCreateMarginCallResponseAction);
            merger.mergeBasic((Object)this.getMarginResponseType(), (Object)o.getMarginResponseType(), this::setMarginResponseType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallResponse _that = (MarginCallResponse)this.getType().cast(o);
            if (!Objects.equals(this.agreedAmountBaseCurrency, _that.getAgreedAmountBaseCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.marginCallResponseAction, _that.getMarginCallResponseAction())) {
                return false;
            }
            return Objects.equals((Object)this.marginResponseType, (Object)_that.getMarginResponseType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreedAmountBaseCurrency != null ? this.agreedAmountBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.marginCallResponseAction != null ? this.marginCallResponseAction.hashCode() : 0);
            _result = 31 * _result + (this.marginResponseType != null ? ((Object)((Object)this.marginResponseType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallResponseBuilder {agreedAmountBaseCurrency=" + this.agreedAmountBaseCurrency + ", marginCallResponseAction=" + this.marginCallResponseAction + ", marginResponseType=" + (Object)((Object)this.marginResponseType) + '}' + " " + super.toString();
        }
    }

    public static class MarginCallResponseImpl
    extends MarginCallBase.MarginCallBaseImpl
    implements MarginCallResponse {
        private final Money agreedAmountBaseCurrency;
        private final List<? extends MarginCallResponseAction> marginCallResponseAction;
        private final MarginCallResponseTypeEnum marginResponseType;

        protected MarginCallResponseImpl(MarginCallResponseBuilder builder) {
            super(builder);
            this.agreedAmountBaseCurrency = Optional.ofNullable(builder.getAgreedAmountBaseCurrency()).map(f -> f.build()).orElse(null);
            this.marginCallResponseAction = Optional.ofNullable(builder.getMarginCallResponseAction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.marginResponseType = builder.getMarginResponseType();
        }

        @Override
        public Money getAgreedAmountBaseCurrency() {
            return this.agreedAmountBaseCurrency;
        }

        @Override
        public List<? extends MarginCallResponseAction> getMarginCallResponseAction() {
            return this.marginCallResponseAction;
        }

        @Override
        public MarginCallResponseTypeEnum getMarginResponseType() {
            return this.marginResponseType;
        }

        @Override
        public MarginCallResponse build() {
            return this;
        }

        @Override
        public MarginCallResponseBuilder toBuilder() {
            MarginCallResponseBuilder builder = MarginCallResponse.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallResponseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAgreedAmountBaseCurrency()).ifPresent(builder::setAgreedAmountBaseCurrency);
            Optional.ofNullable(this.getMarginCallResponseAction()).ifPresent(builder::setMarginCallResponseAction);
            Optional.ofNullable(this.getMarginResponseType()).ifPresent(builder::setMarginResponseType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallResponse _that = (MarginCallResponse)this.getType().cast(o);
            if (!Objects.equals(this.agreedAmountBaseCurrency, _that.getAgreedAmountBaseCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.marginCallResponseAction, _that.getMarginCallResponseAction())) {
                return false;
            }
            return Objects.equals((Object)this.marginResponseType, (Object)_that.getMarginResponseType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreedAmountBaseCurrency != null ? this.agreedAmountBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.marginCallResponseAction != null ? this.marginCallResponseAction.hashCode() : 0);
            _result = 31 * _result + (this.marginResponseType != null ? ((Object)((Object)this.marginResponseType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallResponse {agreedAmountBaseCurrency=" + this.agreedAmountBaseCurrency + ", marginCallResponseAction=" + this.marginCallResponseAction + ", marginResponseType=" + (Object)((Object)this.marginResponseType) + '}' + " " + super.toString();
        }
    }

    public static interface MarginCallResponseBuilder
    extends MarginCallResponse,
    MarginCallBase.MarginCallBaseBuilder,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAgreedAmountBaseCurrency();

        @Override
        public Money.MoneyBuilder getAgreedAmountBaseCurrency();

        public MarginCallResponseAction.MarginCallResponseActionBuilder getOrCreateMarginCallResponseAction(int var1);

        public List<? extends MarginCallResponseAction.MarginCallResponseActionBuilder> getMarginCallResponseAction();

        public MarginCallResponseBuilder setAgreedAmountBaseCurrency(Money var1);

        public MarginCallResponseBuilder addMarginCallResponseAction(MarginCallResponseAction var1);

        public MarginCallResponseBuilder addMarginCallResponseAction(MarginCallResponseAction var1, int var2);

        public MarginCallResponseBuilder addMarginCallResponseAction(List<? extends MarginCallResponseAction> var1);

        public MarginCallResponseBuilder setMarginCallResponseAction(List<? extends MarginCallResponseAction> var1);

        public MarginCallResponseBuilder setMarginResponseType(MarginCallResponseTypeEnum var1);

        @Override
        public MarginCallResponseBuilder setAgreementMinimumTransferAmount(Money var1);

        @Override
        public MarginCallResponseBuilder setAgreementRounding(Money var1);

        @Override
        public MarginCallResponseBuilder setAgreementThreshold(Money var1);

        @Override
        public MarginCallResponseBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        @Override
        public MarginCallResponseBuilder setCallAgreementType(AgreementName var1);

        @Override
        public MarginCallResponseBuilder setCallIdentifier(Identifier var1);

        @Override
        public MarginCallResponseBuilder setClearingBroker(Party var1);

        @Override
        public MarginCallResponseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        @Override
        public MarginCallResponseBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        @Override
        public MarginCallResponseBuilder setIndependentAmountBalance(CollateralBalance var1);

        @Override
        public MarginCallResponseBuilder setInstructionType(MarginCallInstructionType var1);

        @Override
        public MarginCallResponseBuilder addParty(Party var1);

        @Override
        public MarginCallResponseBuilder addParty(Party var1, int var2);

        @Override
        public MarginCallResponseBuilder addParty(List<? extends Party> var1);

        @Override
        public MarginCallResponseBuilder setParty(List<? extends Party> var1);

        @Override
        public MarginCallResponseBuilder addPartyRole(PartyRole var1);

        @Override
        public MarginCallResponseBuilder addPartyRole(PartyRole var1, int var2);

        @Override
        public MarginCallResponseBuilder addPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallResponseBuilder setPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallResponseBuilder setRegIMRole(RegIMRoleEnum var1);

        @Override
        public MarginCallResponseBuilder setRegMarginType(RegMarginTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MarginCallBase.MarginCallBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("marginResponseType"), MarginCallResponseTypeEnum.class, (Object)this.getMarginResponseType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreedAmountBaseCurrency"), processor, Money.MoneyBuilder.class, this.getAgreedAmountBaseCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marginCallResponseAction"), processor, MarginCallResponseAction.MarginCallResponseActionBuilder.class, this.getMarginCallResponseAction(), new AttributeMeta[0]);
        }

        @Override
        public MarginCallResponseBuilder prune();
    }
}

