/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.Exposure;
import cdm.event.common.MarginCallBase;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallExposureMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MarginCallExposure
extends MarginCallBase {
    public static final MarginCallExposureMeta metaData = new MarginCallExposureMeta();

    @Override
    public MarginCallExposure build();

    @Override
    public MarginCallExposureBuilder toBuilder();

    public Exposure getOverallExposure();

    public Exposure getScheduleGridIMExposure();

    public Exposure getSimmIMExposure();

    default public RosettaMetaData<? extends MarginCallExposure> metaData() {
        return metaData;
    }

    public static MarginCallExposureBuilder builder() {
        return new MarginCallExposureBuilderImpl();
    }

    default public Class<? extends MarginCallExposure> getType() {
        return MarginCallExposure.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MarginCallBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("overallExposure"), processor, Exposure.class, this.getOverallExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scheduleGridIMExposure"), processor, Exposure.class, this.getScheduleGridIMExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simmIMExposure"), processor, Exposure.class, this.getSimmIMExposure(), new AttributeMeta[0]);
    }

    public static class MarginCallExposureBuilderImpl
    extends MarginCallBase.MarginCallBaseBuilderImpl
    implements MarginCallExposureBuilder {
        protected Exposure.ExposureBuilder overallExposure;
        protected Exposure.ExposureBuilder scheduleGridIMExposure;
        protected Exposure.ExposureBuilder simmIMExposure;

        @Override
        public Exposure.ExposureBuilder getOverallExposure() {
            return this.overallExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateOverallExposure() {
            Exposure.ExposureBuilder result = this.overallExposure != null ? this.overallExposure : (this.overallExposure = Exposure.builder());
            return result;
        }

        @Override
        public Exposure.ExposureBuilder getScheduleGridIMExposure() {
            return this.scheduleGridIMExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateScheduleGridIMExposure() {
            Exposure.ExposureBuilder result = this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure : (this.scheduleGridIMExposure = Exposure.builder());
            return result;
        }

        @Override
        public Exposure.ExposureBuilder getSimmIMExposure() {
            return this.simmIMExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateSimmIMExposure() {
            Exposure.ExposureBuilder result = this.simmIMExposure != null ? this.simmIMExposure : (this.simmIMExposure = Exposure.builder());
            return result;
        }

        @Override
        public MarginCallExposureBuilder setOverallExposure(Exposure overallExposure) {
            this.overallExposure = overallExposure == null ? null : overallExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setScheduleGridIMExposure(Exposure scheduleGridIMExposure) {
            this.scheduleGridIMExposure = scheduleGridIMExposure == null ? null : scheduleGridIMExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setSimmIMExposure(Exposure simmIMExposure) {
            this.simmIMExposure = simmIMExposure == null ? null : simmIMExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setAgreementMinimumTransferAmount(Money agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = agreementMinimumTransferAmount == null ? null : agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setAgreementRounding(Money agreementRounding) {
            this.agreementRounding = agreementRounding == null ? null : agreementRounding.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setAgreementThreshold(Money agreementThreshold) {
            this.agreementThreshold = agreementThreshold == null ? null : agreementThreshold.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setBaseCurrencyExposure(MarginCallExposure baseCurrencyExposure) {
            this.baseCurrencyExposure = baseCurrencyExposure == null ? null : baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setCallAgreementType(AgreementName callAgreementType) {
            this.callAgreementType = callAgreementType == null ? null : callAgreementType.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setCallIdentifier(Identifier callIdentifier) {
            this.callIdentifier = callIdentifier == null ? null : callIdentifier.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setClearingBroker(Party clearingBroker) {
            this.clearingBroker = clearingBroker == null ? null : clearingBroker.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio) {
            this.collateralPortfolio = collateralPortfolio == null ? null : collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setCollateralPortfolioValue(CollateralPortfolio collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(collateralPortfolio);
            return this;
        }

        @Override
        public MarginCallExposureBuilder setIndependentAmountBalance(CollateralBalance independentAmountBalance) {
            this.independentAmountBalance = independentAmountBalance == null ? null : independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setInstructionType(MarginCallInstructionType instructionType) {
            this.instructionType = instructionType == null ? null : instructionType.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public MarginCallExposureBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallExposureBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallExposureBuilder setRegIMRole(RegIMRoleEnum regIMRole) {
            this.regIMRole = regIMRole == null ? null : regIMRole;
            return this;
        }

        @Override
        public MarginCallExposureBuilder setRegMarginType(RegMarginTypeEnum regMarginType) {
            this.regMarginType = regMarginType == null ? null : regMarginType;
            return this;
        }

        @Override
        public MarginCallExposure build() {
            return new MarginCallExposureImpl(this);
        }

        @Override
        public MarginCallExposureBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallExposureBuilder prune() {
            super.prune();
            if (this.overallExposure != null && !this.overallExposure.prune().hasData()) {
                this.overallExposure = null;
            }
            if (this.scheduleGridIMExposure != null && !this.scheduleGridIMExposure.prune().hasData()) {
                this.scheduleGridIMExposure = null;
            }
            if (this.simmIMExposure != null && !this.simmIMExposure.prune().hasData()) {
                this.simmIMExposure = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOverallExposure() != null && this.getOverallExposure().hasData()) {
                return true;
            }
            if (this.getScheduleGridIMExposure() != null && this.getScheduleGridIMExposure().hasData()) {
                return true;
            }
            return this.getSimmIMExposure() != null && this.getSimmIMExposure().hasData();
        }

        @Override
        public MarginCallExposureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MarginCallExposureBuilder o = (MarginCallExposureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOverallExposure(), (RosettaModelObjectBuilder)o.getOverallExposure(), this::setOverallExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getScheduleGridIMExposure(), (RosettaModelObjectBuilder)o.getScheduleGridIMExposure(), this::setScheduleGridIMExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimmIMExposure(), (RosettaModelObjectBuilder)o.getSimmIMExposure(), this::setSimmIMExposure);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallExposure _that = (MarginCallExposure)this.getType().cast(o);
            if (!Objects.equals(this.overallExposure, _that.getOverallExposure())) {
                return false;
            }
            if (!Objects.equals(this.scheduleGridIMExposure, _that.getScheduleGridIMExposure())) {
                return false;
            }
            return Objects.equals(this.simmIMExposure, _that.getSimmIMExposure());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.overallExposure != null ? this.overallExposure.hashCode() : 0);
            _result = 31 * _result + (this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure.hashCode() : 0);
            _result = 31 * _result + (this.simmIMExposure != null ? this.simmIMExposure.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallExposureBuilder {overallExposure=" + this.overallExposure + ", scheduleGridIMExposure=" + this.scheduleGridIMExposure + ", simmIMExposure=" + this.simmIMExposure + '}' + " " + super.toString();
        }
    }

    public static class MarginCallExposureImpl
    extends MarginCallBase.MarginCallBaseImpl
    implements MarginCallExposure {
        private final Exposure overallExposure;
        private final Exposure scheduleGridIMExposure;
        private final Exposure simmIMExposure;

        protected MarginCallExposureImpl(MarginCallExposureBuilder builder) {
            super(builder);
            this.overallExposure = Optional.ofNullable(builder.getOverallExposure()).map(f -> f.build()).orElse(null);
            this.scheduleGridIMExposure = Optional.ofNullable(builder.getScheduleGridIMExposure()).map(f -> f.build()).orElse(null);
            this.simmIMExposure = Optional.ofNullable(builder.getSimmIMExposure()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Exposure getOverallExposure() {
            return this.overallExposure;
        }

        @Override
        public Exposure getScheduleGridIMExposure() {
            return this.scheduleGridIMExposure;
        }

        @Override
        public Exposure getSimmIMExposure() {
            return this.simmIMExposure;
        }

        @Override
        public MarginCallExposure build() {
            return this;
        }

        @Override
        public MarginCallExposureBuilder toBuilder() {
            MarginCallExposureBuilder builder = MarginCallExposure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallExposureBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOverallExposure()).ifPresent(builder::setOverallExposure);
            Optional.ofNullable(this.getScheduleGridIMExposure()).ifPresent(builder::setScheduleGridIMExposure);
            Optional.ofNullable(this.getSimmIMExposure()).ifPresent(builder::setSimmIMExposure);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallExposure _that = (MarginCallExposure)this.getType().cast(o);
            if (!Objects.equals(this.overallExposure, _that.getOverallExposure())) {
                return false;
            }
            if (!Objects.equals(this.scheduleGridIMExposure, _that.getScheduleGridIMExposure())) {
                return false;
            }
            return Objects.equals(this.simmIMExposure, _that.getSimmIMExposure());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.overallExposure != null ? this.overallExposure.hashCode() : 0);
            _result = 31 * _result + (this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure.hashCode() : 0);
            _result = 31 * _result + (this.simmIMExposure != null ? this.simmIMExposure.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallExposure {overallExposure=" + this.overallExposure + ", scheduleGridIMExposure=" + this.scheduleGridIMExposure + ", simmIMExposure=" + this.simmIMExposure + '}' + " " + super.toString();
        }
    }

    public static interface MarginCallExposureBuilder
    extends MarginCallExposure,
    MarginCallBase.MarginCallBaseBuilder,
    RosettaModelObjectBuilder {
        public Exposure.ExposureBuilder getOrCreateOverallExposure();

        @Override
        public Exposure.ExposureBuilder getOverallExposure();

        public Exposure.ExposureBuilder getOrCreateScheduleGridIMExposure();

        @Override
        public Exposure.ExposureBuilder getScheduleGridIMExposure();

        public Exposure.ExposureBuilder getOrCreateSimmIMExposure();

        @Override
        public Exposure.ExposureBuilder getSimmIMExposure();

        public MarginCallExposureBuilder setOverallExposure(Exposure var1);

        public MarginCallExposureBuilder setScheduleGridIMExposure(Exposure var1);

        public MarginCallExposureBuilder setSimmIMExposure(Exposure var1);

        @Override
        public MarginCallExposureBuilder setAgreementMinimumTransferAmount(Money var1);

        @Override
        public MarginCallExposureBuilder setAgreementRounding(Money var1);

        @Override
        public MarginCallExposureBuilder setAgreementThreshold(Money var1);

        @Override
        public MarginCallExposureBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        @Override
        public MarginCallExposureBuilder setCallAgreementType(AgreementName var1);

        @Override
        public MarginCallExposureBuilder setCallIdentifier(Identifier var1);

        @Override
        public MarginCallExposureBuilder setClearingBroker(Party var1);

        @Override
        public MarginCallExposureBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        @Override
        public MarginCallExposureBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        @Override
        public MarginCallExposureBuilder setIndependentAmountBalance(CollateralBalance var1);

        @Override
        public MarginCallExposureBuilder setInstructionType(MarginCallInstructionType var1);

        @Override
        public MarginCallExposureBuilder addParty(Party var1);

        @Override
        public MarginCallExposureBuilder addParty(Party var1, int var2);

        @Override
        public MarginCallExposureBuilder addParty(List<? extends Party> var1);

        @Override
        public MarginCallExposureBuilder setParty(List<? extends Party> var1);

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole var1);

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole var1, int var2);

        @Override
        public MarginCallExposureBuilder addPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallExposureBuilder setPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallExposureBuilder setRegIMRole(RegIMRoleEnum var1);

        @Override
        public MarginCallExposureBuilder setRegMarginType(RegMarginTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MarginCallBase.MarginCallBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("overallExposure"), processor, Exposure.ExposureBuilder.class, this.getOverallExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scheduleGridIMExposure"), processor, Exposure.ExposureBuilder.class, this.getScheduleGridIMExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simmIMExposure"), processor, Exposure.ExposureBuilder.class, this.getSimmIMExposure(), new AttributeMeta[0]);
        }

        @Override
        public MarginCallExposureBuilder prune();
    }
}

