/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.MarginCallExposure;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallBaseMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MarginCallBase
extends RosettaModelObject {
    public static final MarginCallBaseMeta metaData = new MarginCallBaseMeta();

    public MarginCallBase build();

    public MarginCallBaseBuilder toBuilder();

    public Money getAgreementMinimumTransferAmount();

    public Money getAgreementRounding();

    public Money getAgreementThreshold();

    public MarginCallExposure getBaseCurrencyExposure();

    public AgreementName getCallAgreementType();

    public Identifier getCallIdentifier();

    public Party getClearingBroker();

    public ReferenceWithMetaCollateralPortfolio getCollateralPortfolio();

    public CollateralBalance getIndependentAmountBalance();

    public MarginCallInstructionType getInstructionType();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public RegIMRoleEnum getRegIMRole();

    public RegMarginTypeEnum getRegMarginType();

    default public RosettaMetaData<? extends MarginCallBase> metaData() {
        return metaData;
    }

    public static MarginCallBaseBuilder builder() {
        return new MarginCallBaseBuilderImpl();
    }

    default public Class<? extends MarginCallBase> getType() {
        return MarginCallBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.class, this.getAgreementRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.class, this.getAgreementThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.class, this.getCallAgreementType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.class, this.getCallIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.class, this.getClearingBroker(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.class, this.getInstructionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
    }

    public static class MarginCallBaseBuilderImpl
    implements MarginCallBaseBuilder {
        protected Money.MoneyBuilder agreementMinimumTransferAmount;
        protected Money.MoneyBuilder agreementRounding;
        protected Money.MoneyBuilder agreementThreshold;
        protected MarginCallExposure.MarginCallExposureBuilder baseCurrencyExposure;
        protected AgreementName.AgreementNameBuilder callAgreementType;
        protected Identifier.IdentifierBuilder callIdentifier;
        protected Party.PartyBuilder clearingBroker;
        protected ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder collateralPortfolio;
        protected CollateralBalance.CollateralBalanceBuilder independentAmountBalance;
        protected MarginCallInstructionType.MarginCallInstructionTypeBuilder instructionType;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected RegIMRoleEnum regIMRole;
        protected RegMarginTypeEnum regMarginType;

        @Override
        public Money.MoneyBuilder getAgreementMinimumTransferAmount() {
            return this.agreementMinimumTransferAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementMinimumTransferAmount() {
            Money.MoneyBuilder result = this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount : (this.agreementMinimumTransferAmount = Money.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getAgreementRounding() {
            return this.agreementRounding;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementRounding() {
            Money.MoneyBuilder result = this.agreementRounding != null ? this.agreementRounding : (this.agreementRounding = Money.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getAgreementThreshold() {
            return this.agreementThreshold;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementThreshold() {
            Money.MoneyBuilder result = this.agreementThreshold != null ? this.agreementThreshold : (this.agreementThreshold = Money.builder());
            return result;
        }

        @Override
        public MarginCallExposure.MarginCallExposureBuilder getBaseCurrencyExposure() {
            return this.baseCurrencyExposure;
        }

        @Override
        public MarginCallExposure.MarginCallExposureBuilder getOrCreateBaseCurrencyExposure() {
            MarginCallExposure.MarginCallExposureBuilder result = this.baseCurrencyExposure != null ? this.baseCurrencyExposure : (this.baseCurrencyExposure = MarginCallExposure.builder());
            return result;
        }

        @Override
        public AgreementName.AgreementNameBuilder getCallAgreementType() {
            return this.callAgreementType;
        }

        @Override
        public AgreementName.AgreementNameBuilder getOrCreateCallAgreementType() {
            AgreementName.AgreementNameBuilder result = this.callAgreementType != null ? this.callAgreementType : (this.callAgreementType = AgreementName.builder());
            return result;
        }

        @Override
        public Identifier.IdentifierBuilder getCallIdentifier() {
            return this.callIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateCallIdentifier() {
            Identifier.IdentifierBuilder result = this.callIdentifier != null ? this.callIdentifier : (this.callIdentifier = Identifier.builder());
            return result;
        }

        @Override
        public Party.PartyBuilder getClearingBroker() {
            return this.clearingBroker;
        }

        @Override
        public Party.PartyBuilder getOrCreateClearingBroker() {
            Party.PartyBuilder result = this.clearingBroker != null ? this.clearingBroker : (this.clearingBroker = Party.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio() {
            ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder result = this.collateralPortfolio != null ? this.collateralPortfolio : (this.collateralPortfolio = ReferenceWithMetaCollateralPortfolio.builder());
            return result;
        }

        @Override
        public CollateralBalance.CollateralBalanceBuilder getIndependentAmountBalance() {
            return this.independentAmountBalance;
        }

        @Override
        public CollateralBalance.CollateralBalanceBuilder getOrCreateIndependentAmountBalance() {
            CollateralBalance.CollateralBalanceBuilder result = this.independentAmountBalance != null ? this.independentAmountBalance : (this.independentAmountBalance = CollateralBalance.builder());
            return result;
        }

        @Override
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getInstructionType() {
            return this.instructionType;
        }

        @Override
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getOrCreateInstructionType() {
            MarginCallInstructionType.MarginCallInstructionTypeBuilder result = this.instructionType != null ? this.instructionType : (this.instructionType = MarginCallInstructionType.builder());
            return result;
        }

        @Override
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int _index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        public RegIMRoleEnum getRegIMRole() {
            return this.regIMRole;
        }

        @Override
        public RegMarginTypeEnum getRegMarginType() {
            return this.regMarginType;
        }

        @Override
        public MarginCallBaseBuilder setAgreementMinimumTransferAmount(Money agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = agreementMinimumTransferAmount == null ? null : agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setAgreementRounding(Money agreementRounding) {
            this.agreementRounding = agreementRounding == null ? null : agreementRounding.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setAgreementThreshold(Money agreementThreshold) {
            this.agreementThreshold = agreementThreshold == null ? null : agreementThreshold.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setBaseCurrencyExposure(MarginCallExposure baseCurrencyExposure) {
            this.baseCurrencyExposure = baseCurrencyExposure == null ? null : baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setCallAgreementType(AgreementName callAgreementType) {
            this.callAgreementType = callAgreementType == null ? null : callAgreementType.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setCallIdentifier(Identifier callIdentifier) {
            this.callIdentifier = callIdentifier == null ? null : callIdentifier.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setClearingBroker(Party clearingBroker) {
            this.clearingBroker = clearingBroker == null ? null : clearingBroker.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio) {
            this.collateralPortfolio = collateralPortfolio == null ? null : collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setCollateralPortfolioValue(CollateralPortfolio collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(collateralPortfolio);
            return this;
        }

        @Override
        public MarginCallBaseBuilder setIndependentAmountBalance(CollateralBalance independentAmountBalance) {
            this.independentAmountBalance = independentAmountBalance == null ? null : independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setInstructionType(MarginCallInstructionType instructionType) {
            this.instructionType = instructionType == null ? null : instructionType.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public MarginCallBaseBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallBaseBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallBaseBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallBaseBuilder setRegIMRole(RegIMRoleEnum regIMRole) {
            this.regIMRole = regIMRole == null ? null : regIMRole;
            return this;
        }

        @Override
        public MarginCallBaseBuilder setRegMarginType(RegMarginTypeEnum regMarginType) {
            this.regMarginType = regMarginType == null ? null : regMarginType;
            return this;
        }

        @Override
        public MarginCallBase build() {
            return new MarginCallBaseImpl(this);
        }

        @Override
        public MarginCallBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallBaseBuilder prune() {
            if (this.agreementMinimumTransferAmount != null && !this.agreementMinimumTransferAmount.prune().hasData()) {
                this.agreementMinimumTransferAmount = null;
            }
            if (this.agreementRounding != null && !this.agreementRounding.prune().hasData()) {
                this.agreementRounding = null;
            }
            if (this.agreementThreshold != null && !this.agreementThreshold.prune().hasData()) {
                this.agreementThreshold = null;
            }
            if (this.baseCurrencyExposure != null && !this.baseCurrencyExposure.prune().hasData()) {
                this.baseCurrencyExposure = null;
            }
            if (this.callAgreementType != null && !this.callAgreementType.prune().hasData()) {
                this.callAgreementType = null;
            }
            if (this.callIdentifier != null && !this.callIdentifier.prune().hasData()) {
                this.callIdentifier = null;
            }
            if (this.clearingBroker != null && !this.clearingBroker.prune().hasData()) {
                this.clearingBroker = null;
            }
            if (this.collateralPortfolio != null && !this.collateralPortfolio.prune().hasData()) {
                this.collateralPortfolio = null;
            }
            if (this.independentAmountBalance != null && !this.independentAmountBalance.prune().hasData()) {
                this.independentAmountBalance = null;
            }
            if (this.instructionType != null && !this.instructionType.prune().hasData()) {
                this.instructionType = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAgreementMinimumTransferAmount() != null && this.getAgreementMinimumTransferAmount().hasData()) {
                return true;
            }
            if (this.getAgreementRounding() != null && this.getAgreementRounding().hasData()) {
                return true;
            }
            if (this.getAgreementThreshold() != null && this.getAgreementThreshold().hasData()) {
                return true;
            }
            if (this.getBaseCurrencyExposure() != null && this.getBaseCurrencyExposure().hasData()) {
                return true;
            }
            if (this.getCallAgreementType() != null && this.getCallAgreementType().hasData()) {
                return true;
            }
            if (this.getCallIdentifier() != null && this.getCallIdentifier().hasData()) {
                return true;
            }
            if (this.getClearingBroker() != null && this.getClearingBroker().hasData()) {
                return true;
            }
            if (this.getCollateralPortfolio() != null && this.getCollateralPortfolio().hasData()) {
                return true;
            }
            if (this.getIndependentAmountBalance() != null && this.getIndependentAmountBalance().hasData()) {
                return true;
            }
            if (this.getInstructionType() != null && this.getInstructionType().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRegIMRole() != null) {
                return true;
            }
            return this.getRegMarginType() != null;
        }

        public MarginCallBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MarginCallBaseBuilder o = (MarginCallBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementMinimumTransferAmount(), (RosettaModelObjectBuilder)o.getAgreementMinimumTransferAmount(), this::setAgreementMinimumTransferAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementRounding(), (RosettaModelObjectBuilder)o.getAgreementRounding(), this::setAgreementRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementThreshold(), (RosettaModelObjectBuilder)o.getAgreementThreshold(), this::setAgreementThreshold);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBaseCurrencyExposure(), (RosettaModelObjectBuilder)o.getBaseCurrencyExposure(), this::setBaseCurrencyExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallAgreementType(), (RosettaModelObjectBuilder)o.getCallAgreementType(), this::setCallAgreementType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallIdentifier(), (RosettaModelObjectBuilder)o.getCallIdentifier(), this::setCallIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingBroker(), (RosettaModelObjectBuilder)o.getClearingBroker(), this::setClearingBroker);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralPortfolio(), (RosettaModelObjectBuilder)o.getCollateralPortfolio(), this::setCollateralPortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndependentAmountBalance(), (RosettaModelObjectBuilder)o.getIndependentAmountBalance(), this::setIndependentAmountBalance);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInstructionType(), (RosettaModelObjectBuilder)o.getInstructionType(), this::setInstructionType);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeBasic((Object)this.getRegIMRole(), (Object)o.getRegIMRole(), this::setRegIMRole, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRegMarginType(), (Object)o.getRegMarginType(), this::setRegMarginType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MarginCallBase _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementMinimumTransferAmount, _that.getAgreementMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.agreementRounding, _that.getAgreementRounding())) {
                return false;
            }
            if (!Objects.equals(this.agreementThreshold, _that.getAgreementThreshold())) {
                return false;
            }
            if (!Objects.equals(this.baseCurrencyExposure, _that.getBaseCurrencyExposure())) {
                return false;
            }
            if (!Objects.equals(this.callAgreementType, _that.getCallAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.callIdentifier, _that.getCallIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.clearingBroker, _that.getClearingBroker())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.independentAmountBalance, _that.getIndependentAmountBalance())) {
                return false;
            }
            if (!Objects.equals(this.instructionType, _that.getInstructionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals((Object)this.regIMRole, (Object)_that.getRegIMRole())) {
                return false;
            }
            return Objects.equals((Object)this.regMarginType, (Object)_that.getRegMarginType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.agreementRounding != null ? this.agreementRounding.hashCode() : 0);
            _result = 31 * _result + (this.agreementThreshold != null ? this.agreementThreshold.hashCode() : 0);
            _result = 31 * _result + (this.baseCurrencyExposure != null ? this.baseCurrencyExposure.hashCode() : 0);
            _result = 31 * _result + (this.callAgreementType != null ? this.callAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.callIdentifier != null ? this.callIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.clearingBroker != null ? this.clearingBroker.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.independentAmountBalance != null ? this.independentAmountBalance.hashCode() : 0);
            _result = 31 * _result + (this.instructionType != null ? this.instructionType.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.regIMRole != null ? ((Object)((Object)this.regIMRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.regMarginType != null ? ((Object)((Object)this.regMarginType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MarginCallBaseBuilder {agreementMinimumTransferAmount=" + this.agreementMinimumTransferAmount + ", agreementRounding=" + this.agreementRounding + ", agreementThreshold=" + this.agreementThreshold + ", baseCurrencyExposure=" + this.baseCurrencyExposure + ", callAgreementType=" + this.callAgreementType + ", callIdentifier=" + this.callIdentifier + ", clearingBroker=" + this.clearingBroker + ", collateralPortfolio=" + this.collateralPortfolio + ", independentAmountBalance=" + this.independentAmountBalance + ", instructionType=" + this.instructionType + ", party=" + this.party + ", partyRole=" + this.partyRole + ", regIMRole=" + (Object)((Object)this.regIMRole) + ", regMarginType=" + (Object)((Object)this.regMarginType) + '}';
        }
    }

    public static class MarginCallBaseImpl
    implements MarginCallBase {
        private final Money agreementMinimumTransferAmount;
        private final Money agreementRounding;
        private final Money agreementThreshold;
        private final MarginCallExposure baseCurrencyExposure;
        private final AgreementName callAgreementType;
        private final Identifier callIdentifier;
        private final Party clearingBroker;
        private final ReferenceWithMetaCollateralPortfolio collateralPortfolio;
        private final CollateralBalance independentAmountBalance;
        private final MarginCallInstructionType instructionType;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final RegIMRoleEnum regIMRole;
        private final RegMarginTypeEnum regMarginType;

        protected MarginCallBaseImpl(MarginCallBaseBuilder builder) {
            this.agreementMinimumTransferAmount = Optional.ofNullable(builder.getAgreementMinimumTransferAmount()).map(f -> f.build()).orElse(null);
            this.agreementRounding = Optional.ofNullable(builder.getAgreementRounding()).map(f -> f.build()).orElse(null);
            this.agreementThreshold = Optional.ofNullable(builder.getAgreementThreshold()).map(f -> f.build()).orElse(null);
            this.baseCurrencyExposure = Optional.ofNullable(builder.getBaseCurrencyExposure()).map(f -> f.build()).orElse(null);
            this.callAgreementType = Optional.ofNullable(builder.getCallAgreementType()).map(f -> f.build()).orElse(null);
            this.callIdentifier = Optional.ofNullable(builder.getCallIdentifier()).map(f -> f.build()).orElse(null);
            this.clearingBroker = Optional.ofNullable(builder.getClearingBroker()).map(f -> f.build()).orElse(null);
            this.collateralPortfolio = Optional.ofNullable(builder.getCollateralPortfolio()).map(f -> f.build()).orElse(null);
            this.independentAmountBalance = Optional.ofNullable(builder.getIndependentAmountBalance()).map(f -> f.build()).orElse(null);
            this.instructionType = Optional.ofNullable(builder.getInstructionType()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.regIMRole = builder.getRegIMRole();
            this.regMarginType = builder.getRegMarginType();
        }

        @Override
        public Money getAgreementMinimumTransferAmount() {
            return this.agreementMinimumTransferAmount;
        }

        @Override
        public Money getAgreementRounding() {
            return this.agreementRounding;
        }

        @Override
        public Money getAgreementThreshold() {
            return this.agreementThreshold;
        }

        @Override
        public MarginCallExposure getBaseCurrencyExposure() {
            return this.baseCurrencyExposure;
        }

        @Override
        public AgreementName getCallAgreementType() {
            return this.callAgreementType;
        }

        @Override
        public Identifier getCallIdentifier() {
            return this.callIdentifier;
        }

        @Override
        public Party getClearingBroker() {
            return this.clearingBroker;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public CollateralBalance getIndependentAmountBalance() {
            return this.independentAmountBalance;
        }

        @Override
        public MarginCallInstructionType getInstructionType() {
            return this.instructionType;
        }

        @Override
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public RegIMRoleEnum getRegIMRole() {
            return this.regIMRole;
        }

        @Override
        public RegMarginTypeEnum getRegMarginType() {
            return this.regMarginType;
        }

        @Override
        public MarginCallBase build() {
            return this;
        }

        @Override
        public MarginCallBaseBuilder toBuilder() {
            MarginCallBaseBuilder builder = MarginCallBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallBaseBuilder builder) {
            Optional.ofNullable(this.getAgreementMinimumTransferAmount()).ifPresent(builder::setAgreementMinimumTransferAmount);
            Optional.ofNullable(this.getAgreementRounding()).ifPresent(builder::setAgreementRounding);
            Optional.ofNullable(this.getAgreementThreshold()).ifPresent(builder::setAgreementThreshold);
            Optional.ofNullable(this.getBaseCurrencyExposure()).ifPresent(builder::setBaseCurrencyExposure);
            Optional.ofNullable(this.getCallAgreementType()).ifPresent(builder::setCallAgreementType);
            Optional.ofNullable(this.getCallIdentifier()).ifPresent(builder::setCallIdentifier);
            Optional.ofNullable(this.getClearingBroker()).ifPresent(builder::setClearingBroker);
            Optional.ofNullable(this.getCollateralPortfolio()).ifPresent(builder::setCollateralPortfolio);
            Optional.ofNullable(this.getIndependentAmountBalance()).ifPresent(builder::setIndependentAmountBalance);
            Optional.ofNullable(this.getInstructionType()).ifPresent(builder::setInstructionType);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getRegIMRole()).ifPresent(builder::setRegIMRole);
            Optional.ofNullable(this.getRegMarginType()).ifPresent(builder::setRegMarginType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MarginCallBase _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementMinimumTransferAmount, _that.getAgreementMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.agreementRounding, _that.getAgreementRounding())) {
                return false;
            }
            if (!Objects.equals(this.agreementThreshold, _that.getAgreementThreshold())) {
                return false;
            }
            if (!Objects.equals(this.baseCurrencyExposure, _that.getBaseCurrencyExposure())) {
                return false;
            }
            if (!Objects.equals(this.callAgreementType, _that.getCallAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.callIdentifier, _that.getCallIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.clearingBroker, _that.getClearingBroker())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.independentAmountBalance, _that.getIndependentAmountBalance())) {
                return false;
            }
            if (!Objects.equals(this.instructionType, _that.getInstructionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals((Object)this.regIMRole, (Object)_that.getRegIMRole())) {
                return false;
            }
            return Objects.equals((Object)this.regMarginType, (Object)_that.getRegMarginType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.agreementRounding != null ? this.agreementRounding.hashCode() : 0);
            _result = 31 * _result + (this.agreementThreshold != null ? this.agreementThreshold.hashCode() : 0);
            _result = 31 * _result + (this.baseCurrencyExposure != null ? this.baseCurrencyExposure.hashCode() : 0);
            _result = 31 * _result + (this.callAgreementType != null ? this.callAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.callIdentifier != null ? this.callIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.clearingBroker != null ? this.clearingBroker.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.independentAmountBalance != null ? this.independentAmountBalance.hashCode() : 0);
            _result = 31 * _result + (this.instructionType != null ? this.instructionType.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.regIMRole != null ? ((Object)((Object)this.regIMRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.regMarginType != null ? ((Object)((Object)this.regMarginType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MarginCallBase {agreementMinimumTransferAmount=" + this.agreementMinimumTransferAmount + ", agreementRounding=" + this.agreementRounding + ", agreementThreshold=" + this.agreementThreshold + ", baseCurrencyExposure=" + this.baseCurrencyExposure + ", callAgreementType=" + this.callAgreementType + ", callIdentifier=" + this.callIdentifier + ", clearingBroker=" + this.clearingBroker + ", collateralPortfolio=" + this.collateralPortfolio + ", independentAmountBalance=" + this.independentAmountBalance + ", instructionType=" + this.instructionType + ", party=" + this.party + ", partyRole=" + this.partyRole + ", regIMRole=" + (Object)((Object)this.regIMRole) + ", regMarginType=" + (Object)((Object)this.regMarginType) + '}';
        }
    }

    public static interface MarginCallBaseBuilder
    extends MarginCallBase,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAgreementMinimumTransferAmount();

        @Override
        public Money.MoneyBuilder getAgreementMinimumTransferAmount();

        public Money.MoneyBuilder getOrCreateAgreementRounding();

        @Override
        public Money.MoneyBuilder getAgreementRounding();

        public Money.MoneyBuilder getOrCreateAgreementThreshold();

        @Override
        public Money.MoneyBuilder getAgreementThreshold();

        public MarginCallExposure.MarginCallExposureBuilder getOrCreateBaseCurrencyExposure();

        @Override
        public MarginCallExposure.MarginCallExposureBuilder getBaseCurrencyExposure();

        public AgreementName.AgreementNameBuilder getOrCreateCallAgreementType();

        @Override
        public AgreementName.AgreementNameBuilder getCallAgreementType();

        public Identifier.IdentifierBuilder getOrCreateCallIdentifier();

        @Override
        public Identifier.IdentifierBuilder getCallIdentifier();

        public Party.PartyBuilder getOrCreateClearingBroker();

        @Override
        public Party.PartyBuilder getClearingBroker();

        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio();

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getCollateralPortfolio();

        public CollateralBalance.CollateralBalanceBuilder getOrCreateIndependentAmountBalance();

        @Override
        public CollateralBalance.CollateralBalanceBuilder getIndependentAmountBalance();

        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getOrCreateInstructionType();

        @Override
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getInstructionType();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public MarginCallBaseBuilder setAgreementMinimumTransferAmount(Money var1);

        public MarginCallBaseBuilder setAgreementRounding(Money var1);

        public MarginCallBaseBuilder setAgreementThreshold(Money var1);

        public MarginCallBaseBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        public MarginCallBaseBuilder setCallAgreementType(AgreementName var1);

        public MarginCallBaseBuilder setCallIdentifier(Identifier var1);

        public MarginCallBaseBuilder setClearingBroker(Party var1);

        public MarginCallBaseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        public MarginCallBaseBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        public MarginCallBaseBuilder setIndependentAmountBalance(CollateralBalance var1);

        public MarginCallBaseBuilder setInstructionType(MarginCallInstructionType var1);

        public MarginCallBaseBuilder addParty(Party var1);

        public MarginCallBaseBuilder addParty(Party var1, int var2);

        public MarginCallBaseBuilder addParty(List<? extends Party> var1);

        public MarginCallBaseBuilder setParty(List<? extends Party> var1);

        public MarginCallBaseBuilder addPartyRole(PartyRole var1);

        public MarginCallBaseBuilder addPartyRole(PartyRole var1, int var2);

        public MarginCallBaseBuilder addPartyRole(List<? extends PartyRole> var1);

        public MarginCallBaseBuilder setPartyRole(List<? extends PartyRole> var1);

        public MarginCallBaseBuilder setRegIMRole(RegIMRoleEnum var1);

        public MarginCallBaseBuilder setRegMarginType(RegMarginTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.MoneyBuilder.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.MoneyBuilder.class, this.getAgreementRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.MoneyBuilder.class, this.getAgreementThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.MarginCallExposureBuilder.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.AgreementNameBuilder.class, this.getCallAgreementType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getCallIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.PartyBuilder.class, this.getClearingBroker(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.MarginCallInstructionTypeBuilder.class, this.getInstructionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
        }

        public MarginCallBaseBuilder prune();
    }
}

