/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.Transfer;
import cdm.event.common.meta.IndexTransitionInstructionMeta;
import cdm.product.common.settlement.PriceQuantity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface IndexTransitionInstruction
extends RosettaModelObject {
    public static final IndexTransitionInstructionMeta metaData = new IndexTransitionInstructionMeta();

    public IndexTransitionInstruction build();

    public IndexTransitionInstructionBuilder toBuilder();

    public Transfer getCashTransfer();

    public Date getEffectiveDate();

    public List<? extends PriceQuantity> getPriceQuantity();

    default public RosettaMetaData<? extends IndexTransitionInstruction> metaData() {
        return metaData;
    }

    public static IndexTransitionInstructionBuilder builder() {
        return new IndexTransitionInstructionBuilderImpl();
    }

    default public Class<? extends IndexTransitionInstruction> getType() {
        return IndexTransitionInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashTransfer"), processor, Transfer.class, this.getCashTransfer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
    }

    public static class IndexTransitionInstructionBuilderImpl
    implements IndexTransitionInstructionBuilder {
        protected Transfer.TransferBuilder cashTransfer;
        protected Date effectiveDate;
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();

        @Override
        public Transfer.TransferBuilder getCashTransfer() {
            return this.cashTransfer;
        }

        @Override
        public Transfer.TransferBuilder getOrCreateCashTransfer() {
            Transfer.TransferBuilder result = this.cashTransfer != null ? this.cashTransfer : (this.cashTransfer = Transfer.builder());
            return result;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int _index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, _index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        public IndexTransitionInstructionBuilder setCashTransfer(Transfer cashTransfer) {
            this.cashTransfer = cashTransfer == null ? null : cashTransfer.toBuilder();
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity priceQuantity) {
            if (priceQuantity != null) {
                this.priceQuantity.add(priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity priceQuantity, int _idx) {
            this.getIndex(this.priceQuantity, _idx, () -> priceQuantity.toBuilder());
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IndexTransitionInstruction build() {
            return new IndexTransitionInstructionImpl(this);
        }

        @Override
        public IndexTransitionInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder prune() {
            if (this.cashTransfer != null && !this.cashTransfer.prune().hasData()) {
                this.cashTransfer = null;
            }
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCashTransfer() != null && this.getCashTransfer().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public IndexTransitionInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IndexTransitionInstructionBuilder o = (IndexTransitionInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashTransfer(), (RosettaModelObjectBuilder)o.getCashTransfer(), this::setCashTransfer);
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IndexTransitionInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.cashTransfer, _that.getCashTransfer())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashTransfer != null ? this.cashTransfer.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IndexTransitionInstructionBuilder {cashTransfer=" + this.cashTransfer + ", effectiveDate=" + this.effectiveDate + ", priceQuantity=" + this.priceQuantity + '}';
        }
    }

    public static class IndexTransitionInstructionImpl
    implements IndexTransitionInstruction {
        private final Transfer cashTransfer;
        private final Date effectiveDate;
        private final List<? extends PriceQuantity> priceQuantity;

        protected IndexTransitionInstructionImpl(IndexTransitionInstructionBuilder builder) {
            this.cashTransfer = Optional.ofNullable(builder.getCashTransfer()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public Transfer getCashTransfer() {
            return this.cashTransfer;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public IndexTransitionInstruction build() {
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder toBuilder() {
            IndexTransitionInstructionBuilder builder = IndexTransitionInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IndexTransitionInstructionBuilder builder) {
            Optional.ofNullable(this.getCashTransfer()).ifPresent(builder::setCashTransfer);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IndexTransitionInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.cashTransfer, _that.getCashTransfer())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashTransfer != null ? this.cashTransfer.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IndexTransitionInstruction {cashTransfer=" + this.cashTransfer + ", effectiveDate=" + this.effectiveDate + ", priceQuantity=" + this.priceQuantity + '}';
        }
    }

    public static interface IndexTransitionInstructionBuilder
    extends IndexTransitionInstruction,
    RosettaModelObjectBuilder {
        public Transfer.TransferBuilder getOrCreateCashTransfer();

        @Override
        public Transfer.TransferBuilder getCashTransfer();

        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public IndexTransitionInstructionBuilder setCashTransfer(Transfer var1);

        public IndexTransitionInstructionBuilder setEffectiveDate(Date var1);

        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity var1);

        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public IndexTransitionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public IndexTransitionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashTransfer"), processor, Transfer.TransferBuilder.class, this.getCashTransfer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
        }

        public IndexTransitionInstructionBuilder prune();
    }
}

