/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ExposureMeta;
import cdm.event.position.PortfolioState;
import cdm.event.position.metafields.ReferenceWithMetaPortfolioState;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Exposure
extends RosettaModelObject {
    public static final ExposureMeta metaData = new ExposureMeta();

    public Exposure build();

    public ExposureBuilder toBuilder();

    public Money getAggregateValue();

    public ZonedDateTime getCalculationDateTime();

    public ReferenceWithMetaPortfolioState getTradePortfolio();

    public ZonedDateTime getValuationDateTime();

    default public RosettaMetaData<? extends Exposure> metaData() {
        return metaData;
    }

    public static ExposureBuilder builder() {
        return new ExposureBuilderImpl();
    }

    default public Class<? extends Exposure> getType() {
        return Exposure.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculationDateTime"), ZonedDateTime.class, (Object)this.getCalculationDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationDateTime"), ZonedDateTime.class, (Object)this.getValuationDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("aggregateValue"), processor, Money.class, this.getAggregateValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradePortfolio"), processor, ReferenceWithMetaPortfolioState.class, this.getTradePortfolio(), new AttributeMeta[0]);
    }

    public static class ExposureBuilderImpl
    implements ExposureBuilder {
        protected Money.MoneyBuilder aggregateValue;
        protected ZonedDateTime calculationDateTime;
        protected ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder tradePortfolio;
        protected ZonedDateTime valuationDateTime;

        @Override
        public Money.MoneyBuilder getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAggregateValue() {
            Money.MoneyBuilder result = this.aggregateValue != null ? this.aggregateValue : (this.aggregateValue = Money.builder());
            return result;
        }

        @Override
        public ZonedDateTime getCalculationDateTime() {
            return this.calculationDateTime;
        }

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getTradePortfolio() {
            return this.tradePortfolio;
        }

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreateTradePortfolio() {
            ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder result = this.tradePortfolio != null ? this.tradePortfolio : (this.tradePortfolio = ReferenceWithMetaPortfolioState.builder());
            return result;
        }

        @Override
        public ZonedDateTime getValuationDateTime() {
            return this.valuationDateTime;
        }

        @Override
        public ExposureBuilder setAggregateValue(Money aggregateValue) {
            this.aggregateValue = aggregateValue == null ? null : aggregateValue.toBuilder();
            return this;
        }

        @Override
        public ExposureBuilder setCalculationDateTime(ZonedDateTime calculationDateTime) {
            this.calculationDateTime = calculationDateTime == null ? null : calculationDateTime;
            return this;
        }

        @Override
        public ExposureBuilder setTradePortfolio(ReferenceWithMetaPortfolioState tradePortfolio) {
            this.tradePortfolio = tradePortfolio == null ? null : tradePortfolio.toBuilder();
            return this;
        }

        @Override
        public ExposureBuilder setTradePortfolioValue(PortfolioState tradePortfolio) {
            this.getOrCreateTradePortfolio().setValue(tradePortfolio);
            return this;
        }

        @Override
        public ExposureBuilder setValuationDateTime(ZonedDateTime valuationDateTime) {
            this.valuationDateTime = valuationDateTime == null ? null : valuationDateTime;
            return this;
        }

        @Override
        public Exposure build() {
            return new ExposureImpl(this);
        }

        @Override
        public ExposureBuilder toBuilder() {
            return this;
        }

        @Override
        public ExposureBuilder prune() {
            if (this.aggregateValue != null && !this.aggregateValue.prune().hasData()) {
                this.aggregateValue = null;
            }
            if (this.tradePortfolio != null && !this.tradePortfolio.prune().hasData()) {
                this.tradePortfolio = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAggregateValue() != null && this.getAggregateValue().hasData()) {
                return true;
            }
            if (this.getCalculationDateTime() != null) {
                return true;
            }
            if (this.getTradePortfolio() != null && this.getTradePortfolio().hasData()) {
                return true;
            }
            return this.getValuationDateTime() != null;
        }

        public ExposureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExposureBuilder o = (ExposureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAggregateValue(), (RosettaModelObjectBuilder)o.getAggregateValue(), this::setAggregateValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradePortfolio(), (RosettaModelObjectBuilder)o.getTradePortfolio(), this::setTradePortfolio);
            merger.mergeBasic((Object)this.getCalculationDateTime(), (Object)o.getCalculationDateTime(), this::setCalculationDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationDateTime(), (Object)o.getValuationDateTime(), this::setValuationDateTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Exposure _that = this.getType().cast(o);
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.calculationDateTime, _that.getCalculationDateTime())) {
                return false;
            }
            if (!Objects.equals(this.tradePortfolio, _that.getTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.valuationDateTime, _that.getValuationDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDateTime != null ? this.calculationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.tradePortfolio != null ? this.tradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateTime != null ? this.valuationDateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExposureBuilder {aggregateValue=" + this.aggregateValue + ", calculationDateTime=" + this.calculationDateTime + ", tradePortfolio=" + this.tradePortfolio + ", valuationDateTime=" + this.valuationDateTime + '}';
        }
    }

    public static class ExposureImpl
    implements Exposure {
        private final Money aggregateValue;
        private final ZonedDateTime calculationDateTime;
        private final ReferenceWithMetaPortfolioState tradePortfolio;
        private final ZonedDateTime valuationDateTime;

        protected ExposureImpl(ExposureBuilder builder) {
            this.aggregateValue = Optional.ofNullable(builder.getAggregateValue()).map(f -> f.build()).orElse(null);
            this.calculationDateTime = builder.getCalculationDateTime();
            this.tradePortfolio = Optional.ofNullable(builder.getTradePortfolio()).map(f -> f.build()).orElse(null);
            this.valuationDateTime = builder.getValuationDateTime();
        }

        @Override
        public Money getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public ZonedDateTime getCalculationDateTime() {
            return this.calculationDateTime;
        }

        @Override
        public ReferenceWithMetaPortfolioState getTradePortfolio() {
            return this.tradePortfolio;
        }

        @Override
        public ZonedDateTime getValuationDateTime() {
            return this.valuationDateTime;
        }

        @Override
        public Exposure build() {
            return this;
        }

        @Override
        public ExposureBuilder toBuilder() {
            ExposureBuilder builder = Exposure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExposureBuilder builder) {
            Optional.ofNullable(this.getAggregateValue()).ifPresent(builder::setAggregateValue);
            Optional.ofNullable(this.getCalculationDateTime()).ifPresent(builder::setCalculationDateTime);
            Optional.ofNullable(this.getTradePortfolio()).ifPresent(builder::setTradePortfolio);
            Optional.ofNullable(this.getValuationDateTime()).ifPresent(builder::setValuationDateTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Exposure _that = this.getType().cast(o);
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.calculationDateTime, _that.getCalculationDateTime())) {
                return false;
            }
            if (!Objects.equals(this.tradePortfolio, _that.getTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.valuationDateTime, _that.getValuationDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDateTime != null ? this.calculationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.tradePortfolio != null ? this.tradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateTime != null ? this.valuationDateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Exposure {aggregateValue=" + this.aggregateValue + ", calculationDateTime=" + this.calculationDateTime + ", tradePortfolio=" + this.tradePortfolio + ", valuationDateTime=" + this.valuationDateTime + '}';
        }
    }

    public static interface ExposureBuilder
    extends Exposure,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAggregateValue();

        @Override
        public Money.MoneyBuilder getAggregateValue();

        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreateTradePortfolio();

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getTradePortfolio();

        public ExposureBuilder setAggregateValue(Money var1);

        public ExposureBuilder setCalculationDateTime(ZonedDateTime var1);

        public ExposureBuilder setTradePortfolio(ReferenceWithMetaPortfolioState var1);

        public ExposureBuilder setTradePortfolioValue(PortfolioState var1);

        public ExposureBuilder setValuationDateTime(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculationDateTime"), ZonedDateTime.class, (Object)this.getCalculationDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationDateTime"), ZonedDateTime.class, (Object)this.getValuationDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("aggregateValue"), processor, Money.MoneyBuilder.class, this.getAggregateValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradePortfolio"), processor, ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder.class, this.getTradePortfolio(), new AttributeMeta[0]);
        }

        public ExposureBuilder prune();
    }
}

